# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=libpng
VER=1.2.40
REV=1
ARCH=win64

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${THIS}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

ZLIB=`latest --arch=${ARCH} zlib`

usedev
usemingw64
usemsvs9x64

(

set -x

# Avoid the silly "relink" stuff in libtool
sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

patch -p0 <<'EOF' &&
--- Makefile.in
+++ Makefile.in
@@ -297,7 +297,7 @@
 
 libpng_la_SOURCES = $(libpng12_la_SOURCES)
 libpng_la_CPPFLAGS = @LIBPNG_DEFINES@
-libpng12_la_CPPFLAGS = @LIBPNG_DEFINES@
+libpng12_la_CPPFLAGS = @LIBPNG_DEFINES@ -DPNG_BUILD_DLL
 
 # MAJOR UPGRADE: the version-number settings below must be changed.
 libpng12_la_LDFLAGS = -no-undefined -export-dynamic \
@@ -1284,16 +1284,6 @@
 
 # do evil things to libpng to cause libpng12 to be used
 install-exec-hook:
-	cd $(DESTDIR)$(bindir); rm -f libpng-config
-	cd $(DESTDIR)$(bindir); $(LN_S) $(PNGLIB_BASENAME)-config libpng-config
-	@set -x;\
-	cd $(DESTDIR)$(libdir);\
-	for ext in a la so sl dylib; do\
-		rm -f libpng.$$ext;\
-                if test -f $(PNGLIB_BASENAME).$$ext; then\
-                       $(LN_S) $(PNGLIB_BASENAME).$$ext libpng.$$ext;\
-                fi;\
-	done
 
 uninstall-hook:
 	cd $(DESTDIR)$(includedir); rm -f png.h pngconf.h
--- pngconf.h
+++ pngconf.h
@@ -18,6 +18,8 @@
 #define PNGCONF_H
 
 #define PNG_1_2_X
+
+#define PNG_DLL /* Just force building and using a DLL. */
 
 /*
  * PNG_USER_CONFIG has to be defined on the compiler command line. This
EOF

# Brute force solution for problems with libtool: use
# lt_cv_deplibs_check_method= pass_all

lt_cv_deplibs_check_method='pass_all' \
CC='x86_64-w64-mingw32-gcc' \
CPPFLAGS="-I /devel/dist/win64/$ZLIB/include" \
LDFLAGS="-L/devel/dist/win64/$ZLIB/lib -Wl,--enable-auto-image-base" \
CFLAGS=-O2 \
./configure --host=x86_64-w64-mingw32 --disable-static --without-libpng-compat --without-binconfigs --prefix=$TARGET &&
make install &&

(cd /devel/target/$HEX &&
zip /tmp/$RUNZIP bin/libpng12-0.dll &&
zip -r -D /tmp/$DEVZIP include  &&
zip /tmp/$DEVZIP lib/libpng12.dll.a &&
(echo EXPORTS
link -dump -exports bin/libpng12-0.dll | grep -E '^ *[1-9][0-9]* *[0-9A-F][0-9A-F]* [0-9A-F][0-9A-F][0-9A-F][0-9A-F][0-9A-F][0-9A-F][0-9A-F][0-9A-F] ' | sed -e 's/^ *[^ ][^ ]* *[^ ][^ ]* ........ //' -e 's/ =.*//') >lib/libpng.def &&
lib -machine:X64 -def:lib/libpng.def -name:libpng12-0.dll -out:lib/libpng.lib &&
zip /tmp/$DEVZIP lib/libpng.def lib/libpng.lib &&
zip /tmp/$DEVZIP lib/pkgconfig/libpng*.pc &&
zip -r -D /tmp/$DEVZIP share/man
)

) 2>&1 | tee /devel/src/tml/packaging/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/packaging/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
