#pragma once

class CMACProcessFiles;
class IFormat;

class MAC_FILE
{
public:
    // construction / destruction
    MAC_FILE();

    // data
    CString strInputFilename;
    CString strOutputFilename;
    CString strWorkingFilename;
    double dInputFileBytes;
    double dOutputFileBytes;

    // processing info
    CMACProcessFiles * pMACProcessFiles;
    APE::APE_MODES Mode;
    int nStageProgress;
    bool bProcessing;
    bool bDone;
    bool bStarted;
    bool bNeedsUpdate;
    int nRetVal;
    TICK_COUNT_TYPE dwStartTickCount;
    TICK_COUNT_TYPE dwEndTickCount;
    CString strFormat;
    int nLevel;
    int nKillFlag;
    int nCurrentStage;
    int nTotalStages;
    IFormat * pFormat;
    bool bEmptyExtension;
    bool bOverwriteInput;

    // helpers
    bool PrepareForProcessing(CMACProcessFiles * pProcessFiles);
    void CalculateFilenames();
    double GetProgress() const;
    CString GetOutputExtension() const;
    inline bool GetNeverStarted() const { return (bDone == false) && (bStarted == false); }
    inline bool GetRunning() const { return (bDone == false) && (bStarted != false); }
};
