/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.launching.tests.testcase;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.xsl.launching.tests.AbstractLaunchingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Document;

public class XSLLaunchingTest
extends AbstractLaunchingTest {
    private static final String TRANSFORM_COMMENTS = "TransformComments";
    private static final String SIMPLE_TRANSFORM = "SimpleTransform";

    @Before
    public void setUp() throws Exception {
        super.setUp();
        IPath path = this.folder.getFullPath();
        this.copyConfigurationToWorkspace(path, "SimpleTransform.launch");
        this.copyConfigurationToWorkspace(path, "TransformComments.launch");
        this.testProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        while (!this.testProject.isSynchronized(2)) {
            Thread.sleep(100L);
        }
    }

    @After
    public void tearDown() throws Exception {
        this.env.dispose();
        super.tearDown();
    }

    @Ignore
    @Test
    public void testSimpleTransformation() throws Exception {
        IPath folder = this.testProject.getFullPath();
        this.env.addFileFromResource(folder, "1-input.xml", "1-input.xml");
        this.env.addFileFromResource(folder, "1-transform.xsl", "1-transform.xsl");
        this.refreshProject();
        this.launchConfiguration(SIMPLE_TRANSFORM);
        IFile output = this.testProject.getFile("1-input.out.xml");
        Document doc = this.parseXml(output.getContents(true));
        Assert.assertEquals((Object)"root-out", (Object)doc.getDocumentElement().getNodeName());
    }

    @Ignore
    @Test
    public void testTransformComments() throws Exception {
        IPath folder = this.testProject.getFullPath();
        this.env.addFileFromResource(folder, "testCommentInput.xml", "testCommentInput.xml");
        this.env.addFileFromResource(folder, "testComments.xsl", "testComments.xsl");
        this.env.addFileFromResource(folder, "expected.xml", "testCommentsExpected.xml");
        this.refreshProject();
        this.launchConfiguration(TRANSFORM_COMMENTS);
        IFile output = this.testProject.getFile("testCommentInput.out.xml");
        IFile expected = this.testProject.getFile("expected.xml");
        String result = this.readFile(output.getContents());
        String wanted = this.readFile(expected.getContents());
        Assert.assertEquals((String)"Unexpected results:", (Object)wanted, (Object)result);
    }
}

