/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.catalog.tests.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xml.catalog.tests.internal.TestPlugin;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.CatalogContributorRegistryReader;
import org.eclipse.wst.xml.core.internal.catalog.CatalogSet;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.osgi.framework.Bundle;

public abstract class AbstractCatalogTest
extends TestCase {
    private CatalogSet catalogSet = new CatalogSet();
    protected ICatalog systemCatalog;
    protected ICatalog userCatalog;
    protected ICatalog defaultCatalog;

    public AbstractCatalogTest(String name) {
        super(name);
    }

    protected static List getCatalogEntries(ICatalog catalog, int entryType) {
        ArrayList<ICatalogEntry> result = new ArrayList<ICatalogEntry>();
        ICatalogEntry[] entries = catalog.getCatalogEntries();
        int i = 0;
        while (i < entries.length) {
            ICatalogEntry entry = entries[i];
            if (entry.getEntryType() == entryType) {
                result.add(entry);
            }
            ++i;
        }
        return result;
    }

    protected ICatalog getCatalog(String id, String uriString) throws Exception {
        return this.catalogSet.lookupOrCreateCatalog(id, uriString);
    }

    public void initCatalogs() {
        this.defaultCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        INextCatalog[] nextCatalogs = this.defaultCatalog.getNextCatalogs();
        int i = 0;
        while (i < nextCatalogs.length) {
            INextCatalog catalog = nextCatalogs[i];
            ICatalog referencedCatalog = catalog.getReferencedCatalog();
            if (referencedCatalog != null) {
                if ("system_catalog".equals(referencedCatalog.getId())) {
                    this.systemCatalog = referencedCatalog;
                } else if ("user_catalog".equals(referencedCatalog.getId())) {
                    this.userCatalog = referencedCatalog;
                }
            }
            ++i;
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.initCatalogs();
    }

    protected static String makeAbsolute(String baseLocation, String location) {
        URL local = null;
        location = location.replace('\\', '/');
        try {
            URL baseURL = new URL(baseLocation);
            local = new URL(baseURL, location);
        }
        catch (MalformedURLException malformedURLException) {}
        if (local != null) {
            return local.toString();
        }
        return location;
    }

    protected static URL resolvePluginLocation(String pluginId) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle != null) {
            URL bundleEntry = bundle.getEntry("/");
            try {
                return FileLocator.resolve((URL)bundleEntry);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected String resolvePath(String pluginId, String path) {
        return CatalogContributorRegistryReader.resolvePath((URL)CatalogContributorRegistryReader.getPlatformURL((String)pluginId), (String)path);
    }

    protected String getFileLocation(String path) {
        String result = null;
        try {
            result = FileLocator.toFileURL((URL)FileLocator.find((Bundle)TestPlugin.getDefault().getBundle(), (IPath)new Path(path), null)).toString();
        }
        catch (IOException iOException) {}
        return URIHelper.ensureFileURIProtocolFormat(result);
    }
}

