/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.tests.encoding.css;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import junit.framework.TestCase;
import org.eclipse.wst.css.core.internal.contenttype.CSSResourceEncodingDetector;
import org.eclipse.wst.css.tests.encoding.CSSEncodingTestsPlugin;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.IResourceCharsetDetector;

public class CSSEncodingTester
extends TestCase {
    private boolean DEBUG = false;
    private final String fileDir = "css/";
    private final String fileHome = "testfiles/";
    private final String fileLocation = "testfiles/css/";
    private int READ_BUFFER_SIZE = 8000;

    private static InputStream getMarkSupportedStream(InputStream original) {
        if (original == null) {
            return null;
        }
        if (original.markSupported()) {
            return original;
        }
        return new BufferedInputStream(original);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doTestFileStream(String filename, String expectedIANAEncoding, IResourceCharsetDetector detector) throws IOException {
        FileInputStream inputStream;
        block7: {
            File file = CSSEncodingTestsPlugin.getTestFile(filename);
            if (!file.exists()) {
                throw new IllegalArgumentException(String.valueOf(filename) + " was not found");
            }
            inputStream = new FileInputStream(file);
            InputStream istream = CSSEncodingTester.getMarkSupportedStream(inputStream);
            try {
                detector.set(istream);
                EncodingMemento encodingMemento = ((CSSResourceEncodingDetector)detector).getEncodingMemento();
                String foundIANAEncoding = null;
                if (encodingMemento != null) {
                    foundIANAEncoding = encodingMemento.getDetectedCharsetName();
                }
                boolean expectedIANAResult = false;
                expectedIANAResult = expectedIANAEncoding == null ? expectedIANAEncoding == foundIANAEncoding : expectedIANAEncoding.equalsIgnoreCase(foundIANAEncoding);
                CSSEncodingTester.assertTrue((String)("encoding test file " + filename + " expected: " + expectedIANAEncoding + " found: " + foundIANAEncoding), (boolean)expectedIANAResult);
                if (foundIANAEncoding != null) {
                    this.ensureCanRead(filename, foundIANAEncoding, istream);
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (istream != null) {
                    istream.close();
                }
                if (inputStream == null) throw throwable;
                ((InputStream)inputStream).close();
                throw throwable;
            }
            {
                Object var10_12 = null;
                if (istream == null) break block7;
            }
            istream.close();
        }
        if (inputStream == null) return;
        ((InputStream)inputStream).close();
    }

    private void ensureCanRead(String filename, String encoding, InputStream inputStream) throws IOException {
        Charset charset = Charset.forName(encoding);
        CharsetDecoder charsetDecoder = charset.newDecoder();
        charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
        charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        InputStreamReader reader = new InputStreamReader(inputStream, charsetDecoder);
        StringBuffer stringBuffer = this.readInputStream(reader);
        if (this.DEBUG) {
            System.out.println();
            System.out.println(filename);
            System.out.println(stringBuffer.toString());
        }
    }

    private StringBuffer readInputStream(Reader reader) throws IOException {
        StringBuffer buffer = new StringBuffer();
        int numRead = 0;
        char[] tBuff = new char[this.READ_BUFFER_SIZE];
        while ((numRead = reader.read(tBuff, 0, tBuff.length)) != -1) {
            buffer.append(tBuff, 0, numRead);
        }
        return buffer;
    }

    public void testBestCase() throws IOException {
        String filename = "testfiles/css/nonStandard.css";
        this.doTestFileStream(filename, "ISO-8859-6", (IResourceCharsetDetector)new CSSResourceEncodingDetector());
    }

    public void testEmptyFile() throws IOException {
        String filename = "testfiles/css/emptyFile.css";
        this.doTestFileStream(filename, null, (IResourceCharsetDetector)new CSSResourceEncodingDetector());
    }

    public void testEUCJP() throws IOException {
        String filename = "testfiles/css/encoding_test_eucjp.css";
        this.doTestFileStream(filename, "EUC-JP", (IResourceCharsetDetector)new CSSResourceEncodingDetector());
    }

    public void testJIS() throws IOException {
        String filename = "testfiles/css/encoding_test_jis.css";
        this.doTestFileStream(filename, "ISO-2022-JP", (IResourceCharsetDetector)new CSSResourceEncodingDetector());
    }

    public void testNoEncoding() throws IOException {
        String filename = "testfiles/css/noEncoding.css";
        this.doTestFileStream(filename, null, (IResourceCharsetDetector)new CSSResourceEncodingDetector());
    }

    public void testnonStandardIllFormed() throws IOException {
        String filename = "testfiles/css/nonStandardIllFormed.css";
        this.doTestFileStream(filename, "ISO-8859-6", (IResourceCharsetDetector)new CSSResourceEncodingDetector());
    }

    public void testnonStandardIllFormed2() throws IOException {
        String filename = "testfiles/css/nonStandardIllFormed2.css";
        this.doTestFileStream(filename, "ISO-8859-6", (IResourceCharsetDetector)new CSSResourceEncodingDetector());
    }

    public void testShiftJIS() throws IOException {
        String filename = "testfiles/css/encoding_test_sjis.css";
        this.doTestFileStream(filename, "SHIFT_JIS", (IResourceCharsetDetector)new CSSResourceEncodingDetector());
    }

    public void testUTF16be() throws IOException {
        String filename = "testfiles/css/utf16be.css";
        this.doTestFileStream(filename, "UTF-16BE", (IResourceCharsetDetector)new CSSResourceEncodingDetector());
    }

    public void testUTF16le() throws IOException {
        String filename = "testfiles/css/utf16le.css";
        this.doTestFileStream(filename, "UTF-16LE", (IResourceCharsetDetector)new CSSResourceEncodingDetector());
    }

    public void testUTF16beMalformed() throws IOException {
        String filename = "testfiles/css/utf16beMalformed.css";
        this.doTestFileStream(filename, "UTF-16BE", (IResourceCharsetDetector)new CSSResourceEncodingDetector());
    }

    public void testUTF16leMalformed() throws IOException {
        String filename = "testfiles/css/utf16leMalformed.css";
        this.doTestFileStream(filename, "UTF-16LE", (IResourceCharsetDetector)new CSSResourceEncodingDetector());
    }

    public void testUTF16BOM() throws IOException {
        String filename = "testfiles/css/utf16BOM.css";
        this.doTestFileStream(filename, "UTF-16", (IResourceCharsetDetector)new CSSResourceEncodingDetector());
    }
}

