/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.wst.wsdl.validation.internal.IValidationMessage;

public class ValidationMessageImpl
implements IValidationMessage {
    protected String message;
    protected int lineNumber;
    protected int columnNumber;
    protected String uri;
    protected int severity = 0;
    protected List nestedErrors;
    protected String errorKey = null;
    protected Object[] messageArguments = null;

    public ValidationMessageImpl(String message, int lineNumber, int columnNumber, int severity) {
        this(message, lineNumber, columnNumber, severity, null);
    }

    public ValidationMessageImpl(String message, int lineNumber, int columnNumber, int severity, String uri) {
        this(message, lineNumber, columnNumber, severity, uri, null, null);
    }

    public ValidationMessageImpl(String message, int lineNumber, int columnNumber, int severity, String uri, String errorKey, Object[] messageArguments) {
        this.message = message;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.severity = severity;
        this.uri = uri;
        this.errorKey = errorKey;
        this.messageArguments = messageArguments;
    }

    public String getMessage() {
        return this.message;
    }

    public int getColumn() {
        return this.columnNumber;
    }

    public int getLine() {
        return this.lineNumber;
    }

    public String getURI() {
        return this.uri;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int severity) {
        if (severity == 0 || severity == 1) {
            this.severity = severity;
        }
    }

    public void addNestedMessage(IValidationMessage validationMessage) {
        if (this.nestedErrors == null) {
            this.nestedErrors = new ArrayList();
        }
        this.nestedErrors.add(validationMessage);
        int validaitonmessageSeverity = validationMessage.getSeverity();
        if (validaitonmessageSeverity == 0) {
            this.setSeverity(0);
        }
    }

    public List getNestedMessages() {
        return this.nestedErrors != null ? this.nestedErrors : Collections.EMPTY_LIST;
    }

    public String getErrorKey() {
        return this.errorKey;
    }

    public void setErrorKey(String errorKey) {
        this.errorKey = errorKey;
    }

    public Object[] getMessageArguments() {
        return this.messageArguments;
    }
}

