/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.refactoring.descriptors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaScriptRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.core.refactoring.descriptors.DescriptorMessages;

public final class UseSupertypeDescriptor
extends JavaScriptRefactoringDescriptor {
    private static final String ATTRIBUTE_INSTANCEOF = "instanceof";
    private boolean fInstanceof = false;
    private IType fSubType = null;
    private IType fSupertype = null;

    public UseSupertypeDescriptor() {
        super("org.eclipse.wst.jsdt.ui.use.supertype");
    }

    @Override
    protected void populateArgumentMap() {
        super.populateArgumentMap();
        this.fArguments.put(ATTRIBUTE_INSTANCEOF, Boolean.valueOf(this.fInstanceof).toString());
        this.fArguments.put("input", UseSupertypeDescriptor.elementToHandle(this.getProject(), (IJavaScriptElement)this.fSubType));
        this.fArguments.put("element1", UseSupertypeDescriptor.elementToHandle(this.getProject(), (IJavaScriptElement)this.fSupertype));
    }

    public void setReplaceInstanceof(boolean replace) {
        this.fInstanceof = replace;
    }

    public void setSubtype(IType type) {
        Assert.isNotNull((Object)type);
        this.fSubType = type;
    }

    public void setSupertype(IType type) {
        Assert.isNotNull((Object)type);
        this.fSupertype = type;
    }

    @Override
    public RefactoringStatus validateDescriptor() {
        RefactoringStatus status = super.validateDescriptor();
        if (this.fSubType == null) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.UseSupertypeDescriptor_no_subtype));
        }
        if (this.fSupertype == null) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.UseSupertypeDescriptor_no_supertype));
        }
        return status;
    }
}

