/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.eclipse.jem.internal.beaninfo.common.InvalidObject;
import org.eclipse.jem.internal.proxy.common.MapTypes;

public class FeatureAttributeValue
implements Serializable {
    private transient Object value;
    private transient Object internalValue;
    private boolean implicitValue;
    private static final long serialVersionUID = 1105717634844L;
    private static final Pattern QUOTE = Pattern.compile("\"");
    private static final String NULL = "null";
    private static final String INVALID = "INV";
    private static final String IMPLICIT = "implicit,";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    public FeatureAttributeValue(String initString) {
        if (initString.startsWith(IMPLICIT)) {
            this.setImplicitValue(true);
            initString = initString.substring(IMPLICIT.length());
        }
        this.value = FeatureAttributeValue.parseString(initString);
    }

    public FeatureAttributeValue() {
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
        this.setInternalValue(null);
    }

    public void setInternalValue(Object internalValue) {
        this.internalValue = internalValue;
    }

    public Object getInternalValue() {
        return this.internalValue;
    }

    public String toString() {
        if (this.value == null) {
            return super.toString();
        }
        StringBuffer out = new StringBuffer(100);
        if (this.isImplicitValue()) {
            out.append(IMPLICIT);
        }
        FeatureAttributeValue.makeString(this.value, out);
        return out.toString();
    }

    public static String makeString(Object value) {
        StringBuffer out = new StringBuffer(100);
        FeatureAttributeValue.makeString(value, out);
        return out.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void makeString(Object value, StringBuffer out) {
        if (value == null) {
            out.append(NULL);
            return;
        }
        if (value instanceof String || value instanceof Class) {
            String str;
            out.append('\"');
            String string = str = value instanceof String ? (String)value : ((Class)value).getName();
            if (str.indexOf(34) != -1) {
                out.append(QUOTE.matcher(str).replaceAll("\\\\\""));
            } else {
                out.append(str);
            }
            out.append('\"');
            return;
        }
        if (value instanceof Number) {
            out.append(value);
            return;
        }
        if (value instanceof Boolean) {
            out.append(value);
            return;
        }
        if (value instanceof Character) {
            out.append('\'');
            Character c = (Character)value;
            if (c.charValue() != '\'') {
                out.append(c.charValue());
            } else {
                out.append("\\'");
            }
            out.append('\'');
            return;
        }
        if (!value.getClass().isArray()) {
            out.append(INVALID);
            return;
        }
        Class<?> type = value.getClass();
        Class<?> ft = type.getComponentType();
        int dims = 1;
        while (ft.isArray()) {
            ++dims;
            ft = ft.getComponentType();
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (ft != clazz) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (ft != clazz2) {
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (ft != clazz3) {
                    Class<?> clazz4 = class$3;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$3 = Class.forName("java.lang.Character");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (ft != clazz4 && !ft.isPrimitive()) {
                        Class<?> clazz5 = class$4;
                        if (clazz5 == null) {
                            try {
                                clazz5 = class$4 = Class.forName("java.lang.Number");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (!clazz5.isAssignableFrom(ft)) {
                            out.append(INVALID);
                            return;
                        }
                    }
                }
            }
        }
        out.append('[');
        int length = Array.getLength(value);
        out.append(length);
        out.append(']');
        while (--dims > 0) {
            out.append("[]");
        }
        out.append('{');
        int i = 0;
        while (i < length) {
            if (i != 0) {
                out.append(',');
            }
            FeatureAttributeValue.makeString(Array.get(value, i), out);
            ++i;
        }
        out.append('}');
    }

    public static Object parseString(String input) {
        return FeatureAttributeValue.parseString(new StringParser(input));
    }

    /*
     * Unable to fully structure code
     */
    private static Object parseString(StringParser parser) {
        block59: {
            parser.skipWhitespace();
            if (parser.atEnd()) break block59;
            c = parser.read();
            switch (c) {
                case '\"': {
                    start = parser.nextIndex();
                    dequoted = null;
                    dequoteIndex = 0;
                    while (!parser.atEnd()) {
                        cc = parser.read();
                        if (cc == '\"') {
                            if (dequoted == null) {
                                return parser.getInput().substring(start, parser.nextIndex() - 1);
                            }
                            endNdx = parser.nextIndex() - 1;
                            parser.getInput().getChars(start, endNdx, dequoted, dequoteIndex);
                            return new String(dequoted, 0, dequoteIndex += endNdx - start);
                        }
                        if (cc != '\\' || parser.peek() != '\"') continue;
                        if (dequoted == null) {
                            dequoted = new char[parser.getLength()];
                        }
                        endNdx = parser.nextIndex() - 1;
                        parser.getInput().getChars(start, endNdx, dequoted, dequoteIndex);
                        dequoteIndex += endNdx - start;
                        dequoted[dequoteIndex++] = parser.read();
                        start = parser.nextIndex();
                    }
                    break;
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    numberComplete = false;
                    floatType = false;
                    foundE = false;
                    foundESign = false;
                    start = parser.nextIndex() - 1;
                    while (!parser.atEnd() && !numberComplete) {
                        cc = parser.read();
                        switch (cc) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                break;
                            }
                            case '.': {
                                if (floatType) {
                                    return InvalidObject.INSTANCE;
                                }
                                floatType = true;
                                break;
                            }
                            case 'E': 
                            case 'e': {
                                if (foundE) {
                                    return InvalidObject.INSTANCE;
                                }
                                foundE = true;
                                floatType = true;
                                break;
                            }
                            case '+': 
                            case '-': {
                                if (!foundE || foundESign) {
                                    return InvalidObject.INSTANCE;
                                }
                                foundESign = true;
                                break;
                            }
                            default: {
                                parser.backup();
                                numberComplete = true;
                            }
                        }
                    }
                    try {
                        if (!floatType) {
                            return Long.valueOf(parser.getInput().substring(start, parser.nextIndex()));
                        }
                        return Double.valueOf(parser.getInput().substring(start, parser.nextIndex()));
                    }
                    catch (NumberFormatException v0) {
                        break;
                    }
                }
                case 'F': 
                case 'T': 
                case 'f': 
                case 't': {
                    if (parser.getInput().regionMatches(true, parser.nextIndex() - 1, "true", 0, 4)) {
                        parser.skip(3);
                        return Boolean.TRUE;
                    }
                    if (!parser.getInput().regionMatches(true, parser.nextIndex() - 1, "false", 0, 5)) break;
                    parser.skip(4);
                    return Boolean.FALSE;
                }
                case '\'': {
                    cc = parser.read();
                    if (cc == '\\') {
                        cc = parser.read();
                    } else if (cc == '\'') break;
                    if (parser.peek() != '\'') break;
                    parser.read();
                    return new Character(cc);
                }
                case 'n': {
                    if (!parser.getInput().regionMatches(parser.nextIndex() - 1, "null", 0, 4)) break;
                    parser.skip(3);
                    return null;
                }
                case 'I': {
                    if (!parser.getInput().regionMatches(parser.nextIndex() - 1, "INV", 0, "INV".length())) break;
                    parser.skip("INV".length() - 1);
                    return InvalidObject.INSTANCE;
                }
                case '[': {
                    size = FeatureAttributeValue.parseString(parser);
                    if (!(size instanceof Long)) break;
                    parser.skipWhitespace();
                    cc = parser.read();
                    if (cc != ']') break;
                    dim = 1;
                    valid = true;
                    while (true) {
                        parser.skipWhitespace();
                        cc = parser.read();
                        if (cc != '[') ** GOTO lbl109
                        parser.skipWhitespace();
                        cc = parser.read();
                        if (cc != ']') break;
                        ++dim;
                    }
                    valid = false;
                    parser.backup();
                    ** GOTO lbl110
lbl109:
                    // 1 sources

                    parser.backup();
lbl110:
                    // 2 sources

                    if (!valid) break;
                    parser.skipWhitespace();
                    cc = parser.read();
                    if (cc != '{') break;
                    dims = new int[dim];
                    dims[0] = len = ((Long)size).intValue();
                    v1 = FeatureAttributeValue.class$0;
                    if (v1 == null) {
                        try {
                            v1 = FeatureAttributeValue.class$0 = Class.forName("java.lang.Object");
                        }
                        catch (ClassNotFoundException v2) {
                            throw new NoClassDefFoundError(v2.getMessage());
                        }
                    }
                    array = Array.newInstance(v1, dims);
                    Arrays.fill((Object[])array, null);
                    invSetting = null;
                    entry = FeatureAttributeValue.parseString(parser);
                    compType = array.getClass().getComponentType();
                    i = -1;
                    while (true) {
                        if (++i < len) {
                            if (compType.isInstance(entry)) {
                                Array.set(array, i, entry);
                            } else {
                                if (invSetting == null) {
                                    if (dim == 1) {
                                        invSetting = InvalidObject.INSTANCE;
                                    } else {
                                        invDims = new int[dim - 1];
                                        Arrays.fill(invDims, 1);
                                        v3 = FeatureAttributeValue.class$0;
                                        if (v3 == null) {
                                            try {
                                                v3 = Class.forName("java.lang.Object");
                                            }
                                            catch (ClassNotFoundException v4) {
                                                throw new NoClassDefFoundError(v4.getMessage());
                                            }
                                        }
                                        finalEntry = invSetting = Array.newInstance(v3, invDims);
                                        j = invDims.length - 1;
                                        while (j > 0) {
                                            finalEntry = Array.get(finalEntry, 0);
                                            --j;
                                        }
                                        Array.set(finalEntry, 0, InvalidObject.INSTANCE);
                                    }
                                }
                                Array.set(array, i, invSetting);
                            }
                        }
                        parser.skipWhitespace();
                        cc = parser.read();
                        if (cc == ',') {
                            entry = FeatureAttributeValue.parseString(parser);
                            continue;
                        }
                        if (cc == '}') ** GOTO lbl209
                        if (parser.atEnd()) break;
                        parser.backup();
                        entry = FeatureAttributeValue.parseString(parser);
                    }
                    e = new IllegalStateException(parser.toString());
                    try {
                        biPluginClass = Class.forName("org.eclipse.jem.internal.beaninfo.core.BeaninfoPlugin");
                        getPlugin = biPluginClass.getMethod("getPlugin", null);
                        getLogger = biPluginClass.getMethod("getLogger", null);
                        v5 = getLogger.getReturnType();
                        v6 = new Class[2];
                        v7 = FeatureAttributeValue.class$5;
                        if (v7 == null) {
                            try {
                                v7 = FeatureAttributeValue.class$5 = Class.forName("java.lang.Throwable");
                            }
                            catch (ClassNotFoundException v8) {
                                throw new NoClassDefFoundError(v8.getMessage());
                            }
                        }
                        v6[0] = v7;
                        v9 = FeatureAttributeValue.class$6;
                        if (v9 == null) {
                            try {
                                v9 = FeatureAttributeValue.class$6 = Class.forName("java.util.logging.Level");
                            }
                            catch (ClassNotFoundException v10) {
                                throw new NoClassDefFoundError(v10.getMessage());
                            }
                        }
                        v6[1] = v9;
                        log = v5.getMethod("log", v6);
                        biPlugin = getPlugin.invoke(null, null);
                        logger = getLogger.invoke(biPlugin, null);
                        log.invoke(logger, new Object[]{e, Level.WARNING});
                        return InvalidObject.INSTANCE;
                    }
                    catch (SecurityException v11) {
                    }
                    catch (IllegalArgumentException v12) {
                    }
                    catch (ClassNotFoundException v13) {
                    }
                    catch (NoSuchMethodException v14) {
                    }
                    catch (IllegalAccessException v15) {
                    }
                    catch (InvocationTargetException v16) {
                    }
                    catch (NullPointerException v17) {}
                    e.printStackTrace();
                    return InvalidObject.INSTANCE;
lbl209:
                    // 1 sources

                    return array;
                }
            }
        }
        return InvalidObject.INSTANCE;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeObject(this.value, out);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeObject(Object value, ObjectOutputStream out) throws IOException {
        block36: {
            int dims;
            block35: {
                if (value == null) {
                    out.writeObject(value);
                    return;
                }
                if (value instanceof Class) {
                    out.writeObject(((Class)value).getName());
                    return;
                }
                if (!value.getClass().isArray()) {
                    if (value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Character) {
                        out.writeObject(value);
                        return;
                    } else {
                        out.writeObject(InvalidObject.INSTANCE);
                    }
                    return;
                }
                Class<?> type = value.getClass();
                Class<?> ft = type.getComponentType();
                dims = 1;
                while (ft.isArray()) {
                    ++dims;
                    ft = ft.getComponentType();
                }
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (ft == clazz) break block35;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (ft == clazz2) break block35;
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (ft == clazz3) break block35;
                Class<?> clazz4 = class$3;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$3 = Class.forName("java.lang.Character");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (ft == clazz4 || ft.isPrimitive()) break block35;
                Class<?> clazz5 = class$7;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$7 = Class.forName("java.lang.Class");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (ft == clazz5) break block35;
                Class<?> clazz6 = class$4;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$4 = Class.forName("java.lang.Number");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz6.isAssignableFrom(ft)) break block36;
            }
            String jniType = dims == 1 ? "java.lang.Object" : MapTypes.getJNITypeName((String)"java.lang.Object", (int)(dims - 1));
            try {
                Class<?> componentType = Class.forName(jniType);
                out.writeObject(componentType);
                int length = Array.getLength(value);
                out.writeInt(length);
                int i = 0;
                while (i < length) {
                    this.writeObject(Array.get(value, i), out);
                    ++i;
                }
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {}
            return;
        }
        out.writeObject(InvalidObject.INSTANCE);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.value = this.readActualObject(in);
    }

    private Object readActualObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object val = in.readObject();
        if (val instanceof Class) {
            int length = in.readInt();
            Object array = Array.newInstance((Class)val, length);
            int i = 0;
            while (i < length) {
                Array.set(array, i, this.readActualObject(in));
                ++i;
            }
            return array;
        }
        return val;
    }

    public boolean isImplicitValue() {
        return this.implicitValue;
    }

    public void setImplicitValue(boolean implicitValue) {
        this.implicitValue = implicitValue;
    }

    private static class StringParser {
        private int next = 0;
        private int length;
        private String input;

        public StringParser(String input) {
            this.input = input;
            this.length = input.length();
        }

        public String toString() {
            return "StringParser: \"" + this.input + '\"';
        }

        public void skipWhitespace() {
            while (this.next < this.length) {
                if (Character.isWhitespace(this.input.charAt(this.next++))) continue;
                --this.next;
                break;
            }
        }

        public int nextIndex() {
            return this.next;
        }

        public int getLength() {
            return this.length;
        }

        public char read() {
            return this.next < this.length ? this.input.charAt(this.next++) : (char)'\u0000';
        }

        public void backup() {
            if (--this.next < 0) {
                this.next = 0;
            }
        }

        public char peek() {
            return this.next < this.length ? this.input.charAt(this.next) : (char)'\u0000';
        }

        public boolean atEnd() {
            return this.next >= this.length;
        }

        public void skip(int skip) {
            if ((this.next += skip) > this.length) {
                this.next = this.length;
            }
        }

        public String getInput() {
            return this.input;
        }
    }
}

