/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.tests.contentassist;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.html.ui.StructuredTextViewerConfigurationHTML;
import org.eclipse.wst.html.ui.tests.ProjectUtil;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;

public class TestEmbededCSSContentAssistComputers
extends TestCase {
    private static final String PROJECT_NAME = "TestEmbededCSSContentAssistComputers";
    private static final String JAVA_SCRIPT_NATURE_ID = "org.eclipse.wst.jsdt.core.jsNature";
    private static final String PROJECT_FILES = "/testresources/contentassist";
    private static IProject fProject;
    private static Map fFileToEditorMap;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        fFileToEditorMap = new HashMap();
    }

    public TestEmbededCSSContentAssistComputers() {
        super("Test Embeded CSS Content Assist Computers");
    }

    public TestEmbededCSSContentAssistComputers(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.html.ui.tests.contentassist.TestEmbededCSSContentAssistComputers");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite ts = new TestSuite((Class)clazz, "Test Embeded CSS Content Assist Computers");
        return new TestEmbededCSSContentAssistComputersSetup((Test)ts);
    }

    public void testSelectorProposals_StyleTag() throws Exception {
        int[] nArray = new int[4];
        nArray[0] = 90;
        nArray[2] = 90;
        nArray[3] = 90;
        int[] expectedProposalCounts = nArray;
        TestEmbededCSSContentAssistComputers.runProposalTest("test3.html", 9, 0, expectedProposalCounts);
    }

    public void testDeclarationPropertyProposals_StyleTag() throws Exception {
        int[] nArray = new int[4];
        nArray[0] = 122;
        nArray[2] = 122;
        nArray[3] = 122;
        int[] expectedProposalCounts = nArray;
        TestEmbededCSSContentAssistComputers.runProposalTest("test3.html", 12, 0, expectedProposalCounts);
    }

    public void testDeclarationValueProposals_StyleTag() throws Exception {
        int[] nArray = new int[4];
        nArray[0] = 11;
        nArray[2] = 11;
        nArray[3] = 11;
        int[] expectedProposalCounts = nArray;
        TestEmbededCSSContentAssistComputers.runProposalTest("test3.html", 13, 16, expectedProposalCounts);
    }

    public void testFinishSelectorProposals_StyleTag() throws Exception {
        int[] nArray = new int[4];
        nArray[0] = 20;
        nArray[2] = 20;
        nArray[3] = 20;
        int[] expectedProposalCounts = nArray;
        TestEmbededCSSContentAssistComputers.runProposalTest("test3.html", 24, 1, expectedProposalCounts);
    }

    public void testFinishDeclarationProposals_StyleTag() throws Exception {
        int[] nArray = new int[4];
        nArray[0] = 4;
        nArray[2] = 4;
        nArray[3] = 4;
        int[] expectedProposalCounts = nArray;
        TestEmbededCSSContentAssistComputers.runProposalTest("test3.html", 17, 14, expectedProposalCounts);
    }

    public void testFinishDeclarationValueProposals_StyleTag() throws Exception {
        int[] nArray = new int[4];
        nArray[0] = 4;
        nArray[2] = 4;
        nArray[3] = 4;
        int[] expectedProposalCounts = nArray;
        TestEmbededCSSContentAssistComputers.runProposalTest("test3.html", 21, 23, expectedProposalCounts);
    }

    public void testDeclarationPropertyProposals_SpacedQuotes_StyleAttribute() throws Exception {
        int[] nArray = new int[4];
        nArray[0] = 122;
        nArray[2] = 122;
        nArray[3] = 122;
        int[] expectedProposalCounts = nArray;
        TestEmbededCSSContentAssistComputers.runProposalTest("test3.html", 31, 14, expectedProposalCounts);
    }

    public void testDeclarationPropertyProposals_EmptyQuotes_StyleAttribute() throws Exception {
        int[] nArray = new int[4];
        nArray[0] = 122;
        nArray[2] = 122;
        nArray[3] = 122;
        int[] expectedProposalCounts = nArray;
        TestEmbededCSSContentAssistComputers.runProposalTest("test3.html", 33, 12, expectedProposalCounts);
    }

    public void testDeclarationValueProposals_StyleAttribute() throws Exception {
        int[] nArray = new int[4];
        nArray[0] = 11;
        nArray[2] = 11;
        nArray[3] = 11;
        int[] expectedProposalCounts = nArray;
        TestEmbededCSSContentAssistComputers.runProposalTest("test3.html", 35, 26, expectedProposalCounts);
    }

    public void testFinishDeclarationProposals_StyleAttribute() throws Exception {
        int[] nArray = new int[4];
        nArray[0] = 4;
        nArray[2] = 4;
        nArray[3] = 4;
        int[] expectedProposalCounts = nArray;
        TestEmbededCSSContentAssistComputers.runProposalTest("test3.html", 37, 25, expectedProposalCounts);
    }

    public void testFinishDeclarationValueProposals_StyleAttribute() throws Exception {
        int[] nArray = new int[4];
        nArray[0] = 4;
        nArray[2] = 4;
        nArray[3] = 4;
        int[] expectedProposalCounts = nArray;
        TestEmbededCSSContentAssistComputers.runProposalTest("test3.html", 39, 34, expectedProposalCounts);
    }

    public void testDeclarationPropertyProposals_AfterSemicolon_NoSpace_StyleAttribute() throws Exception {
        int[] nArray = new int[4];
        nArray[0] = 122;
        nArray[2] = 122;
        nArray[3] = 122;
        int[] expectedProposalCounts = nArray;
        TestEmbededCSSContentAssistComputers.runProposalTest("test3.html", 41, 40, expectedProposalCounts);
    }

    public void testDeclarationPropertyProposals_AfterSemicolon_BeforeSpace_StyleAttribute() throws Exception {
        int[] nArray = new int[4];
        nArray[0] = 122;
        nArray[2] = 122;
        nArray[3] = 122;
        int[] expectedProposalCounts = nArray;
        TestEmbededCSSContentAssistComputers.runProposalTest("test3.html", 43, 40, expectedProposalCounts);
    }

    public void testDeclarationPropertyProposals_AfterSemicolon_AfterSpace_StyleAttribute() throws Exception {
        int[] nArray = new int[4];
        nArray[0] = 122;
        nArray[2] = 122;
        nArray[3] = 122;
        int[] expectedProposalCounts = nArray;
        TestEmbededCSSContentAssistComputers.runProposalTest("test3.html", 43, 41, expectedProposalCounts);
    }

    private static void runProposalTest(String fileName, int lineNum, int lineRelativeCharOffset, int[] expectedProposalCounts) throws Exception {
        IFile file = TestEmbededCSSContentAssistComputers.getFile(fileName);
        StructuredTextEditor editor = TestEmbededCSSContentAssistComputers.getEditor(file);
        StructuredTextViewer viewer = editor.getTextViewer();
        int offset = viewer.getDocument().getLineOffset(lineNum) + lineRelativeCharOffset;
        ICompletionProposal[][] pages = TestEmbededCSSContentAssistComputers.getProposals(viewer, offset, expectedProposalCounts.length);
        TestEmbededCSSContentAssistComputers.verifyProposalCounts(pages, expectedProposalCounts);
    }

    private static ICompletionProposal[][] getProposals(StructuredTextViewer viewer, int offset, int pageCount) throws Exception {
        StructuredTextViewerConfigurationHTML configuration = new StructuredTextViewerConfigurationHTML();
        ContentAssistant contentAssistant = (ContentAssistant)configuration.getContentAssistant((ISourceViewer)viewer);
        viewer.configure((SourceViewerConfiguration)configuration);
        viewer.setSelectedRange(offset, 0);
        String partitionTypeID = viewer.getDocument().getPartition(offset).getType();
        IContentAssistProcessor processor = contentAssistant.getContentAssistProcessor(partitionTypeID);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.text.contentassist.ContentAssistant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Method privateFireSessionBeginEventMethod = clazz.getDeclaredMethod("fireSessionBeginEvent", Boolean.TYPE);
        privateFireSessionBeginEventMethod.setAccessible(true);
        privateFireSessionBeginEventMethod.invoke((Object)contentAssistant, Boolean.TRUE);
        ICompletionProposal[][] pages = new ICompletionProposal[pageCount][];
        int p = 0;
        while (p < pageCount) {
            pages[p] = processor.computeCompletionProposals((ITextViewer)viewer, offset);
            ++p;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jface.text.contentassist.ContentAssistant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Method privateFireSessionEndEventMethod = clazz2.getDeclaredMethod("fireSessionEndEvent", null);
        privateFireSessionEndEventMethod.setAccessible(true);
        privateFireSessionEndEventMethod.invoke((Object)contentAssistant, null);
        return pages;
    }

    private static void verifyProposalCounts(ICompletionProposal[][] pages, int[] expectedProposalCounts) {
        StringBuffer error = new StringBuffer();
        int page = 0;
        while (page < expectedProposalCounts.length) {
            if (expectedProposalCounts[page] > pages[page].length) {
                error.append("\nProposal page " + page + " did not have the expected number of proposals: was " + pages[page].length + " expected " + expectedProposalCounts[page]);
            }
            ++page;
        }
        if (error.length() > 0) {
            Assert.fail((String)error.toString());
        }
    }

    private static IFile getFile(String name) {
        IFile file = fProject.getFile(name);
        TestEmbededCSSContentAssistComputers.assertTrue((String)("Test file " + file + " can not be found"), (boolean)file.exists());
        return file;
    }

    private static StructuredTextEditor getEditor(IFile file) {
        StructuredTextEditor editor = (StructuredTextEditor)fFileToEditorMap.get(file);
        if (editor == null) {
            try {
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = workbenchWindow.getActivePage();
                IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)"org.eclipse.wst.html.core.htmlsource.source", (boolean)true);
                if (editorPart instanceof StructuredTextEditor) {
                    editor = (StructuredTextEditor)editorPart;
                } else {
                    TestEmbededCSSContentAssistComputers.fail((String)("Unable to open structured text editor: " + editorPart.getClass().getName()));
                }
                if (editor != null) {
                    TestEmbededCSSContentAssistComputers.standardizeLineEndings(editor);
                    fFileToEditorMap.put(file, editor);
                } else {
                    TestEmbededCSSContentAssistComputers.fail((String)("Could not open editor for " + file));
                }
            }
            catch (Exception e) {
                TestEmbededCSSContentAssistComputers.fail((String)("Could not open editor for " + file + " exception: " + e.getMessage()));
            }
        }
        return editor;
    }

    private static void standardizeLineEndings(StructuredTextEditor editor) {
        IDocument doc = editor.getTextViewer().getDocument();
        String contents = doc.get();
        contents = StringUtils.replace((String)contents, (String)"\r\n", (String)"\n");
        contents = StringUtils.replace((String)contents, (String)"\r", (String)"\n");
        doc.set(contents);
    }

    private static class TestEmbededCSSContentAssistComputersSetup
    extends TestSetup {
        private static final String WTP_AUTOTEST_NONINTERACTIVE = "wtp.autotest.noninteractive";
        private static String previousWTPAutoTestNonInteractivePropValue = null;

        public TestEmbededCSSContentAssistComputersSetup(Test test) {
            super(test);
        }

        public void setUp() throws Exception {
            String noninteractive = System.getProperty(WTP_AUTOTEST_NONINTERACTIVE);
            previousWTPAutoTestNonInteractivePropValue = noninteractive != null ? noninteractive : "false";
            System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, "true");
            fProject = ProjectUtil.createProject(TestEmbededCSSContentAssistComputers.PROJECT_NAME, null, new String[]{TestEmbededCSSContentAssistComputers.JAVA_SCRIPT_NATURE_ID});
            ProjectUtil.copyBundleEntriesIntoWorkspace(TestEmbededCSSContentAssistComputers.PROJECT_FILES, TestEmbededCSSContentAssistComputers.PROJECT_NAME);
        }

        public void tearDown() throws Exception {
            Iterator iter = fFileToEditorMap.values().iterator();
            while (iter.hasNext()) {
                StructuredTextEditor editor = (StructuredTextEditor)iter.next();
                editor.doSave(null);
                editor.close(false);
            }
            fProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
            if (previousWTPAutoTestNonInteractivePropValue != null) {
                System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, previousWTPAutoTestNonInteractivePropValue);
            }
        }
    }
}

