/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.launching.tests.testcase;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.wst.xsl.launching.tests.AbstractLaunchingTest;
import org.eclipse.wst.xsl.launching.tests.MockXSLLaunchShortCut;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LaunchShortcutTest
extends AbstractLaunchingTest {
    @Before
    public void setUp() throws Exception {
        super.setUp();
        IPath path = this.folder.getFullPath();
        this.copyConfigurationToWorkspace(path, "SimpleTransform.launch");
    }

    @After
    public void tearDown() throws Exception {
        this.env.dispose();
        super.tearDown();
    }

    @Test
    public void testShortcutExtensionPointConfigured() {
        LaunchShortcutExtension ext = this.getLaunchShortcutExtension("org.eclipse.wst.xsl.debug.ui.launchshortcut");
        Assert.assertNotNull((String)"XSLT stylesheet shortcut not found", (Object)ext);
    }

    @Test
    public void testXSLLaunchConfigTypeDefined() {
        MockXSLLaunchShortCut shortCut = new MockXSLLaunchShortCut();
        String typeid = "org.eclipse.wst.xsl.launching.launchConfigurationType";
        Assert.assertEquals((String)"Unexpected shortcut Type", (Object)typeid, (Object)shortCut.testGetConfigurationType().getIdentifier());
    }

    @Test
    public void testAssociatedConfigurationTypeNotSupported() {
        LaunchShortcutExtension ext = this.getLaunchShortcutExtension("org.eclipse.wst.xsl.debug.ui.launchshortcut");
        Assert.assertNotNull((String)"XSLT shortcut not found", (Object)ext);
        String typeid = "org.eclipse.jdt.launching.foo";
        Assert.assertTrue((String)"local xslt app shortcut should not support foo", (!ext.getAssociatedConfigurationTypes().contains(typeid) ? 1 : 0) != 0);
    }

    public List getApplicableLaunchShortcuts(String typeid) {
        ArrayList<LaunchShortcutExtension> list = new ArrayList<LaunchShortcutExtension>();
        LaunchShortcutExtension ext = null;
        List shortcuts = this.getLaunchConfigurationManager().getLaunchShortcuts();
        int i = 0;
        while (i < shortcuts.size()) {
            ext = (LaunchShortcutExtension)shortcuts.get(i);
            if (ext.getAssociatedConfigurationTypes().contains(typeid) && !WorkbenchActivityHelper.filterItem((Object)ext)) {
                list.add(ext);
            }
            ++i;
        }
        return list;
    }
}

