/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.tests.document;

import java.util.Arrays;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.text.TextRegionListImpl;
import org.eclipse.wst.sse.core.tests.util.Accessor;

public class TestRegionList
extends TestCase {
    private static final String REGION_TYPE;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.sse.core.tests.document.TestRegionList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        REGION_TYPE = clazz.getName();
    }

    public TestRegionList() {
    }

    public TestRegionList(String name) {
        super(name);
    }

    public void test_add() {
        TextRegionListImpl impl = new TextRegionListImpl();
        boolean added = impl.add((ITextRegion)new ContextRegion(REGION_TYPE, 0, 1, 1));
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)1, (int)new Accessor(impl, clazz).getInt("fRegionsCount"));
    }

    public void test_add2() {
        TextRegionListImpl impl = new TextRegionListImpl();
        boolean added = impl.add((ITextRegion)new ContextRegion(REGION_TYPE, 0, 1, 1));
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)1, (int)new Accessor(impl, clazz).getInt("fRegionsCount"));
        added = impl.add((ITextRegion)new ContextRegion(REGION_TYPE, 2, 1, 1));
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)2, (int)new Accessor(impl, clazz2).getInt("fRegionsCount"));
    }

    public void test_addAllToPosition() {
        ITextRegion[] regions = new ITextRegion[3];
        TextRegionListImpl impl = new TextRegionListImpl();
        regions[0] = new ContextRegion(REGION_TYPE, 0, 1, 1);
        boolean added = impl.add(regions[0]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        TextRegionListImpl impl2 = new TextRegionListImpl();
        regions[1] = new ContextRegion(REGION_TYPE, 1, 1, 1);
        added = impl2.add(regions[1]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        regions[2] = new ContextRegion(REGION_TYPE, 2, 1, 1);
        added = impl2.add(regions[2]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        added = impl.addAll(0, (ITextRegionList)impl2);
        TestRegionList.assertTrue((String)"regions not added", (boolean)added);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)3, (int)new Accessor(impl, clazz).getInt("fRegionsCount"));
        ITextRegion iTextRegion = regions[1];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"object was wrong", (Object)iTextRegion, (Object)((ITextRegion[])new Accessor(impl, clazz2).get("fRegions"))[0]);
        ITextRegion iTextRegion2 = regions[2];
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"object was wrong", (Object)iTextRegion2, (Object)((ITextRegion[])new Accessor(impl, clazz3).get("fRegions"))[1]);
        ITextRegion iTextRegion3 = regions[0];
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"object was wrong", (Object)iTextRegion3, (Object)((ITextRegion[])new Accessor(impl, clazz4).get("fRegions"))[2]);
    }

    public void test_addAllToEmpty() {
        ITextRegion[] regions = new ITextRegion[3];
        TextRegionListImpl impl = new TextRegionListImpl();
        regions[0] = new ContextRegion(REGION_TYPE, 0, 1, 1);
        boolean added = impl.add(regions[0]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        regions[1] = new ContextRegion(REGION_TYPE, 1, 1, 1);
        added = impl.add(regions[1]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        regions[2] = new ContextRegion(REGION_TYPE, 2, 1, 1);
        added = impl.add(regions[2]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        TextRegionListImpl impl2 = new TextRegionListImpl();
        added = impl2.addAll(0, (ITextRegionList)impl);
        TestRegionList.assertTrue((String)"regions not added", (boolean)added);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)3, (int)new Accessor(impl, clazz).getInt("fRegionsCount"));
        ITextRegion iTextRegion = regions[0];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"object was wrong", (Object)iTextRegion, (Object)((ITextRegion[])new Accessor(impl, clazz2).get("fRegions"))[0]);
        ITextRegion iTextRegion2 = regions[1];
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"object was wrong", (Object)iTextRegion2, (Object)((ITextRegion[])new Accessor(impl, clazz3).get("fRegions"))[1]);
        ITextRegion iTextRegion3 = regions[2];
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"object was wrong", (Object)iTextRegion3, (Object)((ITextRegion[])new Accessor(impl, clazz4).get("fRegions"))[2]);
    }

    public void test_clear() {
        TextRegionListImpl impl = new TextRegionListImpl();
        boolean added = impl.add((ITextRegion)new ContextRegion(REGION_TYPE, 0, 1, 1));
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)1, (int)new Accessor(impl, clazz).getInt("fRegionsCount"));
        added = impl.add((ITextRegion)new ContextRegion(REGION_TYPE, 2, 1, 1));
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)2, (int)new Accessor(impl, clazz2).getInt("fRegionsCount"));
        impl.clear();
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)0, (int)new Accessor(impl, clazz3).getInt("fRegionsCount"));
    }

    public void test_getOver() {
        ITextRegion[] regions = new ITextRegion[3];
        TextRegionListImpl impl = new TextRegionListImpl();
        regions[0] = new ContextRegion(REGION_TYPE, 0, 1, 1);
        boolean added = impl.add(regions[0]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)1, (int)new Accessor(impl, clazz).getInt("fRegionsCount"));
        regions[1] = new ContextRegion(REGION_TYPE, 1, 1, 1);
        added = impl.add(regions[1]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)2, (int)new Accessor(impl, clazz2).getInt("fRegionsCount"));
        regions[2] = new ContextRegion(REGION_TYPE, 2, 1, 1);
        added = impl.add(regions[2]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)3, (int)new Accessor(impl, clazz3).getInt("fRegionsCount"));
        TestRegionList.assertEquals((String)"wrong object", (Object)regions[0], (Object)impl.get(0));
        TestRegionList.assertEquals((String)"wrong object", (Object)regions[1], (Object)impl.get(1));
        TestRegionList.assertEquals((String)"wrong object", (Object)regions[2], (Object)impl.get(2));
        ArrayIndexOutOfBoundsException e = null;
        try {
            impl.get(impl.size());
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            e = e2;
        }
        TestRegionList.assertNotNull((String)"no ArrayIndexOutOfBoundsException thrown when expected", (Object)e);
    }

    public void test_getUnder() {
        ITextRegion[] regions = new ITextRegion[3];
        TextRegionListImpl impl = new TextRegionListImpl();
        regions[0] = new ContextRegion(REGION_TYPE, 0, 1, 1);
        boolean added = impl.add(regions[0]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)1, (int)new Accessor(impl, clazz).getInt("fRegionsCount"));
        regions[1] = new ContextRegion(REGION_TYPE, 1, 1, 1);
        added = impl.add(regions[1]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)2, (int)new Accessor(impl, clazz2).getInt("fRegionsCount"));
        regions[2] = new ContextRegion(REGION_TYPE, 2, 1, 1);
        added = impl.add(regions[2]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)3, (int)new Accessor(impl, clazz3).getInt("fRegionsCount"));
        TestRegionList.assertEquals((String)"wrong object", (Object)regions[0], (Object)impl.get(0));
        TestRegionList.assertEquals((String)"wrong object", (Object)regions[1], (Object)impl.get(1));
        TestRegionList.assertEquals((String)"wrong object", (Object)regions[2], (Object)impl.get(2));
        ArrayIndexOutOfBoundsException e = null;
        try {
            impl.get(-1);
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            e = e2;
        }
        TestRegionList.assertNotNull((String)"no ArrayIndexOutOfBoundsException thrown when expected", (Object)e);
    }

    public void test_get() {
        ITextRegion[] regions = new ITextRegion[3];
        TextRegionListImpl impl = new TextRegionListImpl();
        regions[0] = new ContextRegion(REGION_TYPE, 0, 1, 1);
        boolean added = impl.add(regions[0]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)1, (int)new Accessor(impl, clazz).getInt("fRegionsCount"));
        regions[1] = new ContextRegion(REGION_TYPE, 1, 1, 1);
        added = impl.add(regions[1]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)2, (int)new Accessor(impl, clazz2).getInt("fRegionsCount"));
        regions[2] = new ContextRegion(REGION_TYPE, 2, 1, 1);
        added = impl.add(regions[2]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)3, (int)new Accessor(impl, clazz3).getInt("fRegionsCount"));
        TestRegionList.assertEquals((String)"wrong object", (Object)regions[0], (Object)impl.get(0));
        TestRegionList.assertEquals((String)"wrong object", (Object)regions[1], (Object)impl.get(1));
        TestRegionList.assertEquals((String)"wrong object", (Object)regions[2], (Object)impl.get(2));
    }

    public void test_indexOf() {
        ITextRegion[] regions = new ITextRegion[3];
        TextRegionListImpl impl = new TextRegionListImpl();
        regions[0] = new ContextRegion(REGION_TYPE, 0, 1, 1);
        boolean added = impl.add(regions[0]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)1, (int)new Accessor(impl, clazz).getInt("fRegionsCount"));
        regions[1] = new ContextRegion(REGION_TYPE, 1, 1, 1);
        added = impl.add(regions[1]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)2, (int)new Accessor(impl, clazz2).getInt("fRegionsCount"));
        regions[2] = new ContextRegion(REGION_TYPE, 2, 1, 1);
        added = impl.add(regions[2]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)3, (int)new Accessor(impl, clazz3).getInt("fRegionsCount"));
        TestRegionList.assertEquals((String)"wrong object", (int)0, (int)impl.indexOf(regions[0]));
        TestRegionList.assertEquals((String)"wrong object", (int)1, (int)impl.indexOf(regions[1]));
        TestRegionList.assertEquals((String)"wrong object", (int)2, (int)impl.indexOf(regions[2]));
    }

    public void test_isEmpty() {
        TextRegionListImpl impl = new TextRegionListImpl();
        boolean added = impl.add((ITextRegion)new ContextRegion(REGION_TYPE, 0, 1, 1));
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)1, (int)new Accessor(impl, clazz).getInt("fRegionsCount"));
        added = impl.add((ITextRegion)new ContextRegion(REGION_TYPE, 2, 1, 1));
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)2, (int)new Accessor(impl, clazz2).getInt("fRegionsCount"));
        impl.clear();
        TestRegionList.assertEquals((String)"count was wrong", (boolean)true, (boolean)impl.isEmpty());
    }

    public void test_iterator0() {
        TextRegionListImpl impl = new TextRegionListImpl();
        Iterator it = null;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        it = (Iterator)new Accessor(impl, clazz).invoke("iterator", new Object[0]);
        TestRegionList.assertNotNull((String)"no iterator returned", (Object)it);
        TestRegionList.assertFalse((boolean)it.hasNext());
    }

    public void test_iterator1() {
        TextRegionListImpl impl = new TextRegionListImpl();
        boolean added = impl.add((ITextRegion)new ContextRegion(REGION_TYPE, 0, 1, 1));
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        TestRegionList.assertEquals((String)"count was wrong", (int)1, (int)impl.size());
        added = impl.add((ITextRegion)new ContextRegion(REGION_TYPE, 2, 1, 1));
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        TestRegionList.assertEquals((String)"count was wrong", (int)2, (int)impl.size());
        Iterator it = null;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        it = (Iterator)new Accessor(impl, clazz).invoke("iterator", new Object[0]);
        TestRegionList.assertNotNull((String)"no iterator returned", (Object)it);
        TestRegionList.assertTrue((boolean)it.hasNext());
    }

    public void test_iterator2() {
        TextRegionListImpl impl = new TextRegionListImpl();
        boolean added = impl.add((ITextRegion)new ContextRegion(REGION_TYPE, 0, 1, 1));
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)1, (int)new Accessor(impl, clazz).getInt("fRegionsCount"));
        added = impl.add((ITextRegion)new ContextRegion(REGION_TYPE, 1, 1, 1));
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)2, (int)new Accessor(impl, clazz2).getInt("fRegionsCount"));
        added = impl.add((ITextRegion)new ContextRegion(REGION_TYPE, 2, 1, 1));
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)3, (int)new Accessor(impl, clazz3).getInt("fRegionsCount"));
        Iterator it = null;
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        it = (Iterator)new Accessor(impl, clazz4).invoke("iterator", new Object[0]);
        TestRegionList.assertNotNull((String)"no iterator returned", (Object)it);
        TestRegionList.assertTrue((boolean)it.hasNext());
        TestRegionList.assertNotNull(it.next());
        TestRegionList.assertNotNull(it.next());
        TestRegionList.assertNotNull(it.next());
        TestRegionList.assertFalse((boolean)it.hasNext());
    }

    public void test_removeByPosition() {
        ITextRegion[] regions = new ITextRegion[3];
        TextRegionListImpl impl = new TextRegionListImpl();
        regions[0] = new ContextRegion(REGION_TYPE, 0, 1, 1);
        boolean added = impl.add(regions[0]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)1, (int)new Accessor(impl, clazz).getInt("fRegionsCount"));
        regions[1] = new ContextRegion(REGION_TYPE, 1, 1, 1);
        added = impl.add(regions[1]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)2, (int)new Accessor(impl, clazz2).getInt("fRegionsCount"));
        regions[2] = new ContextRegion(REGION_TYPE, 2, 1, 1);
        added = impl.add(regions[2]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)3, (int)new Accessor(impl, clazz3).getInt("fRegionsCount"));
        TestRegionList.assertEquals((String)"wrong object", (int)0, (int)impl.indexOf(regions[0]));
        TestRegionList.assertEquals((String)"wrong object", (int)1, (int)impl.indexOf(regions[1]));
        TestRegionList.assertEquals((String)"wrong object", (int)2, (int)impl.indexOf(regions[2]));
        impl.remove(1);
        Iterator it = null;
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        it = (Iterator)new Accessor(impl, clazz4).invoke("iterator", new Object[0]);
        TestRegionList.assertNotNull((String)"no iterator returned", (Object)it);
        TestRegionList.assertTrue((boolean)it.hasNext());
        TestRegionList.assertEquals((Object)regions[0], it.next());
        TestRegionList.assertEquals((Object)regions[2], it.next());
        TestRegionList.assertFalse((boolean)it.hasNext());
    }

    public void test_removeByObject() {
        ITextRegion[] regions = new ITextRegion[3];
        TextRegionListImpl impl = new TextRegionListImpl();
        regions[0] = new ContextRegion(REGION_TYPE, 0, 1, 1);
        boolean added = impl.add(regions[0]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)1, (int)new Accessor(impl, clazz).getInt("fRegionsCount"));
        regions[1] = new ContextRegion(REGION_TYPE, 1, 1, 1);
        added = impl.add(regions[1]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)2, (int)new Accessor(impl, clazz2).getInt("fRegionsCount"));
        regions[2] = new ContextRegion(REGION_TYPE, 2, 1, 1);
        added = impl.add(regions[2]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)3, (int)new Accessor(impl, clazz3).getInt("fRegionsCount"));
        TestRegionList.assertEquals((String)"wrong object", (int)0, (int)impl.indexOf(regions[0]));
        TestRegionList.assertEquals((String)"wrong object", (int)1, (int)impl.indexOf(regions[1]));
        TestRegionList.assertEquals((String)"wrong object", (int)2, (int)impl.indexOf(regions[2]));
        impl.remove(regions[1]);
        Iterator it = null;
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        it = (Iterator)new Accessor(impl, clazz4).invoke("iterator", new Object[0]);
        TestRegionList.assertNotNull((String)"no iterator returned", (Object)it);
        TestRegionList.assertTrue((boolean)it.hasNext());
        TestRegionList.assertEquals((Object)regions[0], it.next());
        TestRegionList.assertEquals((Object)regions[2], it.next());
        TestRegionList.assertFalse((boolean)it.hasNext());
    }

    public void test_removeAll() {
        ITextRegion[] regions = new ITextRegion[3];
        TextRegionListImpl impl = new TextRegionListImpl();
        regions[0] = new ContextRegion(REGION_TYPE, 0, 1, 1);
        boolean added = impl.add(regions[0]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)1, (int)new Accessor(impl, clazz).getInt("fRegionsCount"));
        regions[1] = new ContextRegion(REGION_TYPE, 1, 1, 1);
        added = impl.add(regions[1]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)2, (int)new Accessor(impl, clazz2).getInt("fRegionsCount"));
        regions[2] = new ContextRegion(REGION_TYPE, 2, 1, 1);
        added = impl.add(regions[2]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)3, (int)new Accessor(impl, clazz3).getInt("fRegionsCount"));
        TestRegionList.assertEquals((String)"wrong object", (int)0, (int)impl.indexOf(regions[0]));
        TestRegionList.assertEquals((String)"wrong object", (int)1, (int)impl.indexOf(regions[1]));
        TestRegionList.assertEquals((String)"wrong object", (int)2, (int)impl.indexOf(regions[2]));
        TextRegionListImpl impl2 = new TextRegionListImpl();
        impl2.add(regions[0]);
        impl2.add(regions[1]);
        impl2.add(regions[2]);
        impl.removeAll((ITextRegionList)impl2);
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)0, (int)new Accessor(impl, clazz4).getInt("fRegionsCount"));
    }

    public void test_size() {
        ITextRegion[] regions = new ITextRegion[3];
        TextRegionListImpl impl = new TextRegionListImpl();
        regions[0] = new ContextRegion(REGION_TYPE, 0, 1, 1);
        boolean added = impl.add(regions[0]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        TestRegionList.assertEquals((String)"count was wrong", (int)1, (int)impl.size());
        regions[1] = new ContextRegion(REGION_TYPE, 1, 1, 1);
        added = impl.add(regions[1]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        TestRegionList.assertEquals((String)"count was wrong", (int)2, (int)impl.size());
        regions[2] = new ContextRegion(REGION_TYPE, 2, 1, 1);
        added = impl.add(regions[2]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        TestRegionList.assertEquals((String)"count was wrong", (int)3, (int)impl.size());
        TestRegionList.assertEquals((String)"wrong object", (int)0, (int)impl.indexOf(regions[0]));
        TestRegionList.assertEquals((String)"wrong object", (int)1, (int)impl.indexOf(regions[1]));
        TestRegionList.assertEquals((String)"wrong object", (int)2, (int)impl.indexOf(regions[2]));
        TestRegionList.assertEquals((String)"wrong count", (int)3, (int)impl.size());
        impl.remove(regions[1]);
        TestRegionList.assertEquals((String)"wrong count", (int)2, (int)impl.size());
    }

    public void test_toArray() {
        Object[] regions = new ITextRegion[3];
        TextRegionListImpl impl = new TextRegionListImpl();
        regions[0] = new ContextRegion(REGION_TYPE, 0, 1, 1);
        boolean added = impl.add(regions[0]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        TestRegionList.assertEquals((String)"count was wrong", (int)1, (int)impl.size());
        regions[1] = new ContextRegion(REGION_TYPE, 1, 1, 1);
        added = impl.add(regions[1]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        TestRegionList.assertEquals((String)"count was wrong", (int)2, (int)impl.size());
        regions[2] = new ContextRegion(REGION_TYPE, 2, 1, 1);
        added = impl.add(regions[2]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        TestRegionList.assertEquals((String)"count was wrong", (int)3, (int)impl.size());
        TestRegionList.assertEquals((String)"wrong object", (int)0, (int)impl.indexOf(regions[0]));
        TestRegionList.assertEquals((String)"wrong object", (int)1, (int)impl.indexOf(regions[1]));
        TestRegionList.assertEquals((String)"wrong object", (int)2, (int)impl.indexOf(regions[2]));
        TestRegionList.assertTrue((String)"wrong array", (boolean)Arrays.equals(regions, impl.toArray()));
        impl.remove((ITextRegion)regions[1]);
        TestRegionList.assertTrue((String)"wrong array", (boolean)Arrays.equals(new ITextRegion[]{regions[0], regions[2]}, impl.toArray()));
    }

    public void test_trimToSize0() {
        ITextRegion[] regions = new ITextRegion[3];
        TextRegionListImpl impl = new TextRegionListImpl();
        regions[0] = new ContextRegion(REGION_TYPE, 0, 1, 1);
        boolean added = impl.add(regions[0]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        TestRegionList.assertEquals((String)"count was wrong", (int)1, (int)impl.size());
        regions[1] = new ContextRegion(REGION_TYPE, 1, 1, 1);
        added = impl.add(regions[1]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        TestRegionList.assertEquals((String)"count was wrong", (int)2, (int)impl.size());
        regions[2] = new ContextRegion(REGION_TYPE, 2, 1, 1);
        added = impl.add(regions[2]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        TestRegionList.assertEquals((String)"count was wrong", (int)3, (int)impl.size());
        impl.clear();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)0, (int)new Accessor(impl, clazz).getInt("fRegionsCount"));
        impl.trimToSize();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)0, (int)new Accessor(impl, clazz2).getInt("fRegionsCount"));
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"not trimmed", (int)0, (int)((Object[])new Accessor(impl, clazz3).get("fRegions")).length);
    }

    public void test_trimToSize1() {
        ITextRegion[] regions = new ITextRegion[3];
        TextRegionListImpl impl = new TextRegionListImpl();
        regions[0] = new ContextRegion(REGION_TYPE, 0, 1, 1);
        boolean added = impl.add(regions[0]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        TestRegionList.assertEquals((String)"count was wrong", (int)1, (int)impl.size());
        regions[1] = new ContextRegion(REGION_TYPE, 1, 1, 1);
        added = impl.add(regions[1]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        TestRegionList.assertEquals((String)"count was wrong", (int)2, (int)impl.size());
        regions[2] = new ContextRegion(REGION_TYPE, 2, 1, 1);
        added = impl.add(regions[2]);
        TestRegionList.assertTrue((String)"region not added", (boolean)added);
        TestRegionList.assertEquals((String)"count was wrong", (int)3, (int)impl.size());
        impl.remove(0);
        impl.remove(0);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)1, (int)new Accessor(impl, clazz).getInt("fRegionsCount"));
        impl.trimToSize();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"count was wrong", (int)1, (int)new Accessor(impl, clazz2).getInt("fRegionsCount"));
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.text.TextRegionListImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRegionList.assertEquals((String)"not trimmed", (int)1, (int)((Object[])new Accessor(impl, clazz3).get("fRegions")).length);
    }
}

