/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.launching.internal.registry;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.xsl.jaxp.launching.internal.JAXPLaunchingPlugin;
import org.eclipse.wst.xsl.jaxp.launching.internal.Messages;

public abstract class AbstractRegistryReader {
    public static final String ATT_CLASS = "class";
    public static final String TAG_DESCRIPTION = "description";

    protected static void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        StringBuffer buf = new StringBuffer();
        buf.append("Plugin " + extension.getNamespaceIdentifier() + Messages.AbstractRegistryReader_3 + extension.getExtensionPointUniqueIdentifier());
        buf.append("\n" + text);
        JAXPLaunchingPlugin.log(new CoreException((IStatus)new Status(4, "org.eclipse.wst.xsl.jaxp.launching", 0, buf.toString(), null)));
    }

    protected static void logMissingAttribute(IConfigurationElement element, String attributeName) {
        AbstractRegistryReader.logError(element, String.valueOf(Messages.AbstractRegistryReader_5) + attributeName + Messages.AbstractRegistryReader_6);
    }

    protected static void logMissingElement(IConfigurationElement element, String elementName) {
        AbstractRegistryReader.logError(element, String.valueOf(Messages.AbstractRegistryReader_7) + elementName + Messages.AbstractRegistryReader_8);
    }

    protected static void logUnknownElement(IConfigurationElement element) {
        AbstractRegistryReader.logError(element, String.valueOf(Messages.AbstractRegistryReader_9) + element.getName());
    }

    public static IExtension[] orderExtensions(IExtension[] extensions) {
        IExtension[] sortedExtension = new IExtension[extensions.length];
        System.arraycopy(extensions, 0, sortedExtension, 0, extensions.length);
        Comparator<IExtension> comparer = new Comparator<IExtension>(){

            @Override
            public int compare(IExtension arg0, IExtension arg1) {
                String s1 = arg0.getNamespaceIdentifier();
                String s2 = arg1.getNamespaceIdentifier();
                return s1.compareToIgnoreCase(s2);
            }
        };
        Collections.sort(Arrays.asList(sortedExtension), comparer);
        return sortedExtension;
    }

    protected abstract boolean readElement(IConfigurationElement var1);

    protected void readElementChildren(IConfigurationElement element) {
        this.readElements(element.getChildren());
    }

    protected void readElements(IConfigurationElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (!this.readElement(elements[i])) {
                AbstractRegistryReader.logUnknownElement(elements[i]);
            }
            ++i;
        }
    }

    protected void readExtension(IExtension extension) {
        this.readElements(extension.getConfigurationElements());
    }

    public void readRegistry(IExtensionRegistry registry, String pluginId, String extensionPoint) {
        IExtensionPoint point = registry.getExtensionPoint(pluginId, extensionPoint);
        if (point == null) {
            return;
        }
        IExtension[] extensions = point.getExtensions();
        IExtension[] iExtensionArray = extensions = AbstractRegistryReader.orderExtensions(extensions);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension element = iExtensionArray[n2];
            this.readExtension(element);
            ++n2;
        }
    }

    public static String getDescription(IConfigurationElement configElement) {
        IConfigurationElement[] children = configElement.getChildren(TAG_DESCRIPTION);
        if (children.length >= 1) {
            return children[0].getValue();
        }
        return "";
    }

    public static String getClassValue(IConfigurationElement configElement, String classAttributeName) {
        String className = configElement.getAttribute(classAttributeName);
        if (className != null) {
            return className;
        }
        IConfigurationElement[] candidateChildren = configElement.getChildren(classAttributeName);
        if (candidateChildren.length == 0) {
            return null;
        }
        return candidateChildren[0].getAttribute(ATT_CLASS);
    }
}

