/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.reconcile.ISourceReconcilingListener;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart;
import org.eclipse.wst.xml.ui.tests.ProjectUtil;

public class XMLCodeFoldingTest
extends TestCase
implements ISourceReconcilingListener {
    private static final int MAX_WAIT_TIME = 15000;
    private static final int WAIT_TIME = 200;
    private static final String PROJECT_NAME = "XMLCodeFoldingTest";
    private static final String PROJECT_FILES = "/testresources/folding";
    private static IProject fProject;
    private static Map fFileToEditorMap;
    private static IDocument fReconciledDoc;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        fFileToEditorMap = new HashMap();
        fReconciledDoc = null;
    }

    public XMLCodeFoldingTest() {
        super("XML Code Folding Test");
    }

    public XMLCodeFoldingTest(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.ui.tests.XMLCodeFoldingTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite ts = new TestSuite((Class)clazz, "XML Code Folding Test");
        return new XMLCodeFoldingTestSetup((Test)ts);
    }

    protected void setUp() throws Exception {
        super.setUp();
        fReconciledDoc = null;
    }

    public void testInitFolding() throws Exception {
        IFile file = XMLCodeFoldingTest.getFile("XMLFoldingTest1.xml");
        StructuredTextEditor editor = this.getEditor(file);
        ArrayList<Position> expectedPositions = new ArrayList<Position>();
        expectedPositions.add(new Position(142, 16));
        expectedPositions.add(new Position(173, 36));
        expectedPositions.add(new Position(39, 179));
        expectedPositions.add(new Position(71, 13));
        expectedPositions.add(new Position(62, 107));
        expectedPositions.add(new Position(47, 13));
        expectedPositions.add(new Position(87, 49));
        this.waitForReconcileThenVerify(editor.getTextViewer(), expectedPositions);
    }

    public void testRemoveNode() throws Exception {
        IFile file = XMLCodeFoldingTest.getFile("XMLFoldingTest1.xml");
        StructuredTextEditor editor = this.getEditor(file);
        try {
            StructuredTextViewer viewer = editor.getTextViewer();
            IDocument doc = viewer.getDocument();
            doc.replace(87, 49, "");
            editor.doSave(null);
            ArrayList<Position> expectedPositions = new ArrayList<Position>();
            expectedPositions.add(new Position(93, 16));
            expectedPositions.add(new Position(124, 36));
            expectedPositions.add(new Position(39, 130));
            expectedPositions.add(new Position(71, 13));
            expectedPositions.add(new Position(62, 58));
            expectedPositions.add(new Position(47, 13));
            this.waitForReconcileThenVerify(viewer, expectedPositions);
        }
        catch (BadLocationException e) {
            XMLCodeFoldingTest.fail((String)("Test is broken, replace location has become invalid.\n" + e.getMessage()));
        }
    }

    public void testAddNode() throws Exception {
        IFile file = XMLCodeFoldingTest.getFile("XMLFoldingTest2.xml");
        StructuredTextEditor editor = this.getEditor(file);
        try {
            StructuredTextViewer viewer = editor.getTextViewer();
            IDocument doc = viewer.getDocument();
            doc.replace(149, 0, "\n<addMe>\n\n\n</addMe>");
            editor.doSave(null);
            ArrayList<Position> expectedPositions = new ArrayList<Position>();
            expectedPositions.add(new Position(150, 18));
            expectedPositions.add(new Position(62, 126));
            expectedPositions.add(new Position(47, 13));
            expectedPositions.add(new Position(39, 198));
            expectedPositions.add(new Position(192, 36));
            expectedPositions.add(new Position(71, 13));
            expectedPositions.add(new Position(142, 35));
            expectedPositions.add(new Position(87, 49));
            this.waitForReconcileThenVerify(viewer, expectedPositions);
        }
        catch (BadLocationException e) {
            XMLCodeFoldingTest.fail((String)("Test is broken, add location has become invalid.\n" + e.getMessage()));
        }
    }

    public void testConfigTypeHierarchyExploration() throws Exception {
        IFile file = XMLCodeFoldingTest.getFile("XSLFoldingTest1.xsl");
        StructuredTextEditor editor = this.getEditor(file);
        ArrayList<Position> expectedPositions = new ArrayList<Position>();
        expectedPositions.add(new Position(120, 88));
        expectedPositions.add(new Position(147, 44));
        expectedPositions.add(new Position(39, 187));
        this.waitForReconcileThenVerify(editor.getTextViewer(), expectedPositions);
    }

    public void testComments() throws Exception {
        IFile file = XMLCodeFoldingTest.getFile("XMLFoldingCommentTest.xml");
        StructuredTextEditor editor = this.getEditor(file);
        ArrayList<Position> expectedPositions = new ArrayList<Position>();
        expectedPositions.add(new Position(275, 36));
        expectedPositions.add(new Position(124, 49));
        expectedPositions.add(new Position(179, 81));
        expectedPositions.add(new Position(39, 281));
        expectedPositions.add(new Position(191, 56));
        expectedPositions.add(new Position(64, 31));
        expectedPositions.add(new Position(99, 172));
        expectedPositions.add(new Position(47, 13));
        expectedPositions.add(new Position(108, 13));
        this.waitForReconcileThenVerify(editor.getTextViewer(), expectedPositions);
    }

    private static IFile getFile(String name) {
        IFile file = fProject.getFile(name);
        XMLCodeFoldingTest.assertTrue((String)("Test file " + file + " can not be found"), (boolean)file.exists());
        return file;
    }

    private StructuredTextEditor getEditor(IFile file) {
        StructuredTextEditor editor = (StructuredTextEditor)fFileToEditorMap.get(file);
        if (editor == null) {
            try {
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = workbenchWindow.getActivePage();
                IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true, (boolean)true);
                if (editorPart instanceof XMLMultiPageEditorPart) {
                    XMLMultiPageEditorPart xmlEditorPart = (XMLMultiPageEditorPart)editorPart;
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.wst.sse.ui.StructuredTextEditor");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    editor = (StructuredTextEditor)xmlEditorPart.getAdapter((Class)clazz);
                } else if (editorPart instanceof StructuredTextEditor) {
                    editor = (StructuredTextEditor)editorPart;
                } else {
                    XMLCodeFoldingTest.fail((String)("Unable to open structured text editor: " + editorPart.getClass().getName()));
                }
                this.standardizeLineEndings(editor);
                if (editor != null) {
                    fFileToEditorMap.put(file, editor);
                } else {
                    XMLCodeFoldingTest.fail((String)("Could not open viewer for " + file));
                }
            }
            catch (Exception e) {
                XMLCodeFoldingTest.fail((String)("Could not open editor for " + file + " exception: " + e.getMessage()));
            }
        }
        return editor;
    }

    private void waitForReconcileThenVerify(StructuredTextViewer viewer, List expectedPositions) throws Exception {
        IDocument doc = viewer.getDocument();
        int time = 0;
        while (doc != fReconciledDoc && time <= 15000) {
            Thread.sleep(200L);
            time += 200;
        }
        if (doc == fReconciledDoc) {
            this.verifyAnnotationPositions(viewer, expectedPositions);
        } else {
            Assert.fail((String)("Document " + viewer.getDocument() + " was not reconciled with in " + 15000 + " so gave up waiting and in turn could not validate folding anotations (UI blocked?)"));
        }
    }

    private void verifyAnnotationPositions(StructuredTextViewer viewer, List expectedPositions) {
        ProjectionAnnotationModel projectionModel = viewer.getProjectionAnnotationModel();
        Iterator annotationIter = projectionModel.getAnnotationIterator();
        ArrayList<Position> unexpectedPositions = new ArrayList<Position>();
        ArrayList<ProjectionAnnotation> unexpectedAnnotations = new ArrayList<ProjectionAnnotation>();
        while (annotationIter.hasNext()) {
            ProjectionAnnotation annotation;
            Position pos;
            boolean found;
            Object obj = annotationIter.next();
            if (!(obj instanceof ProjectionAnnotation) || (found = expectedPositions.remove(pos = projectionModel.getPosition((Annotation)(annotation = (ProjectionAnnotation)obj))))) continue;
            unexpectedPositions.add(pos);
            unexpectedAnnotations.add(annotation);
        }
        String error = "";
        if (unexpectedPositions.size() != 0) {
            error = String.valueOf(error) + "There were " + unexpectedPositions.size() + " unexpected positions that were found";
            int i = 0;
            while (i < unexpectedPositions.size()) {
                error = String.valueOf(error) + "\n\t" + unexpectedPositions.get(i) + "\ttype:" + ((Annotation)unexpectedAnnotations.get(i)).getType();
                ++i;
            }
        }
        if (expectedPositions.size() != 0) {
            error = String.valueOf(error) + "\nThere were " + expectedPositions.size() + " expected positions that were not found";
            int i = 0;
            while (i < expectedPositions.size()) {
                error = String.valueOf(error) + "\n\t" + expectedPositions.get(i);
                ++i;
            }
        }
        if (error.length() != 0) {
            XMLCodeFoldingTest.fail((String)error);
        }
    }

    private void standardizeLineEndings(StructuredTextEditor editor) {
        IDocument doc = editor.getTextViewer().getDocument();
        String contents = doc.get();
        contents = StringUtils.replace((String)contents, (String)"\r\n", (String)"\n");
        contents = StringUtils.replace((String)contents, (String)"\r", (String)"\n");
        doc.set(contents);
    }

    public void aboutToBeReconciled() {
    }

    public void reconciled(IDocument document, IAnnotationModel model, boolean forced, IProgressMonitor progressMonitor) {
        fReconciledDoc = document;
    }

    private static class XMLCodeFoldingTestSetup
    extends TestSetup {
        private static final String WTP_AUTOTEST_NONINTERACTIVE = "wtp.autotest.noninteractive";
        private static String previousWTPAutoTestNonInteractivePropValue = null;

        public XMLCodeFoldingTestSetup(Test test) {
            super(test);
        }

        public void setUp() throws Exception {
            XMLCodeFoldingTestSetup.initializeResources();
            String noninteractive = System.getProperty(WTP_AUTOTEST_NONINTERACTIVE);
            previousWTPAutoTestNonInteractivePropValue = noninteractive != null ? noninteractive : "false";
            System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, "true");
        }

        public void tearDown() throws Exception {
            Iterator iter = fFileToEditorMap.values().iterator();
            while (iter.hasNext()) {
                StructuredTextEditor editor = (StructuredTextEditor)iter.next();
                editor.doSave(null);
                IEditorPart editorPart = editor.getEditorPart();
                editorPart.getSite().getPage().closeEditor(editorPart, false);
            }
            if (previousWTPAutoTestNonInteractivePropValue != null) {
                System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, previousWTPAutoTestNonInteractivePropValue);
            }
            fProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }

        private static void initializeResources() {
            fProject = ProjectUtil.createProject(XMLCodeFoldingTest.PROJECT_NAME, null, null);
            ProjectUtil.copyBundleEntriesIntoWorkspace(XMLCodeFoldingTest.PROJECT_FILES, XMLCodeFoldingTest.PROJECT_NAME);
        }
    }
}

