/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.multitenant;

import org.eclipse.persistence.annotations.TenantTableDiscriminatorType;
import org.eclipse.persistence.descriptors.TablePerMultitenantPolicy;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;

public class TenantTableDiscriminatorMetadata
extends ORMetadata {
    protected static final TenantTableDiscriminatorType TYPE_DEFAULT = TenantTableDiscriminatorType.SUFFIX;
    protected String m_type;
    protected String m_contextProperty;

    public TenantTableDiscriminatorMetadata() {
        super("<tenant-table-discriminator>");
    }

    public TenantTableDiscriminatorMetadata(MetadataAccessor accessor) {
        super(null, accessor);
    }

    public TenantTableDiscriminatorMetadata(MetadataAnnotation tenantTableDiscriminator, MetadataAccessor accessor) {
        super(tenantTableDiscriminator, accessor);
        this.m_type = tenantTableDiscriminator.getAttributeString("type");
        this.m_contextProperty = tenantTableDiscriminator.getAttributeString("contextProperty");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof TenantTableDiscriminatorMetadata) {
            TenantTableDiscriminatorMetadata tenantTableDiscriminator = (TenantTableDiscriminatorMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_contextProperty, tenantTableDiscriminator.getContextProperty())) {
                return false;
            }
            return this.valuesMatch(this.m_type, tenantTableDiscriminator.getType());
        }
        return false;
    }

    public String getContextProperty() {
        return this.m_contextProperty;
    }

    public String getType() {
        return this.m_type;
    }

    public void process(MetadataDescriptor descriptor, TablePerMultitenantPolicy policy) {
        if (this.m_type == null) {
            this.getLogger().logConfigMessage("metadata_default_tenant_table_discriminator_type", descriptor.getJavaClass(), (Object)TYPE_DEFAULT.name());
            policy.setTenantTableDiscriminatorType(TYPE_DEFAULT);
        } else {
            policy.setTenantTableDiscriminatorType(TenantTableDiscriminatorType.valueOf((String)this.m_type));
        }
        if (this.m_contextProperty == null) {
            this.getLogger().logWarningMessage("metadata_default_tenant_table_discriminator_context_property", descriptor.getJavaClass(), "eclipselink.tenant-id");
            policy.setContextProperty("eclipselink.tenant-id");
        } else {
            policy.setContextProperty(this.m_contextProperty);
        }
    }

    public void setContextProperty(String contextProperty) {
        this.m_contextProperty = contextProperty;
    }

    public void setType(String type) {
        this.m_type = type;
    }
}

