/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourcePackageInfoCompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.utility.command.CommandContext;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JaxbResourceModelProvider;
import org.eclipse.jpt.jaxb.core.internal.plugin.JptJaxbCorePlugin;

public class JavaPackageInfoResourceModelProvider
implements JaxbResourceModelProvider {
    private static final JaxbResourceModelProvider INSTANCE = new JavaPackageInfoResourceModelProvider();

    public static JaxbResourceModelProvider instance() {
        return INSTANCE;
    }

    private JavaPackageInfoResourceModelProvider() {
    }

    public IContentType getContentType() {
        return JavaResourceCompilationUnit.PACKAGE_INFO_CONTENT_TYPE;
    }

    public JavaResourceCompilationUnit buildResourceModel(JaxbProject jaxbProject, IFile file) {
        ICompilationUnit compilationUnit = JavaCore.createCompilationUnitFrom((IFile)file);
        try {
            if (compilationUnit.getPackageDeclarations().length > 0) {
                return new SourcePackageInfoCompilationUnit(compilationUnit, jaxbProject.getPlatform().getAnnotationProvider(), jaxbProject.getPlatform().getAnnotationEditFormatter(), (CommandContext)jaxbProject.getModifySharedDocumentCommandContext());
            }
            return null;
        }
        catch (JavaModelException e) {
            JptJaxbCorePlugin.instance().logError(e);
            return null;
        }
    }
}

