/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.transformer;

import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class ConditionalTransformer<I, O>
implements Transformer<I, O> {
    private final Predicate<? super I> predicate;
    private final Transformer<? super I, ? extends O> trueTransformer;
    private final Transformer<? super I, ? extends O> falseTransformer;

    public ConditionalTransformer(Predicate<? super I> predicate, Transformer<? super I, ? extends O> trueTransformer, Transformer<? super I, ? extends O> falseTransformer) {
        if (predicate == null || trueTransformer == null || falseTransformer == null) {
            throw new NullPointerException();
        }
        this.predicate = predicate;
        this.trueTransformer = trueTransformer;
        this.falseTransformer = falseTransformer;
    }

    @Override
    public O transform(I input) {
        return this.predicate.evaluate(input) ? this.trueTransformer.transform(input) : this.falseTransformer.transform(input);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.predicate);
    }
}

