/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.graphs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.graphs.NamedAttributeNodeMetadata;
import org.eclipse.persistence.internal.jpa.metadata.graphs.NamedSubgraphMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.queries.AttributeGroup;

public class NamedEntityGraphMetadata
extends ORMetadata {
    protected String m_name;
    protected Boolean m_includeAllAttributes;
    protected List<NamedAttributeNodeMetadata> m_namedAttributeNodes = new ArrayList<NamedAttributeNodeMetadata>();
    protected List<NamedSubgraphMetadata> m_subgraphs = new ArrayList<NamedSubgraphMetadata>();
    protected List<NamedSubgraphMetadata> m_subclassSubgraphs = new ArrayList<NamedSubgraphMetadata>();

    public NamedEntityGraphMetadata() {
        super("<named-entity-graph>");
    }

    public NamedEntityGraphMetadata(MetadataAnnotation namedEntityGraph, EntityAccessor accessor) {
        super(namedEntityGraph, accessor);
        this.m_name = namedEntityGraph.getAttributeString("name");
        this.m_includeAllAttributes = namedEntityGraph.getAttributeBooleanDefaultFalse("include-all-attributes");
        Object[] objectArray = namedEntityGraph.getAttributeArray("attributeNodes");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object namedAttributeNode = objectArray[n2];
            this.m_namedAttributeNodes.add(new NamedAttributeNodeMetadata((MetadataAnnotation)namedAttributeNode, accessor));
            ++n2;
        }
        objectArray = namedEntityGraph.getAttributeArray("subgraphs");
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object subgraph = objectArray[n2];
            this.m_subgraphs.add(new NamedSubgraphMetadata((MetadataAnnotation)subgraph, accessor));
            ++n2;
        }
        objectArray = namedEntityGraph.getAttributeArray("subclassSubgraphs");
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object subclassSubgraph = objectArray[n2];
            this.m_subclassSubgraphs.add(new NamedSubgraphMetadata((MetadataAnnotation)subclassSubgraph, accessor));
            ++n2;
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof NamedEntityGraphMetadata) {
            NamedEntityGraphMetadata entityGraph = (NamedEntityGraphMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_name, entityGraph.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_includeAllAttributes, entityGraph.getIncludeAllAttributes())) {
                return false;
            }
            if (!this.valuesMatch(this.m_namedAttributeNodes, entityGraph.getNamedAttributeNodes())) {
                return false;
            }
            if (!this.valuesMatch(this.m_subgraphs, entityGraph.getSubgraphs())) {
                return false;
            }
            return this.valuesMatch(this.m_subclassSubgraphs, entityGraph.getSubclassSubgraphs());
        }
        return false;
    }

    public Boolean getIncludeAllAttributes() {
        return this.m_includeAllAttributes;
    }

    public String getName() {
        return this.m_name;
    }

    public List<NamedAttributeNodeMetadata> getNamedAttributeNodes() {
        return this.m_namedAttributeNodes;
    }

    public List<NamedSubgraphMetadata> getSubclassSubgraphs() {
        return this.m_subclassSubgraphs;
    }

    public List<NamedSubgraphMetadata> getSubgraphs() {
        return this.m_subgraphs;
    }

    public boolean includeAllAttributes() {
        return this.m_includeAllAttributes != null && this.m_includeAllAttributes != false;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.m_namedAttributeNodes, accessibleObject);
        this.initXMLObjects(this.m_subgraphs, accessibleObject);
        this.initXMLObjects(this.m_subclassSubgraphs, accessibleObject);
    }

    protected boolean hasName() {
        return this.getName() != null && !this.getName().equals("");
    }

    public void process(EntityAccessor entityAccessor) {
        String entityGraphName;
        if (this.hasName()) {
            entityGraphName = this.getName();
        } else {
            entityGraphName = entityAccessor.getEntityName();
            this.getLogger().logConfigMessage("metadata_default_entity_graph_name", entityGraphName, (Object)entityAccessor.getJavaClassName());
        }
        if (this.getProject().hasEntityGraph(entityGraphName)) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"named_entity_graph_exists", (Object[])new Object[]{entityGraphName, entityAccessor.getJavaClassName()}));
        }
        AttributeGroup entityGraph = new AttributeGroup(entityGraphName, entityAccessor.getJavaClassName(), true);
        HashMap<String, Map<String, AttributeGroup>> attributeGraphs = new HashMap<String, Map<String, AttributeGroup>>();
        for (NamedSubgraphMetadata subgraph : this.getSubgraphs()) {
            subgraph.process(attributeGraphs);
        }
        if (this.includeAllAttributes()) {
            for (MappingAccessor accessor : entityAccessor.getDescriptor().getMappingAccessors()) {
                entityGraph.addAttribute(accessor.getAttributeName());
            }
        }
        for (NamedAttributeNodeMetadata attributeNode : this.getNamedAttributeNodes()) {
            attributeNode.process(attributeGraphs, entityGraph, entityGraph);
        }
        for (NamedSubgraphMetadata subgraph : this.getSubgraphs()) {
            subgraph.processAttributeNodes(attributeGraphs, (AttributeGroup)((Map)attributeGraphs.get(subgraph.getName())).get(subgraph.getTypeClassName()), entityGraph);
        }
        for (NamedSubgraphMetadata subclassSubgraph : this.getSubclassSubgraphs()) {
            AttributeGroup group = new AttributeGroup(subclassSubgraph.getName(), subclassSubgraph.getTypeClassName(), true);
            subclassSubgraph.processAttributeNodes(attributeGraphs, group, entityGraph);
            entityGraph.getSubClassGroups().put(group.getTypeName(), group);
        }
        this.getProject().addEntityGraph(entityGraph);
    }

    public void setIncludeAllAttributes(Boolean includeAllAttributes) {
        this.m_includeAllAttributes = includeAllAttributes;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setNamedAttributeNodes(List<NamedAttributeNodeMetadata> attributeNodes) {
        this.m_namedAttributeNodes = attributeNodes;
    }

    public void setSubclassSubgraphs(List<NamedSubgraphMetadata> subclassSubgraphs) {
        this.m_subclassSubgraphs = subclassSubgraphs;
    }

    public void setSubgraphs(List<NamedSubgraphMetadata> subgraphs) {
        this.m_subgraphs = subgraphs;
    }
}

