/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.Convert;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.converters.ConvertMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.EnumeratedMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.LobMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TemporalMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public abstract class DirectAccessor
extends MappingAccessor {
    private Boolean m_optional;
    private EnumeratedMetadata m_enumerated;
    private List<ConvertMetadata> m_converts;
    private LobMetadata m_lob;
    private String m_fetch;
    private String m_convert;
    private TemporalMetadata m_temporal;

    protected DirectAccessor(String xmlElement) {
        super(xmlElement);
    }

    protected DirectAccessor(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(annotation, accessibleObject, classAccessor);
        if (this.isAnnotationPresent("javax.persistence.Lob")) {
            this.m_lob = new LobMetadata(this.getAnnotation("javax.persistence.Lob"), this);
        }
        if (this.isAnnotationPresent("javax.persistence.Enumerated")) {
            this.m_enumerated = new EnumeratedMetadata(this.getAnnotation("javax.persistence.Enumerated"), this);
        }
        if (this.isAnnotationPresent("javax.persistence.Temporal")) {
            this.m_temporal = new TemporalMetadata(this.getAnnotation("javax.persistence.Temporal"), this);
        }
        if (this.isAnnotationPresent(Convert.class)) {
            this.m_convert = this.getAnnotation(Convert.class).getAttributeString("value");
        }
    }

    @Override
    protected void addConvert(ConvertMetadata convert) {
        if (this.m_converts == null) {
            this.m_converts = new ArrayList<ConvertMetadata>();
        }
        this.m_converts.add(convert);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof DirectAccessor) {
            DirectAccessor directAccessor = (DirectAccessor)objectToCompare;
            if (!this.valuesMatch(this.m_optional, directAccessor.getOptional())) {
                return false;
            }
            if (!this.valuesMatch(this.m_enumerated, directAccessor.getEnumerated())) {
                return false;
            }
            if (!this.valuesMatch(this.m_lob, directAccessor.getLob())) {
                return false;
            }
            if (!this.valuesMatch(this.m_fetch, directAccessor.getFetch())) {
                return false;
            }
            if (!this.valuesMatch(this.m_converts, directAccessor.getConverts())) {
                return false;
            }
            return this.valuesMatch(this.m_temporal, directAccessor.getTemporal());
        }
        return false;
    }

    public String getConvert() {
        return this.m_convert;
    }

    public List<ConvertMetadata> getConverts() {
        return this.m_converts;
    }

    @Override
    public abstract String getDefaultFetchType();

    public EnumeratedMetadata getEnumerated() {
        return this.m_enumerated;
    }

    @Override
    public EnumeratedMetadata getEnumerated(boolean isForMapKey) {
        return this.getEnumerated();
    }

    public String getFetch() {
        return this.m_fetch;
    }

    public LobMetadata getLob() {
        return this.m_lob;
    }

    @Override
    public LobMetadata getLob(boolean isForMapKey) {
        if (isForMapKey) {
            return super.getLob(isForMapKey);
        }
        return this.getLob();
    }

    public Boolean getOptional() {
        return this.m_optional;
    }

    public TemporalMetadata getTemporal() {
        return this.m_temporal;
    }

    @Override
    public void setTemporal(TemporalMetadata metadata, boolean isForMapKey) {
        this.m_temporal = metadata;
    }

    @Override
    public TemporalMetadata getTemporal(boolean isForMapKey) {
        return this.getTemporal();
    }

    @Override
    public boolean hasEnumerated(boolean isForMapKey) {
        return this.m_enumerated != null;
    }

    @Override
    public boolean hasLob(boolean isForMapKey) {
        return this.m_lob != null;
    }

    @Override
    public boolean hasTemporal(boolean isForMapKey) {
        return this.m_temporal != null;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.m_enumerated, accessibleObject);
        this.initXMLObject(this.m_lob, accessibleObject);
        this.initXMLObject(this.m_temporal, accessibleObject);
        this.initXMLObjects(this.m_converts, accessibleObject);
        this.m_convert = this.initXMLTextObject(this.m_converts);
    }

    public boolean isOptional() {
        if (this.m_optional == null) {
            return true;
        }
        return this.m_optional;
    }

    public void setConverts(List<ConvertMetadata> converts) {
        this.m_converts = converts;
    }

    public void setEnumerated(EnumeratedMetadata enumerated) {
        this.m_enumerated = enumerated;
    }

    public void setFetch(String fetch) {
        this.m_fetch = fetch;
    }

    public void setLob(LobMetadata lob) {
        this.m_lob = lob;
    }

    public void setOptional(Boolean optional) {
        this.m_optional = optional;
    }

    public void setTemporal(TemporalMetadata temporalType) {
        this.m_temporal = temporalType;
    }

    @Override
    protected boolean usesIndirection() {
        String fetchType = this.getFetch();
        if (fetchType == null) {
            fetchType = this.getDefaultFetchType();
        }
        return fetchType.equals("LAZY");
    }
}

