/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.style;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ColorHelper;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;
import org.eclipse.wst.xsl.ui.internal.XSLUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLTextAttributeMap {
    private static HashMap<String, TextAttribute> textAttributeMap = new HashMap();
    private static XSLTextAttributeMap xslTextAttributeMap = new XSLTextAttributeMap();
    private static IPreferenceStore xslPreferenceStore;

    private static IPreferenceStore getXslPreferenceStore() {
        return xslPreferenceStore;
    }

    private XSLTextAttributeMap() {
        xslPreferenceStore = XSLUIPlugin.getDefault().getPreferenceStore();
        this.addXSLTextAttribute("xsltagName");
        this.addXSLTextAttribute("xsltagBorder");
        this.addXSLTextAttribute("xsltagAttributeName");
        this.addXSLTextAttribute("xsltagAttributeValue");
    }

    public static XSLTextAttributeMap getInstance() {
        return xslTextAttributeMap;
    }

    public Map<String, TextAttribute> getTextAttributeMap() {
        return textAttributeMap;
    }

    protected void addXSLTextAttribute(String colorKey) {
        String prefString;
        String[] stylePrefs;
        if (XSLTextAttributeMap.getXslPreferenceStore() != null && (stylePrefs = ColorHelper.unpackStylePreferences((String)(prefString = XSLTextAttributeMap.getXslPreferenceStore().getString(colorKey)))) != null) {
            RGB foreground = ColorHelper.toRGB((String)stylePrefs[0]);
            RGB background = ColorHelper.toRGB((String)stylePrefs[1]);
            boolean bold = Boolean.valueOf(stylePrefs[2]);
            boolean italic = Boolean.valueOf(stylePrefs[3]);
            boolean strikethrough = Boolean.valueOf(stylePrefs[4]);
            boolean underline = Boolean.valueOf(stylePrefs[5]);
            int style = 0;
            if (bold) {
                style |= 1;
            }
            if (italic) {
                style |= 2;
            }
            if (strikethrough) {
                style |= 0x20000000;
            }
            if (underline) {
                style |= 0x40000000;
            }
            TextAttribute createTextAttribute = this.createTextAttribute(foreground, background, style);
            textAttributeMap.put(colorKey, createTextAttribute);
        }
    }

    protected TextAttribute createTextAttribute(RGB foreground, RGB background, int style) {
        return new TextAttribute(foreground != null ? EditorUtility.getColor((RGB)foreground) : null, background != null ? EditorUtility.getColor((RGB)background) : null, style);
    }
}

