/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import java.util.Iterator;
import java.util.List;
import javax.wsdl.BindingOperation;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.log.MimePart;
import org.eclipse.wst.wsi.internal.core.log.MimeParts;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.MIMEUtils;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Document;

public class AP1942
extends AssertionProcess
implements WSITag {
    private final BaseMessageValidator validator;

    public AP1942(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Message message;
            List extElems;
            if (!entryContext.getMessageEntry().isMimeContent()) {
                throw new AssertionNotApplicableException();
            }
            MimeParts mimeParts = entryContext.getMessageEntry().getMimeParts();
            if (mimeParts.count() < 2) {
                throw new AssertionNotApplicableException();
            }
            BindingOperation bindingOperation = this.validator.getOperationMatch(entryContext.getEntry().getEntryType(), entryContext.getMessageEntryDocument());
            if (bindingOperation == null) {
                throw new AssertionNotApplicableException();
            }
            if ("request".equals(entryContext.getEntry().getEntryType())) {
                extElems = bindingOperation.getBindingInput() == null ? null : bindingOperation.getBindingInput().getExtensibilityElements();
                message = bindingOperation.getOperation().getInput() == null ? null : bindingOperation.getOperation().getInput().getMessage();
            } else {
                extElems = bindingOperation.getBindingOutput() == null ? null : bindingOperation.getBindingOutput().getExtensibilityElements();
                message = bindingOperation.getOperation().getOutput() == null ? null : bindingOperation.getOperation().getOutput().getMessage();
            }
            boolean mimeContentFound = false;
            Iterator iMimeParts = mimeParts.getParts().iterator();
            int i = 0;
            while (iMimeParts.hasNext()) {
                QName refName;
                Part part;
                String partName;
                MimePart mimePart;
                block15: {
                    ++i;
                    mimePart = (MimePart)iMimeParts.next();
                    partName = MIMEUtils.getMimeHeaderAttribute(mimePart.getHeaders(), "Content-ID");
                    try {
                        int idx = partName.indexOf("=");
                        if (idx == -1 || !partName.startsWith("<")) break block15;
                        partName = this.encodePartName(partName.substring(1, idx));
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (!this.boundToMimeContent(extElems, partName) || message == null || (part = (Part)message.getParts().get(partName)) == null || (refName = part.getElementName()) == null) continue;
                mimeContentFound = true;
                Document doc = null;
                try {
                    doc = XMLUtils.parseXML(mimePart.getContent());
                }
                catch (Exception exception) {}
                if (doc == null) {
                    throw new AssertionFailException("The bound message part of the MIME part number " + (i + 1) + " is invalid XML infoset.");
                }
                QName rootName = new QName(doc.getDocumentElement().getNamespaceURI(), doc.getDocumentElement().getLocalName());
                if (refName.equals(rootName)) continue;
                throw new AssertionFailException("The root element name is " + rootName + ", the name of the referenced element is " + refName + ".");
            }
            if (!mimeContentFound) {
                throw new AssertionNotApplicableException();
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException afe) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(afe.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean boundToMimeContent(List extElems, String part) {
        ExtensibilityElement extElem;
        if (extElems != null && extElems.size() > 0 && (extElem = (ExtensibilityElement)extElems.get(0)).getElementType().equals(WSDL_MIME_MULTIPART)) {
            List mimeParts = ((MIMEMultipartRelated)extElem).getMIMEParts();
            int i = 0;
            while (i < mimeParts.size()) {
                ExtensibilityElement elem;
                List elems = ((MIMEPart)mimeParts.get(i)).getExtensibilityElements();
                if (elems.size() > 0 && (elem = (ExtensibilityElement)elems.get(0)).getElementType().equals(WSDL_MIME_CONTENT) && part.equals(((MIMEContent)elem).getPart())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private String encodePartName(String str) {
        StringBuffer res = new StringBuffer("");
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '%' && str.length() > i + 2) {
                try {
                    int value = Integer.parseInt(String.valueOf(String.valueOf(str.charAt(i + 1))) + String.valueOf(str.charAt(i + 2)), 16);
                    res.append((char)value);
                    i += 2;
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                res.append(str.charAt(i));
            }
            ++i;
        }
        return res.toString();
    }
}

