/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.actions;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDDragAction;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IASDObject;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IMessageReference;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IOperation;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IParameter;

public class ASDDragReorderAction
extends ASDDragAction {
    protected IASDObject movingChild;
    protected IASDObject newParent;
    protected GraphicalEditPart leftSiblingEditPart;
    protected GraphicalEditPart rightSiblingEditPart;
    protected IASDObject leftSibElement;
    protected IASDObject rightSibElement;
    protected boolean canNeverExecute = false;

    public ASDDragReorderAction(GraphicalEditPart movingChildEditPart, EditPart pointerEditPart, Point pointerLocation) {
        super(null);
        this.movingChildEditPart = movingChildEditPart;
        this.pointerLocation = pointerLocation;
        EditPart possibleParent = this.getParentEditPart(pointerEditPart);
        if (!(possibleParent instanceof GraphicalEditPart)) {
            this.canNeverExecute = true;
            return;
        }
        GraphicalEditPart targetParentEditPart = (GraphicalEditPart)possibleParent;
        if (pointerEditPart.getParent() != null) {
            List targetEditPartSiblings = pointerEditPart.getParent().getChildren();
            Collections.sort(targetEditPartSiblings, new VerticalEditPartComparator());
            this.leftSiblingEditPart = this.getVerticalLeftSibling(targetEditPartSiblings, movingChildEditPart, pointerLocation);
            this.rightSiblingEditPart = this.getVerticalRightSibling(targetEditPartSiblings, movingChildEditPart, pointerLocation);
            if (movingChildEditPart != null) {
                this.movingChild = (IASDObject)movingChildEditPart.getModel();
            }
            if (this.leftSiblingEditPart != null) {
                this.leftSibElement = (IASDObject)this.leftSiblingEditPart.getModel();
            }
            if (this.rightSiblingEditPart != null) {
                this.rightSibElement = (IASDObject)this.rightSiblingEditPart.getModel();
            }
            this.newParent = (IASDObject)targetParentEditPart.getModel();
        } else {
            this.newParent = (IASDObject)targetParentEditPart.getModel();
            this.leftSibElement = null;
            this.rightSibElement = null;
        }
    }

    public boolean canExecute() {
        boolean result = false;
        if (this.canNeverExecute || this.newParent == null || this.movingChild == null) {
            return false;
        }
        if (this.movingChild instanceof IMessageReference) {
            IMessageReference messageRef = (IMessageReference)this.movingChild;
            if (messageRef.getKind() == 1 || messageRef.getKind() == 2) {
                IMessageReference leftSibMessageRef = (IMessageReference)this.leftSibElement;
                result = true;
                if (leftSibMessageRef != null && leftSibMessageRef.getKind() == 3) {
                    result = false;
                }
                if (!result || !this.newParent.equals(messageRef.getOwnerOperation())) {
                    result = false;
                }
            }
        } else if (this.movingChild instanceof IParameter && this.newParent instanceof IMessageReference && this.newParent.equals(((IParameter)this.movingChild).getOwner())) {
            result = true;
        }
        return result;
    }

    public void run() {
        if (this.canExecute()) {
            Object paramOwner;
            if (this.movingChild instanceof IMessageReference) {
                IOperation messageRefOwner = ((IMessageReference)this.movingChild).getOwnerOperation();
                if (messageRefOwner instanceof IOperation) {
                    IMessageReference leftSib = (IMessageReference)this.leftSibElement;
                    IMessageReference rightSib = (IMessageReference)this.rightSibElement;
                    IMessageReference movingSib = (IMessageReference)this.movingChild;
                    Command command = messageRefOwner.getReorderMessageReferencesCommand(leftSib, rightSib, movingSib);
                    command.execute();
                }
            } else if (this.movingChild instanceof IParameter && (paramOwner = ((IParameter)this.movingChild).getOwner()) instanceof IMessageReference) {
                IParameter leftSib = (IParameter)this.leftSibElement;
                IParameter rightSib = (IParameter)this.rightSibElement;
                IParameter movingSib = (IParameter)this.movingChild;
                Command command = ((IMessageReference)paramOwner).getReorderParametersCommand(leftSib, rightSib, movingSib);
                command.execute();
            }
        }
    }

    public IFigure getFeedbackFigure() {
        Polyline feedbackFigure = null;
        if (feedbackFigure == null && this.movingChildEditPart instanceof GraphicalEditPart) {
            feedbackFigure = new Polyline();
            feedbackFigure.setLineWidth(2);
            this.drawLines(feedbackFigure);
        }
        return feedbackFigure;
    }

    private PointList drawLines(Polyline polyLine) {
        PointList pointList = new PointList();
        if (this.leftSiblingEditPart != null) {
            Rectangle leftRectangle = this.leftSiblingEditPart.getFigure().getBounds();
            int xCoord = leftRectangle.x;
            int yCoord = leftRectangle.y;
            int height = leftRectangle.height;
            int width = leftRectangle.width;
            this.addLineToPolyline(polyLine, xCoord, yCoord + height + 3, xCoord, yCoord + height - 3);
            this.addLineToPolyline(polyLine, xCoord, yCoord + height - 3, xCoord, yCoord + height);
            this.addLineToPolyline(polyLine, xCoord, yCoord + height, xCoord + width, yCoord + height);
            this.addLineToPolyline(polyLine, xCoord + width, yCoord + height, xCoord + width, yCoord + height - 3);
            this.addLineToPolyline(polyLine, xCoord + width, yCoord + height, xCoord + width, yCoord + height + 3);
        } else if (this.rightSiblingEditPart != null) {
            Rectangle rightRectangle = this.rightSiblingEditPart.getFigure().getBounds();
            int xCoord = rightRectangle.x;
            int yCoord = rightRectangle.y;
            int width = rightRectangle.width;
            this.addLineToPolyline(polyLine, xCoord, yCoord + 3, xCoord, yCoord - 3);
            this.addLineToPolyline(polyLine, xCoord, yCoord - 3, xCoord, yCoord);
            this.addLineToPolyline(polyLine, xCoord, yCoord, xCoord + width, yCoord);
            this.addLineToPolyline(polyLine, xCoord + width, yCoord, xCoord + width, yCoord - 3);
            this.addLineToPolyline(polyLine, xCoord + width, yCoord, xCoord + width, yCoord + 3);
        }
        return pointList;
    }

    protected Polyline addLineToPolyline(Polyline polyline, int x1, int y1, int x2, int y2) {
        polyline.addPoint(new Point(x1, y1));
        polyline.addPoint(new Point(x2, y2));
        return polyline;
    }

    private GraphicalEditPart getVerticalRightSibling(List siblings, GraphicalEditPart movingEditPart, Point pointerLocation) {
        GraphicalEditPart rightSibling = null;
        int pointerYLocation = pointerLocation.y;
        int index = 0;
        while (index < siblings.size()) {
            GraphicalEditPart sibling = (GraphicalEditPart)siblings.get(index);
            int siblingYLocation = sibling.getFigure().getBounds().getCenter().y;
            if (siblingYLocation > pointerYLocation) {
                rightSibling = sibling;
                break;
            }
            ++index;
        }
        return rightSibling;
    }

    private GraphicalEditPart getVerticalLeftSibling(List siblings, GraphicalEditPart movingEditPart, Point pointerLocation) {
        GraphicalEditPart leftSibling = null;
        int pointerYLocation = pointerLocation.y;
        int index = 0;
        while (index < siblings.size()) {
            GraphicalEditPart sibling = (GraphicalEditPart)siblings.get(index);
            int siblingYLocation = sibling.getFigure().getBounds().getCenter().y;
            if (siblingYLocation > pointerYLocation) {
                if (index <= 0) break;
                leftSibling = (GraphicalEditPart)siblings.get(index - 1);
                break;
            }
            ++index;
        }
        if (index == siblings.size()) {
            leftSibling = (GraphicalEditPart)siblings.get(index - 1);
        }
        return leftSibling;
    }

    protected EditPart getParentEditPart(EditPart target) {
        return target.getParent();
    }

    private class VerticalEditPartComparator
    implements Comparator {
        public int compare(Object part1, Object part2) {
            int compareValue = 0;
            if (part1 instanceof GraphicalEditPart && part2 instanceof GraphicalEditPart) {
                GraphicalEditPart editPart1 = (GraphicalEditPart)part1;
                GraphicalEditPart editPart2 = (GraphicalEditPart)part2;
                int editPart1Y = editPart1.getFigure().getBounds().getCenter().y;
                int editPart2Y = editPart2.getFigure().getBounds().getCenter().y;
                Integer integerPart1 = new Integer(editPart1Y);
                Integer integerPart2 = new Integer(editPart2Y);
                compareValue = integerPart1.compareTo(integerPart2);
            }
            return compareValue;
        }
    }
}

