/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.template.java;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.wst.jsdt.internal.corext.template.java.JavaTemplateMessages;

public abstract class CompilationUnitContextType
extends TemplateContextType {
    public CompilationUnitContextType(String name) {
        super(name);
    }

    public abstract CompilationUnitContext createContext(IDocument var1, int var2, int var3, IJavaScriptUnit var4);

    public abstract CompilationUnitContext createContext(IDocument var1, Position var2, IJavaScriptUnit var3);

    protected void validateVariables(TemplateVariable[] variables) throws TemplateException {
        int i = 0;
        while (i < variables.length) {
            TemplateVariable var = variables[i];
            if (var.getType().equals("cursor") && var.getOffsets().length > 1) {
                throw new TemplateException(JavaTemplateMessages.ContextType_error_multiple_cursor_variables);
            }
            ++i;
        }
    }

    protected static class Arguments
    extends TemplateVariableResolver {
        public Arguments() {
            super("enclosing_method_arguments", JavaTemplateMessages.CompilationUnitContextType_variable_description_enclosing_method_arguments);
        }

        protected String resolve(TemplateContext context) {
            IJavaScriptElement element = ((CompilationUnitContext)context).findEnclosingElement(9);
            if (element == null) {
                return null;
            }
            IFunction method = (IFunction)element;
            try {
                String[] arguments = method.getParameterNames();
                StringBuffer buffer = new StringBuffer();
                int i = 0;
                while (i < arguments.length) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(arguments[i]);
                    ++i;
                }
                return buffer.toString();
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return null;
            }
        }
    }

    protected static class EnclosingJavaElement
    extends TemplateVariableResolver {
        protected final int fElementType;

        public EnclosingJavaElement(String name, String description, int elementType) {
            super(name, description);
            this.fElementType = elementType;
        }

        protected String resolve(TemplateContext context) {
            IJavaScriptElement element = ((CompilationUnitContext)context).findEnclosingElement(this.fElementType);
            return element == null ? null : element.getElementName();
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return this.resolve(context) != null;
        }
    }

    protected static class File
    extends TemplateVariableResolver {
        public File() {
            super("file", JavaTemplateMessages.CompilationUnitContextType_variable_description_file);
        }

        protected String resolve(TemplateContext context) {
            IJavaScriptUnit unit = ((CompilationUnitContext)context).getCompilationUnit();
            return unit == null ? null : unit.getElementName();
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return this.resolve(context) != null;
        }
    }

    protected static class Method
    extends EnclosingJavaElement {
        public Method() {
            super("enclosing_method", JavaTemplateMessages.CompilationUnitContextType_variable_description_enclosing_method, 9);
        }
    }

    protected static class Package
    extends EnclosingJavaElement {
        public Package() {
            super("enclosing_package", JavaTemplateMessages.CompilationUnitContextType_variable_description_enclosing_package, 4);
        }
    }

    protected static class PrimaryTypeName
    extends TemplateVariableResolver {
        public PrimaryTypeName() {
            super("primary_type_name", JavaTemplateMessages.CompilationUnitContextType_variable_description_primary_type_name);
        }

        protected String resolve(TemplateContext context) {
            IJavaScriptUnit unit = ((CompilationUnitContext)context).getCompilationUnit();
            if (unit == null) {
                return null;
            }
            return JavaScriptCore.removeJavaScriptLikeExtension((String)unit.getElementName());
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return this.resolve(context) != null;
        }
    }

    protected static class Project
    extends EnclosingJavaElement {
        public Project() {
            super("enclosing_project", JavaTemplateMessages.CompilationUnitContextType_variable_description_enclosing_project, 2);
        }
    }

    protected static class ReturnType
    extends TemplateVariableResolver {
        public ReturnType() {
            super("return_type", JavaTemplateMessages.CompilationUnitContextType_variable_description_return_type);
        }

        protected String resolve(TemplateContext context) {
            IJavaScriptElement element = ((CompilationUnitContext)context).findEnclosingElement(9);
            if (element == null) {
                return null;
            }
            try {
                return Signature.toString((String)((IFunction)element).getReturnType());
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return null;
            }
        }
    }

    protected static class Type
    extends EnclosingJavaElement {
        public Type() {
            super("enclosing_type", JavaTemplateMessages.CompilationUnitContextType_variable_description_enclosing_type, 7);
        }
    }
}

