/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.common.build.system.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class IFileSelectionDialog
extends ElementTreeSelectionDialog {
    private String[] extensions;
    private static ITreeContentProvider contentProvider = new ITreeContentProvider(){

        public Object[] getChildren(Object element) {
            if (element instanceof IContainer) {
                try {
                    return ((IContainer)element).members();
                }
                catch (CoreException coreException) {}
            }
            return null;
        }

        public Object getParent(Object element) {
            return ((IResource)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return element instanceof IContainer;
        }

        public Object[] getElements(Object input) {
            return (Object[])input;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    };
    private static final IStatus OK = new Status(0, "org.eclipse.wst.jsdt.js.common", 0, "", null);
    private static final IStatus ERROR = new Status(4, "org.eclipse.wst.jsdt.js.common", 0, "", null);
    private ISelectionStatusValidator validator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] selection) {
            return selection.length == 1 && selection[0] instanceof IFile && IFileSelectionDialog.this.checkExtension(((IFile)selection[0]).getFileExtension()) ? OK : ERROR;
        }
    };

    public IFileSelectionDialog(String title, String message, String[] type) {
        this(Display.getDefault().getActiveShell(), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), contentProvider);
        this.extensions = type;
        this.setTitle(title);
        this.setMessage(message);
        this.setInput(this.computeInput());
        this.setValidator(this.validator);
    }

    public IFileSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
    }

    private Object[] computeInput() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            try {
                projects[i].refreshLocal(2, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(1, null);
        }
        catch (CoreException coreException) {}
        ArrayList<IProject> openProjects = new ArrayList<IProject>(projects.length);
        int i2 = 0;
        while (i2 < projects.length) {
            if (projects[i2].isOpen()) {
                openProjects.add(projects[i2]);
            }
            ++i2;
        }
        return openProjects.toArray();
    }

    private boolean checkExtension(String name) {
        if (name.equals("*")) {
            return true;
        }
        int i = 0;
        while (i < this.extensions.length) {
            if (this.extensions[i].equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

