/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.tests.contentassist;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.web.ui.tests.contentassist.ContentAssistTestUtilities;
import org.eclipse.wst.jsdt.web.ui.tests.internal.TestProjectSetup;

public class GlobalVariableTests
extends TestCase {
    private static final String TEST_NAME = "Test Global Field Variables JavaScript Content Assist";
    private static TestProjectSetup fTestProjectSetup;
    static /* synthetic */ Class class$0;

    public GlobalVariableTests() {
        super(TEST_NAME);
    }

    public GlobalVariableTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.ui.tests.contentassist.GlobalVariableTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite ts = new TestSuite((Class)clazz, TEST_NAME);
        fTestProjectSetup = new TestProjectSetup((Test)ts, "JSDTWebContentAssist", "WebContent", false);
        return fTestProjectSetup;
    }

    public void testFindGlobalVariables_Expression_NotStarted() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalNum : Number - Global", "globalString : String - Global", "globalVar - Global", "globalVarNum : Number - Global", "globalVarObject : {} - Global", "globalVarString : String - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "Global.html", 6, 0, expectedProposals);
    }

    public void testFindGlobalVariables_ExpressionStarted_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalNum : Number - Global", "globalString : String - Global", "globalVar - Global", "globalVarNum : Number - Global", "globalVarObject : {} - Global", "globalVarString : String - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "Global.html", 8, 1, expectedProposals);
    }

    public void testFindGlobalVariables_NegativeTest_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalNum : Number - Global", "globalString : String - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "Global.html", 10, 7, expectedProposals, true, false);
    }

    public void testFindGlobalVariables_ExpressionStarted_2() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalVarNum : Number - Global", "globalVarObject : {} - Global", "globalVarString : String - Global", "globalVar - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "Global.html", 10, 7, expectedProposals);
    }
}

