/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.relation;

import org.easymock.EasyMock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedMappedByRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.SpecifiedRelationshipStrategy;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToManyBiDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToManyUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToOneBiDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToOneUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToManyUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToOneBiDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToOneUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IEclipseFacade;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.JPACreateFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CreateRelationsInFieldAnnotatedEntitiesTest {
    private IJPAEditorFeatureProvider featureProvider;
    final String TEST_PROJECT = "Test";
    private JpaProject jpaProject = null;
    private JPACreateFactory factory = null;
    IEclipseFacade eclipseFacade = null;

    @Before
    public void setUp() throws Exception {
        this.factory = JPACreateFactory.instance();
        this.jpaProject = this.factory.createJPAProject("Test_" + System.currentTimeMillis());
        Assert.assertNotNull((Object)this.jpaProject);
        IFile entity = this.factory.createEntity(this.jpaProject, "org.eclipse.Entity1");
        Thread.sleep(2000L);
        this.featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        EasyMock.expect((Object)this.featureProvider.getBusinessObjectForPictogramElement(null)).andReturn((Object)JPACreateFactory.getPersistentType(entity));
        EasyMock.expect((Object)this.featureProvider.getCompilationUnit((PersistentType)EasyMock.isA(PersistentType.class))).andReturn((Object)JavaCore.createCompilationUnitFrom((IFile)entity)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.featureProvider});
    }

    public ICompilationUnit createCompilationUnitFrom(IFile file) {
        return JavaCore.createCompilationUnitFrom((IFile)file);
    }

    @Test
    public void testCreateOneToOneUnidirRelation() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        PersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        }
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourceAbstractType addressType = this.jpaProject.getJavaResourceType("com.Address");
        Assert.assertNotNull((Object)customerType);
        PersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getTypeBinding().getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getTypeBinding().getQualifiedName());
        }
        ICompilationUnit cu1 = this.createCompilationUnitFrom((IFile)t1.getResource());
        OneToOneUniDirRelation rel = new OneToOneUniDirRelation(this.featureProvider, t1, t2, "address", true, false);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)t1, (Object)rel.getOwner());
        Assert.assertSame((Object)t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        PersistentAttribute ownerAt = t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        AttributeMapping attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(ownerAt);
        Assert.assertTrue((boolean)RelationshipMapping.class.isInstance(attributeMapping));
        Assert.assertEquals((Object)"oneToOne", (Object)attributeMapping.getKey());
        SpecifiedRelationshipStrategy strategy = ((RelationshipMapping)attributeMapping).getRelationship().getStrategy();
        Assert.assertTrue((boolean)SpecifiedMappedByRelationshipStrategy.class.isInstance(strategy));
        Assert.assertNull((Object)((SpecifiedMappedByRelationshipStrategy)strategy).getMappedByAttribute());
        Assert.assertTrue((boolean)cu1.isWorkingCopy());
        IType javaType = cu1.findPrimaryType();
        IField f = javaType.getField("address");
        Assert.assertTrue((boolean)f.exists());
    }

    @Test
    public void testCreateOneToOneBidirRelation() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        PersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        }
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourceAbstractType addressType = this.jpaProject.getJavaResourceType("com.Address");
        Assert.assertNotNull((Object)customerType);
        PersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getTypeBinding().getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getTypeBinding().getQualifiedName());
        }
        ICompilationUnit cu1 = this.createCompilationUnitFrom((IFile)t1.getResource());
        ICompilationUnit cu2 = this.createCompilationUnitFrom((IFile)t2.getResource());
        OneToOneBiDirRelation rel = new OneToOneBiDirRelation(this.featureProvider, t1, t2, "address", "customer", true, null, false);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)t1, (Object)rel.getOwner());
        Assert.assertSame((Object)t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        PersistentAttribute ownerAt = t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        AttributeMapping attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(ownerAt);
        Assert.assertTrue((boolean)RelationshipMapping.class.isInstance(attributeMapping));
        Assert.assertEquals((Object)"oneToOne", (Object)attributeMapping.getKey());
        SpecifiedRelationshipStrategy strategy = ((RelationshipMapping)attributeMapping).getRelationship().getStrategy();
        Assert.assertTrue((boolean)SpecifiedMappedByRelationshipStrategy.class.isInstance(strategy));
        Assert.assertNull((Object)((SpecifiedMappedByRelationshipStrategy)strategy).getMappedByAttribute());
        PersistentAttribute inverseAt = t2.getAttributeNamed("customer");
        Assert.assertNotNull((Object)inverseAt);
        attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(inverseAt);
        Assert.assertTrue((boolean)RelationshipMapping.class.isInstance(attributeMapping));
        Assert.assertEquals((Object)"oneToOne", (Object)attributeMapping.getKey());
        strategy = ((RelationshipMapping)attributeMapping).getRelationship().getStrategy();
        Assert.assertTrue((boolean)SpecifiedMappedByRelationshipStrategy.class.isInstance(strategy));
        Assert.assertEquals((Object)"address", (Object)((SpecifiedMappedByRelationshipStrategy)strategy).getMappedByAttribute());
        Assert.assertTrue((boolean)cu1.isWorkingCopy());
        Assert.assertTrue((boolean)cu2.isWorkingCopy());
        IType javaType1 = cu1.findPrimaryType();
        IField f1 = javaType1.getField("address");
        Assert.assertTrue((boolean)f1.exists());
        IType javaType2 = cu2.findPrimaryType();
        IField f2 = javaType2.getField("customer");
        Assert.assertTrue((boolean)f2.exists());
    }

    @Test
    public void testCreateOneToManyUnidirRelation() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        PersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        }
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourceAbstractType addressType = this.jpaProject.getJavaResourceType("com.Address");
        Assert.assertNotNull((Object)customerType);
        PersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getTypeBinding().getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getTypeBinding().getQualifiedName());
        }
        ICompilationUnit cu1 = this.createCompilationUnitFrom((IFile)t1.getResource());
        OneToManyUniDirRelation rel = new OneToManyUniDirRelation(this.featureProvider, t1, t2, "address", true);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)t1, (Object)rel.getOwner());
        Assert.assertSame((Object)t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        PersistentAttribute ownerAt = t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        AttributeMapping attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(ownerAt);
        Assert.assertTrue((boolean)RelationshipMapping.class.isInstance(attributeMapping));
        Assert.assertEquals((Object)"oneToMany", (Object)attributeMapping.getKey());
        SpecifiedRelationshipStrategy strategy = ((RelationshipMapping)attributeMapping).getRelationship().getStrategy();
        Assert.assertTrue((boolean)SpecifiedMappedByRelationshipStrategy.class.isInstance(strategy));
        Assert.assertNull((Object)((SpecifiedMappedByRelationshipStrategy)strategy).getMappedByAttribute());
        Assert.assertTrue((boolean)cu1.isWorkingCopy());
        IType javaType1 = cu1.findPrimaryType();
        IField f1 = javaType1.getField("address");
        Assert.assertTrue((boolean)f1.exists());
    }

    @Test
    public void testCreateManyToOneUnidirRelation() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        PersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        }
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourceAbstractType addressType = this.jpaProject.getJavaResourceType("com.Address");
        Assert.assertNotNull((Object)customerType);
        PersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getTypeBinding().getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getTypeBinding().getQualifiedName());
        }
        ICompilationUnit cu1 = this.createCompilationUnitFrom((IFile)t1.getResource());
        ManyToOneUniDirRelation rel = new ManyToOneUniDirRelation(this.featureProvider, t1, t2, "address", true, false);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)t1, (Object)rel.getOwner());
        Assert.assertSame((Object)t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        PersistentAttribute ownerAt = t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        AttributeMapping attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(ownerAt);
        Assert.assertTrue((boolean)RelationshipMapping.class.isInstance(attributeMapping));
        Assert.assertEquals((Object)"manyToOne", (Object)attributeMapping.getKey());
        SpecifiedRelationshipStrategy strategy = ((RelationshipMapping)attributeMapping).getRelationship().getStrategy();
        Assert.assertTrue((boolean)SpecifiedMappedByRelationshipStrategy.class.isInstance(strategy));
        Assert.assertNull((Object)((SpecifiedMappedByRelationshipStrategy)strategy).getMappedByAttribute());
        Assert.assertTrue((boolean)cu1.isWorkingCopy());
        IType javaType1 = cu1.findPrimaryType();
        IField f1 = javaType1.getField("address");
        Assert.assertTrue((boolean)f1.exists());
    }

    @Test
    public void testCreateManyToOneBidirRelation() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        PersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        }
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourceAbstractType addressType = this.jpaProject.getJavaResourceType("com.Address");
        Assert.assertNotNull((Object)customerType);
        PersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getTypeBinding().getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getTypeBinding().getQualifiedName());
        }
        ICompilationUnit cu1 = this.createCompilationUnitFrom((IFile)t1.getResource());
        ICompilationUnit cu2 = this.createCompilationUnitFrom((IFile)t2.getResource());
        ManyToOneBiDirRelation rel = new ManyToOneBiDirRelation(this.featureProvider, t1, t2, "address", "customer", true, null, false);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)t1, (Object)rel.getOwner());
        Assert.assertSame((Object)t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        PersistentAttribute ownerAt = t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        AttributeMapping attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(ownerAt);
        Assert.assertTrue((boolean)RelationshipMapping.class.isInstance(attributeMapping));
        Assert.assertEquals((Object)"manyToOne", (Object)attributeMapping.getKey());
        SpecifiedRelationshipStrategy strategy = ((RelationshipMapping)attributeMapping).getRelationship().getStrategy();
        Assert.assertTrue((boolean)SpecifiedMappedByRelationshipStrategy.class.isInstance(strategy));
        Assert.assertNull((Object)((SpecifiedMappedByRelationshipStrategy)strategy).getMappedByAttribute());
        PersistentAttribute inverseAt = t2.getAttributeNamed("customer");
        Assert.assertNotNull((Object)inverseAt);
        attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(inverseAt);
        Assert.assertTrue((boolean)RelationshipMapping.class.isInstance(attributeMapping));
        Assert.assertEquals((Object)"oneToMany", (Object)attributeMapping.getKey());
        strategy = ((RelationshipMapping)attributeMapping).getRelationship().getStrategy();
        Assert.assertTrue((boolean)SpecifiedMappedByRelationshipStrategy.class.isInstance(strategy));
        Assert.assertEquals((Object)"address", (Object)((SpecifiedMappedByRelationshipStrategy)strategy).getMappedByAttribute());
        Assert.assertTrue((boolean)cu1.isWorkingCopy());
        Assert.assertTrue((boolean)cu2.isWorkingCopy());
        IType javaType1 = cu1.findPrimaryType();
        IField f1 = javaType1.getField("address");
        Assert.assertTrue((boolean)f1.exists());
        IType javaType2 = cu2.findPrimaryType();
        IField f2 = javaType2.getField("customer");
        Assert.assertTrue((boolean)f2.exists());
    }

    @Test
    public void testCreateManyToManyUnidirRelation() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        PersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        }
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourceAbstractType addressType = this.jpaProject.getJavaResourceType("com.Address");
        Assert.assertNotNull((Object)customerType);
        PersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getTypeBinding().getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getTypeBinding().getQualifiedName());
        }
        ICompilationUnit cu1 = this.createCompilationUnitFrom((IFile)t1.getResource());
        ManyToManyUniDirRelation rel = new ManyToManyUniDirRelation(this.featureProvider, t1, t2, "address", true);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)t1, (Object)rel.getOwner());
        Assert.assertSame((Object)t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        PersistentAttribute ownerAt = t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        AttributeMapping attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(ownerAt);
        Assert.assertTrue((boolean)RelationshipMapping.class.isInstance(attributeMapping));
        Assert.assertEquals((Object)"manyToMany", (Object)attributeMapping.getKey());
        SpecifiedRelationshipStrategy strategy = ((RelationshipMapping)attributeMapping).getRelationship().getStrategy();
        Assert.assertTrue((boolean)SpecifiedMappedByRelationshipStrategy.class.isInstance(strategy));
        Assert.assertNull((Object)((SpecifiedMappedByRelationshipStrategy)strategy).getMappedByAttribute());
        Assert.assertTrue((boolean)cu1.isWorkingCopy());
        IType javaType1 = cu1.findPrimaryType();
        IField f1 = javaType1.getField("address");
        Assert.assertTrue((boolean)f1.exists());
    }

    @Test
    public void testCreateManyToManyBidirRelation() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createFieldAnnotatedEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        PersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        }
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourceAbstractType addressType = this.jpaProject.getJavaResourceType("com.Address");
        Assert.assertNotNull((Object)customerType);
        PersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getTypeBinding().getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getTypeBinding().getQualifiedName());
        }
        ICompilationUnit cu1 = this.createCompilationUnitFrom((IFile)t1.getResource());
        ICompilationUnit cu2 = this.createCompilationUnitFrom((IFile)t2.getResource());
        ManyToManyBiDirRelation rel = new ManyToManyBiDirRelation(this.featureProvider, t1, t2, "address", "customer", true, null);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)t1, (Object)rel.getOwner());
        Assert.assertSame((Object)t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        PersistentAttribute ownerAt = t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        AttributeMapping attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(ownerAt);
        Assert.assertTrue((boolean)RelationshipMapping.class.isInstance(attributeMapping));
        Assert.assertEquals((Object)"manyToMany", (Object)attributeMapping.getKey());
        SpecifiedRelationshipStrategy strategy = ((RelationshipMapping)attributeMapping).getRelationship().getStrategy();
        Assert.assertTrue((boolean)SpecifiedMappedByRelationshipStrategy.class.isInstance(strategy));
        Assert.assertNull((Object)((SpecifiedMappedByRelationshipStrategy)strategy).getMappedByAttribute());
        PersistentAttribute inverseAt = t2.getAttributeNamed("customer");
        Assert.assertNotNull((Object)inverseAt);
        attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(inverseAt);
        Assert.assertTrue((boolean)RelationshipMapping.class.isInstance(attributeMapping));
        Assert.assertEquals((Object)"manyToMany", (Object)attributeMapping.getKey());
        strategy = ((RelationshipMapping)attributeMapping).getRelationship().getStrategy();
        Assert.assertTrue((boolean)SpecifiedMappedByRelationshipStrategy.class.isInstance(strategy));
        Assert.assertEquals((Object)"address", (Object)((SpecifiedMappedByRelationshipStrategy)strategy).getMappedByAttribute());
        Assert.assertTrue((boolean)cu1.isWorkingCopy());
        Assert.assertTrue((boolean)cu2.isWorkingCopy());
        IType javaType1 = cu1.findPrimaryType();
        IField f1 = javaType1.getField("address");
        Assert.assertTrue((boolean)f1.exists());
        IType javaType2 = cu2.findPrimaryType();
        IField f2 = javaType2.getField("customer");
        Assert.assertTrue((boolean)f2.exists());
    }

    public boolean isMappedAs(PersistentAttribute jpa, String mappingKey) {
        AttributeMapping attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(jpa);
        Assert.assertTrue((boolean)RelationshipMapping.class.isInstance(attributeMapping));
        Assert.assertEquals((Object)mappingKey, (Object)attributeMapping.getKey());
        return false;
    }
}

