/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.search.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.common.core.search.pattern.QualifiedName;
import org.eclipse.wst.common.core.search.scope.SearchScope;
import org.eclipse.wst.common.core.search.scope.WorkspaceSearchScope;
import org.eclipse.wst.xsd.ui.internal.editor.ISelectionMapper;
import org.eclipse.wst.xsd.ui.internal.search.IXSDSearchConstants;
import org.eclipse.wst.xsd.ui.internal.search.XSDSearchQuery;
import org.eclipse.wst.xsd.ui.internal.search.actions.FindAction;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class FindReferencesAction
extends FindAction {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public FindReferencesAction(IEditorPart editor) {
        super(editor);
    }

    public void setActionDefinitionId(String string) {
    }

    protected IFile getCurrentFile() {
        IEditorInput input;
        if (this.editor != null && (input = this.editor.getEditorInput()) instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)input;
            return fileEditorInput.getFile();
        }
        return null;
    }

    protected QualifiedName determineMetaName(XSDNamedComponent component) {
        QualifiedName metaName = null;
        if (component instanceof XSDComplexTypeDefinition) {
            metaName = IXSDSearchConstants.COMPLEX_TYPE_META_NAME;
        } else if (component instanceof XSDSimpleTypeDefinition) {
            metaName = IXSDSearchConstants.SIMPLE_TYPE_META_NAME;
        } else if (component instanceof XSDElementDeclaration) {
            metaName = IXSDSearchConstants.ELEMENT_META_NAME;
        } else if (component instanceof XSDModelGroupDefinition) {
            metaName = IXSDSearchConstants.GROUP_META_NAME;
        } else if (component instanceof XSDAttributeGroupDefinition) {
            metaName = IXSDSearchConstants.ATTRIBUTE_GROUP_META_NAME;
        } else if (component instanceof XSDAttributeDeclaration) {
            metaName = IXSDSearchConstants.ATTRIBUTE_META_NAME;
        }
        return metaName;
    }

    protected XSDNamedComponent getXSDNamedComponent() {
        if (this.editor != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.viewers.ISelectionProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ISelectionProvider provider = (ISelectionProvider)this.editor.getAdapter((Class)clazz);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.ISelectionMapper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ISelectionMapper mapper = (ISelectionMapper)this.editor.getAdapter((Class)clazz2);
            if (provider != null) {
                IStructuredSelection s;
                Object o;
                ISelection selection = provider.getSelection();
                if (mapper != null) {
                    selection = mapper.mapSelection(selection);
                }
                if (selection != null && selection instanceof IStructuredSelection && (o = (s = (IStructuredSelection)selection).getFirstElement()) != null && o instanceof XSDNamedComponent) {
                    return (XSDNamedComponent)o;
                }
            }
        }
        return null;
    }

    public void run() {
        String pattern = "";
        XSDNamedComponent component = this.getXSDNamedComponent();
        IFile file = this.getCurrentFile();
        if (file != null && component != null) {
            QualifiedName metaName = this.determineMetaName(component);
            QualifiedName elementQName = new QualifiedName(component.getTargetNamespace(), component.getName());
            WorkspaceSearchScope scope = new WorkspaceSearchScope();
            String scopeDescription = "Workspace";
            XSDSearchQuery searchQuery = new XSDSearchQuery(pattern, file, elementQName, metaName, 2, (SearchScope)scope, scopeDescription);
            NewSearchUI.activateSearchResultView();
            NewSearchUI.runQueryInBackground((ISearchQuery)searchQuery);
        }
    }
}

