/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.validation.caret;

import java.util.Arrays;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.validation.caret.ActionData;
import org.eclipse.jst.pagedesigner.validation.caret.DefaultPositionRule;
import org.eclipse.jst.pagedesigner.validation.caret.DropActionData;
import org.eclipse.jst.pagedesigner.validation.caret.RootContainerPositionRule;
import org.eclipse.jst.pagedesigner.validation.caret.Target;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JSFRootContainerPositionRule
extends DefaultPositionRule {
    private static final int DEFAULT_MAX_DEPTH_SEARCH = 3;
    static final String[] JSF_ROOT_CONTAINERS = new String[]{"view", "subview"};

    public JSFRootContainerPositionRule(ActionData actionData) {
        super(actionData);
    }

    public boolean hasEditableArea(Target target) {
        Node node = target.getNode();
        if (JSFRootContainerPositionRule.hasBasicContainers(EditModelQuery.getDocumentNode(node), 3)) {
            ActionData actionData = this.getActionData();
            if (actionData instanceof DropActionData) {
                DropActionData dropActionData = (DropActionData)actionData;
                TagIdentifier tagId = (TagIdentifier)dropActionData.getDropData().getTagIdentifiers().get(0);
                String uri = tagId.getUri();
                if ("http://java.sun.com/jsf/html".equalsIgnoreCase(uri) || "http://java.sun.com/jsf/core".equalsIgnoreCase(uri)) {
                    boolean result = EditModelQuery.isChild(JSF_ROOT_CONTAINERS, node, true, false);
                    return result || EditModelQuery.getChild(node, JSF_ROOT_CONTAINERS, 3, false) != null;
                }
            } else if (this.getActionData().getActionType() == 2) {
                boolean result = EditModelQuery.isChild(JSF_ROOT_CONTAINERS, node, true, false);
                return result || EditModelQuery.getChild(node, JSF_ROOT_CONTAINERS, 3, false) != null;
            }
        }
        return super.isEditable(target);
    }

    public boolean isEditable(Target target) {
        boolean result = true;
        Node node = target.getNode();
        if (JSFRootContainerPositionRule.hasBasicContainers(EditModelQuery.getDocumentNode(node), 3)) {
            ActionData actionData = this.getActionData();
            if (actionData instanceof DropActionData) {
                DropActionData dropActionData = (DropActionData)actionData;
                TagIdentifier tagId = (TagIdentifier)dropActionData.getDropData().getTagIdentifiers().get(0);
                String uri = tagId.getUri();
                if ("http://java.sun.com/jsf/html".equalsIgnoreCase(uri) || "http://java.sun.com/jsf/core".equalsIgnoreCase(uri)) {
                    result = EditModelQuery.isChild(JSF_ROOT_CONTAINERS, node, true, false);
                }
            } else if (this.getActionData().getActionType() == 2) {
                result = EditModelQuery.isChild(JSF_ROOT_CONTAINERS, node, true, false);
            }
            return result;
        }
        return super.isEditable(target);
    }

    public static Node getBasicContainer(Document document, int maxDepth) {
        Node node = EditModelQuery.getChild(document, JSF_ROOT_CONTAINERS, maxDepth, false);
        return node;
    }

    public static boolean hasBasicContainers(Document document, int maxDepth) {
        return JSFRootContainerPositionRule.getBasicContainer(document, maxDepth) != null;
    }

    public boolean canReference(Target target, boolean atRight) {
        Node node = target.getNode();
        if (node.getLocalName() != null && Arrays.asList(JSF_ROOT_CONTAINERS).contains(node.getLocalName().toLowerCase())) {
            return EditModelQuery.isChild(RootContainerPositionRule.HTML_ROOT_CONTAINERS, node, false, false) || EditModelQuery.isChild(JSF_ROOT_CONTAINERS, node, false, false);
        }
        return super.canReference(target, atRight);
    }
}

