/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import org.eclipse.jpt.common.utility.internal.model.value.AbstractPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;

public abstract class CollectionPropertyValueModelAdapter<V, E>
extends AbstractPropertyValueModelAdapter<V> {
    protected final CollectionValueModel<? extends E> collectionModel;
    protected final CollectionChangeListener collectionListener;

    protected CollectionPropertyValueModelAdapter(CollectionValueModel<? extends E> collectionModel) {
        if (collectionModel == null) {
            throw new NullPointerException();
        }
        this.collectionModel = collectionModel;
        this.collectionListener = this.buildCollectionListener();
    }

    protected CollectionChangeListener buildCollectionListener() {
        return new CollectionListener();
    }

    @Override
    protected void engageModel_() {
        this.collectionModel.addCollectionChangeListener("values", this.collectionListener);
    }

    @Override
    protected void disengageModel_() {
        this.collectionModel.removeCollectionChangeListener("values", this.collectionListener);
    }

    protected void itemsAdded(CollectionAddEvent event) {
        Iterable<?> items = event.getItems();
        this.itemsAdded(items);
    }

    protected void itemsAdded(Iterable<E> items) {
        this.propertyChanged();
    }

    protected void itemsRemoved(CollectionRemoveEvent event) {
        Iterable<?> items = event.getItems();
        this.itemsRemoved(items);
    }

    protected void itemsRemoved(Iterable<E> items) {
        this.propertyChanged();
    }

    protected void collectionCleared(CollectionClearEvent event) {
        this.propertyChanged();
    }

    protected void collectionChanged(CollectionChangeEvent event) {
        this.propertyChanged();
    }

    protected class CollectionListener
    extends CollectionChangeAdapter {
        protected CollectionListener() {
        }

        @Override
        public void itemsAdded(CollectionAddEvent event) {
            CollectionPropertyValueModelAdapter.this.itemsAdded(event);
        }

        @Override
        public void itemsRemoved(CollectionRemoveEvent event) {
            CollectionPropertyValueModelAdapter.this.itemsRemoved(event);
        }

        @Override
        public void collectionCleared(CollectionClearEvent event) {
            CollectionPropertyValueModelAdapter.this.collectionCleared(event);
        }

        @Override
        public void collectionChanged(CollectionChangeEvent event) {
            CollectionPropertyValueModelAdapter.this.collectionChanged(event);
        }
    }
}

