/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.properties.section;

import java.util.Iterator;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.dtd.core.internal.Comment;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.ui.internal.properties.section.AbstractSection;

public class DocumentSection
extends AbstractSection {
    private Text commentText;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.commentText = this.getWidgetFactory().createText(composite, "", 2);
        this.commentText.addListener(24, (Listener)this);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        this.commentText.setLayoutData((Object)data);
    }

    public void refresh() {
        Comment comment;
        this.setListenerEnabled(false);
        this.commentText.setEnabled(true);
        Object input = this.getInput();
        this.commentText.setText("");
        if (input != null && input instanceof DTDNode && (comment = this.getCommentNode((DTDNode)input)) != null) {
            this.commentText.setText(comment.getText());
        }
        this.setListenerEnabled(true);
    }

    public void doHandleEvent(Event event) {
        Object input = this.getInput();
        if (input != null) {
            String newValue = this.commentText.getText();
            if (input instanceof DTDNode) {
                Comment comment = this.getCommentNode((DTDNode)input);
                if (comment != null) {
                    comment.setText(newValue);
                } else {
                    ((DTDNode)input).getDTDFile().createComment((DTDNode)input, newValue, false);
                }
            }
        }
    }

    private Comment getCommentNode(DTDNode node) {
        Iterator iterator = node.getDTDFile().getNodes().iterator();
        DTDNode currentNode = null;
        DTDNode prevNode = null;
        while (iterator.hasNext()) {
            currentNode = (DTDNode)iterator.next();
            if (node == currentNode && prevNode != null && prevNode instanceof Comment) {
                return (Comment)prevNode;
            }
            prevNode = currentNode;
        }
        return null;
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }
}

