/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.wizard;

import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.jsf.common.ui.internal.guiutils.SWTUtils;
import org.eclipse.jst.jsf.facesconfig.ui.wizard.ISummaryDataSource;
import org.eclipse.jst.jsf.facesconfig.ui.wizard.WizardMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SummaryPage
extends WizardPage {
    private static final String WIZARD_SUMMARY_PAGE = "WizardSummaryPage";
    private ISummaryDataSource source;
    private Table table;

    public SummaryPage() {
        super(WIZARD_SUMMARY_PAGE);
        this.setTitle(WizardMessages.WizardSummaryPage_Title_WizardSummary);
        this.setDescription(WizardMessages.WizardSummaryPage_Summary_SummaryDesc);
    }

    public SummaryPage(ISummaryDataSource source) {
        this();
        this.source = source;
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void createControl(Composite parent) {
        Composite composite = SWTUtils.createComposite((Composite)parent, (int)1);
        this.table = new Table(composite, 2048);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(163));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(350));
        TableColumn keyCol = new TableColumn(this.table, 0);
        keyCol.setText(WizardMessages.WizardSummaryPage_Label_Field);
        TableColumn valueCol = new TableColumn(this.table, 0);
        valueCol.setText(WizardMessages.WizardSummaryPage_Label_Value);
        this.setControl((Control)composite);
        this.setPageComplete(true);
    }

    public void loadSummaryData() {
        if (this.source == null) {
            return;
        }
        Object[] data = this.source.getSummaryData().toArray();
        this.table.removeAll();
        int i = 0;
        while (i < data.length) {
            TableItem item = new TableItem(this.table, 0);
            item.setText((String[])data[i]);
            ++i;
        }
    }

    public void setSummaryDataSource(ISummaryDataSource s) {
        this.source = s;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.loadSummaryData();
        }
    }
}

