/*******************************************************************************
 * Copyright (c) 2004, 2006 Sybase, Inc. and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Sybase, Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.jsf.facesconfig.ui.preference;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

/**
 * 
 * Provides the base implementation for all the port figures.
 * 
 */

/*package*/ class PortFigure extends Figure
{
	private boolean showBox = false;

	private boolean showArrow = true;

	// orientation is one of the four positions constants

	// NORTH, SOUTH, EAST or WEST and indicates on which side

	// of the parent figure the connection anchor figure is

	// located.

	private int orientation = PositionConstants.WEST;

	// type is the port type; either input or output

	private int type = FigureConstants.INPUT_PORT;

	/**
	 * 
	 * Construct a port figure.
	 * @param type
	 * 
	 */

	public PortFigure(int type)

	{

		super();

		this.type = type;

		setOpaque(false);

	}

	/**
	 * 
	 * @param b
	 * 
	 */

	public void setBoxVisible(boolean b)

	{

		showBox = b;

		repaint();

	}

	/**
	 * @param b
	 */
	public void setArrowVisible(boolean b)

	{

		showArrow = b;

		repaint();

	}

	/**
	 * 
	 * @return Returns the type.
	 * 
	 */

	public int getType()

	{

		return type;

	}

	/**
	 * 
	 * @param type
	 *            The type to set.
	 * 
	 */

	public void setType(int type)

	{

		this.type = type;

	}

	/**
	 * @param o
	 */
	public void setOrientation(int o)

	{

		orientation = o;

	}

	/**
	 * @return the orientation; one of PositionConstants.*
	 */
	public int getOrientation()

	{

		return orientation;

	}

	/**
	 * @param text
	 */
	public void setToolTipText(String text)

	{

		setToolTip(new Label(text));

	}

	/**
	 * @return the tool tip text
	 */
	public String getToolTipText()

	{

		IFigure fig = getToolTip();

		if (fig instanceof Label)

			return ((Label) fig).getText();

		return null;

	}

	/*
	 * 
	 * (non-Javadoc)
	 * 
	 * 
	 * 
	 * @see org.eclipse.draw2d.IFigure#paint(org.eclipse.draw2d.Graphics)
	 * 
	 */

	public void paintFigure(Graphics g)

	{

		super.paintFigure(g);

		Rectangle bounds_ = getBounds();

		g.setForegroundColor(getForegroundColor());

		if (showBox)

		{

			// draw outer rectangle

			g.setBackgroundColor(getBackgroundColor());

			g.fillRectangle(getBounds().getCropped(new Insets(0, 1, 1, 0)));

			Rectangle r = getBounds().getExpanded(-1, -1).getTranslated(0, -1);

			r.height += 1;

			g.drawRectangle(r);

		}

		if (showArrow)

		{

			// draw arrowhead

			g.setBackgroundColor(getForegroundColor());

			PointList pts = new PointList();

			if (type == FigureConstants.INPUT_PORT)

			{

				switch (orientation)

				{

				case PositionConstants.NORTH:

					pts.addPoint(bounds_.getTopLeft());

					pts.addPoint(bounds_.getTopRight());

					pts.addPoint(bounds_.getBottom());

					pts.addPoint(bounds_.getTopLeft());

					break;

				case PositionConstants.SOUTH:

					pts.addPoint(bounds_.getBottomLeft());

					pts.addPoint(bounds_.getTop());

					pts.addPoint(bounds_.getBottomRight());

					pts.addPoint(bounds_.getBottomLeft());

					break;

				case PositionConstants.EAST:

					pts.addPoint(bounds_.getTopRight());

					pts.addPoint(bounds_.getBottomRight());

					pts.addPoint(bounds_.getLeft());

					pts.addPoint(bounds_.getTopRight());

					break;

				case PositionConstants.WEST:

					pts.addPoint(bounds_.getTopLeft());

					pts.addPoint(bounds_.getRight());

					pts.addPoint(bounds_.getBottomLeft());

					pts.addPoint(bounds_.getTopLeft());

					break;

				}

			}

			else

			{

				switch (orientation)

				{

				case PositionConstants.NORTH:

					pts.addPoint(bounds_.getBottomLeft());

					pts.addPoint(bounds_.getTop());

					pts.addPoint(bounds_.getBottomRight());

					pts.addPoint(bounds_.getBottomLeft());

					break;

				case PositionConstants.SOUTH:

					pts.addPoint(bounds_.getTopLeft());

					pts.addPoint(bounds_.getTopRight());

					pts.addPoint(bounds_.getBottom());

					pts.addPoint(bounds_.getTopLeft());

					break;

				case PositionConstants.EAST:

					pts.addPoint(bounds_.getTopLeft());

					pts.addPoint(bounds_.getRight());

					pts.addPoint(bounds_.getBottomLeft());

					pts.addPoint(bounds_.getTopLeft());

					break;

				case PositionConstants.WEST:

					pts.addPoint(bounds_.getTopRight());

					pts.addPoint(bounds_.getBottomRight());

					pts.addPoint(bounds_.getLeft());

					pts.addPoint(bounds_.getTopRight());

					break;

				}

			}

			g.fillPolygon(pts);

			g.drawPolyline(pts);

		}

	}

	/*
	 * 
	 * (non-Javadoc)
	 * 
	 * 
	 * 
	 * @see org.eclipse.draw2d.IFigure#getPreferredSize(int, int)
	 * 
	 */

	public Dimension getPreferredSize(int wHint, int hHint)

	{

		Dimension d = new Dimension(FigureConstants.PORT_SIDE,
				FigureConstants.PORT_SIDE);

		// CR389070: Figures are abbreviating rule figures names and making them
		// unreadable

		// anchor size is now determined by the size of the owning figure icon

		if (getParent() instanceof BaseNodeFigure)

		{

			IBaseFigure fig = ((BaseNodeFigure) getParent()).getBaseFigure();

			if (fig != null && fig.getIcon() != null)

			{

				org.eclipse.swt.graphics.Rectangle r = fig.getIcon()
						.getBounds();

				if (r.width < 40)

					d.width /= 2;

				if (r.height < 40)

					d.height /= 2;

			}

		}

		return d;

	}

}
