/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.webservice.componentcore.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.internal.webservice.plugin.WebServicePlugin;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.JavaWSDLMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.JaxrpcmapFactory;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.JaxrpcmapResource;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.JaxrpcmapResourceFactory;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.internal.impl.WTPResourceFactoryRegistry;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.internal.emf.resource.RendererFactory;

public class JaxRPCMapArtifactEdit
extends EnterpriseArtifactEdit {
    public static final Class ADAPTER_TYPE = JaxRPCMapArtifactEdit.class;

    public JaxRPCMapArtifactEdit(IProject aProject, boolean toAccessAsReadOnly) throws IllegalArgumentException {
        super(aProject, toAccessAsReadOnly);
    }

    public JaxRPCMapArtifactEdit(ArtifactEditModel model) {
        super(model);
    }

    protected JaxRPCMapArtifactEdit(ModuleCoreNature aNature, IVirtualComponent aModule, boolean toAccessAsReadOnly) {
        super(aNature, aModule, toAccessAsReadOnly);
    }

    public JaxrpcmapResource getJaxRPCMapXmiResource(String mappingFilePathURI) {
        URI uri = URI.createPlatformResourceURI((String)mappingFilePathURI);
        ResourceSet resSet = this.getArtifactEditModel().getResourceSet();
        WTPResourceFactoryRegistry registry = (WTPResourceFactoryRegistry)resSet.getResourceFactoryRegistry();
        registry.registerLastFileSegment(uri.lastSegment(), (Resource.Factory)new JaxrpcmapResourceFactory(RendererFactory.getDefaultRendererFactory()));
        JaxrpcmapResource jaxrpcmapRes = (JaxrpcmapResource)resSet.getResource(uri, true);
        return jaxrpcmapRes;
    }

    public int getJ2EEVersion(String mappingFilePathURI) {
        return this.getJaxRPCMapXmiResource(mappingFilePathURI).getJ2EEVersionID();
    }

    public Resource getDeploymentDescriptorResource(String mappingFilePathURI) {
        return this.getJaxRPCMapXmiResource(mappingFilePathURI);
    }

    public JavaWSDLMapping getJavaWSDLMapping() {
        return (JavaWSDLMapping)this.getDeploymentDescriptorRoot();
    }

    public EObject getDeploymentDescriptorRoot(String mappingFilePathURI) {
        EList contents = this.getDeploymentDescriptorResource(mappingFilePathURI).getContents();
        if (contents.size() > 0) {
            return (EObject)contents.get(0);
        }
        this.addJavaWSDLMappingIfNecessary(this.getJaxRPCMapXmiResource(mappingFilePathURI));
        return (EObject)contents.get(0);
    }

    protected void addJavaWSDLMappingIfNecessary(JaxrpcmapResource aResource) {
        if (aResource != null) {
            if (aResource.getContents() == null || aResource.getContents().isEmpty()) {
                JavaWSDLMapping map = JaxrpcmapFactory.eINSTANCE.createJavaWSDLMapping();
                aResource.getContents().add((Object)map);
            }
            aResource.getContents().get(0);
            this.getArtifactEditModel().getModuleURI();
            try {
                aResource.saveIfNecessary();
            }
            catch (Exception e) {
                WebServicePlugin.logError(e);
            }
        }
    }

    public static JaxRPCMapArtifactEdit getJaxRPCMapArtifactEditForRead(IProject aProject) {
        JaxRPCMapArtifactEdit artifactEdit = null;
        try {
            artifactEdit = new JaxRPCMapArtifactEdit(aProject, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            artifactEdit = null;
        }
        return artifactEdit;
    }

    public static JaxRPCMapArtifactEdit getJaxRPCMapArtifactEditForWrite(IProject aProject) {
        JaxRPCMapArtifactEdit artifactEdit = null;
        try {
            artifactEdit = new JaxRPCMapArtifactEdit(aProject, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            artifactEdit = null;
        }
        return artifactEdit;
    }

    public static JaxRPCMapArtifactEdit getJaxRPCMapArtifactEditForRead(IVirtualComponent aModule) {
        IProject project = aModule.getProject();
        ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature((IProject)project);
        return new JaxRPCMapArtifactEdit(nature, aModule, true);
    }

    public static JaxRPCMapArtifactEdit getJaxRPCMapArtifactEditForWrite(IVirtualComponent aModule) {
        IProject project = aModule.getProject();
        ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature((IProject)project);
        return new JaxRPCMapArtifactEdit(nature, aModule, false);
    }

    public static boolean isValidEJBModule(IVirtualComponent aComponent) {
        return JavaEEProjectUtilities.isEJBProject((IProject)aComponent.getProject());
    }

    public static boolean isValidWebModule(IVirtualComponent aComponent) {
        return JavaEEProjectUtilities.isDynamicWebProject((IProject)aComponent.getProject());
    }

    public static boolean isValidAppClientModule(IVirtualComponent aComponent) {
        return JavaEEProjectUtilities.isApplicationClientProject((IProject)aComponent.getProject());
    }

    public EObject createModelRoot(String mappingFilePathURI) {
        return this.createModelRoot(this.getJ2EEVersion(), mappingFilePathURI);
    }

    public EObject createModelRoot(int version, String mappingFilePathURI) {
        JaxrpcmapResource res = this.getJaxRPCMapXmiResource(mappingFilePathURI);
        res.setModuleVersionID(version);
        this.addJavaWSDLMappingIfNecessary(res);
        return this.getJavaWSDLMapping();
    }

    public EObject createModelRoot() {
        throw new IllegalArgumentException(WebServicePlugin.getMessage("_UI_JaxRPCMissingModel"));
    }

    public EObject createModelRoot(int version) {
        throw new IllegalArgumentException(WebServicePlugin.getMessage("_UI_JaxRPCMissingModel"));
    }

    public Resource getDeploymentDescriptorResource() {
        throw new IllegalArgumentException(WebServicePlugin.getMessage("_UI_JaxRPCMissingModel"));
    }

    public int getJ2EEVersion() {
        throw new IllegalArgumentException(WebServicePlugin.getMessage("_UI_JaxRPCMissingModel"));
    }

    protected boolean validProjectVersion(IProject project) {
        return true;
    }
}

