/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterator;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public class ReadOnlyCompositeListIterator<E>
implements ListIterator<E> {
    private final ListIterator<? extends ListIterator<? extends E>> iterators;
    private ListIterator<? extends E> nextIterator;
    private int nextIndex;

    public ReadOnlyCompositeListIterator(ListIterator<? extends ListIterator<? extends E>> iterators) {
        if (iterators == null) {
            throw new NullPointerException();
        }
        this.iterators = iterators;
        this.nextIndex = 0;
    }

    @Override
    public boolean hasNext() {
        try {
            this.loadNextIterator();
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        return this.nextIterator.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        try {
            this.loadPreviousIterator();
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        return this.nextIterator.hasPrevious();
    }

    @Override
    public E next() {
        this.loadNextIterator();
        E result = this.nextIterator.next();
        ++this.nextIndex;
        return result;
    }

    @Override
    public int nextIndex() {
        return this.nextIndex;
    }

    @Override
    public E previous() {
        this.loadPreviousIterator();
        E result = this.nextIterator.previous();
        --this.nextIndex;
        return result;
    }

    @Override
    public int previousIndex() {
        return this.nextIndex - 1;
    }

    @Override
    public void add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(E e) {
        throw new UnsupportedOperationException();
    }

    private void loadNextIterator() {
        this.checkNextIterator();
        while (!this.nextIterator.hasNext() && this.iterators.hasNext()) {
            this.nextIterator = this.iterators.next();
        }
    }

    private void loadPreviousIterator() {
        this.checkNextIterator();
        while (!this.nextIterator.hasPrevious() && this.iterators.hasPrevious()) {
            this.nextIterator = this.iterators.previous();
        }
    }

    private void checkNextIterator() {
        if (this.nextIterator == null) {
            this.nextIterator = this.iterators.next();
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.iterators);
    }
}

