/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.core.internal.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;
import org.eclipse.wst.xsl.core.internal.validation.XSLValidationMessage;
import org.eclipse.wst.xsl.core.model.XSLNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLValidationReport
implements ValidationReport {
    private boolean valid = true;
    private String uri;
    private List<XSLValidationMessage> errors = new ArrayList<XSLValidationMessage>();
    private List<XSLValidationMessage> warnings = new ArrayList<XSLValidationMessage>();
    private List<XSLValidationMessage> infos = new ArrayList<XSLValidationMessage>();

    public XSLValidationReport(String uri) {
        this.uri = uri;
    }

    public List<XSLValidationMessage> getErrors() {
        return this.errors;
    }

    public List<XSLValidationMessage> getWarnings() {
        return this.warnings;
    }

    public List<XSLValidationMessage> getInfos() {
        return this.infos;
    }

    public ValidationMessage addError(XSLNode node, String message) {
        this.valid = false;
        XSLValidationMessage msg = new XSLValidationMessage(message, node.getLineNumber() + 1, node.getColumnNumber() + 1, this.getFileURI());
        msg.setSeverity(1);
        msg.setNode(node);
        this.errors.add(msg);
        return msg;
    }

    public ValidationMessage addWarning(XSLNode node, String message) {
        XSLValidationMessage msg = new XSLValidationMessage(message, node.getLineNumber() + 1, node.getColumnNumber() + 1, this.getFileURI());
        msg.setSeverity(2);
        msg.setNode(node);
        this.warnings.add(msg);
        return msg;
    }

    public ValidationMessage addInfo(XSLNode node, String message) {
        XSLValidationMessage msg = new XSLValidationMessage(message, node.getLineNumber() + 1, node.getColumnNumber() + 1, this.getFileURI());
        msg.setSeverity(4);
        msg.setNode(node);
        this.infos.add(msg);
        return msg;
    }

    public String getFileURI() {
        return this.uri;
    }

    public HashMap<?, ?> getNestedMessages() {
        return null;
    }

    public ValidationMessage[] getValidationMessages() {
        ArrayList<XSLValidationMessage> messages = new ArrayList<XSLValidationMessage>();
        messages.addAll(this.errors);
        messages.addAll(this.warnings);
        messages.addAll(this.infos);
        return messages.toArray(new ValidationMessage[0]);
    }

    public boolean isValid() {
        return this.valid;
    }
}

