/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.typesystem.ItemType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.SimpleAtomicItemTypeImpl;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.SingleItemSequence;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultBuffer {
    private ArrayList<Item> values = new ArrayList();
    public static final ResultSequence EMPTY = new ResultSequence(){

        public int size() {
            return 0;
        }

        public Item item(int index) {
            throw new IndexOutOfBoundsException("Sequence is empty!");
        }

        public boolean empty() {
            return true;
        }

        public ItemType itemType(int index) {
            throw new IndexOutOfBoundsException("Sequence is empty!");
        }

        public ItemType sequenceType() {
            return new SimpleAtomicItemTypeImpl(BuiltinTypeLibrary.XS_ANYTYPE, 3);
        }

        public Object value(int index) {
            throw new IndexOutOfBoundsException("Sequence is empty!");
        }

        public Object firstValue() {
            throw new IndexOutOfBoundsException("Sequence is empty!");
        }

        public Item first() {
            throw new IndexOutOfBoundsException("Sequence is empty!");
        }

        public Iterator iterator() {
            return new Iterator(){

                public void remove() {
                    throw new UnsupportedOperationException("ResultSequences are immutable");
                }

                public Object next() {
                    throw new IllegalStateException("This ResultSequence is empty");
                }

                public boolean hasNext() {
                    return false;
                }
            };
        }
    };

    public ResultSequence getSequence() {
        if (this.values.size() == 0) {
            return EMPTY;
        }
        if (this.values.size() == 1) {
            return ResultBuffer.wrap(this.values.get(0));
        }
        return new ArrayResultSequence(this.values.toArray(new Item[this.values.size()]));
    }

    public void clear() {
        this.values.clear();
    }

    public ResultBuffer add(Item at) {
        this.values.add(at);
        return this;
    }

    public ResultBuffer append(Item at) {
        this.values.add(at);
        return this;
    }

    public ResultBuffer concat(ResultSequence rs) {
        this.values.addAll(this.collectionWrapper(rs));
        return this;
    }

    public int size() {
        return this.values.size();
    }

    public ListIterator iterator() {
        return this.values.listIterator();
    }

    public void prepend(ResultSequence rs) {
        this.values.addAll(0, this.collectionWrapper(rs));
    }

    private Collection<Item> collectionWrapper(final ResultSequence rs) {
        return new Collection<Item>(){

            @Override
            public boolean add(Item arg0) {
                return false;
            }

            @Override
            public boolean addAll(Collection arg0) {
                return false;
            }

            @Override
            public void clear() {
            }

            @Override
            public boolean contains(Object arg0) {
                return false;
            }

            @Override
            public boolean containsAll(Collection arg0) {
                return false;
            }

            @Override
            public boolean isEmpty() {
                return rs.empty();
            }

            @Override
            public Iterator iterator() {
                return rs.iterator();
            }

            @Override
            public boolean remove(Object arg0) {
                return false;
            }

            @Override
            public boolean removeAll(Collection arg0) {
                return false;
            }

            @Override
            public boolean retainAll(Collection arg0) {
                return false;
            }

            @Override
            public int size() {
                return rs.size();
            }

            @Override
            public Object[] toArray() {
                return this.toArray(new Item[this.size()]);
            }

            @Override
            public Object[] toArray(Object[] arg0) {
                if (arg0.length < this.size()) {
                    arg0 = new Item[this.size()];
                }
                int i = 0;
                while (i < this.size()) {
                    arg0[i] = rs.item(i);
                    ++i;
                }
                return arg0;
            }
        };
    }

    public Collection<Item> getCollection() {
        return this.values;
    }

    public ResultBuffer concat(Collection others) {
        this.values.addAll(others);
        return this;
    }

    public static ResultSequence wrap(Item item) {
        if (item instanceof SingleItemSequence) {
            return (SingleItemSequence)item;
        }
        return new SingleResultSequence(item);
    }

    public Item item(int index) {
        return this.values.get(index);
    }

    public void addAt(int pos, Item element) {
        this.values.add(pos, element);
    }

    public static final class ArrayResultSequence
    implements ResultSequence {
        private final Item[] results;

        public ArrayResultSequence(Item[] results) {
            this.results = results;
        }

        public int size() {
            return this.results.length;
        }

        public Item item(int index) {
            if (index < 0 && index >= this.results.length) {
                throw new IndexOutOfBoundsException("Index " + index + " is out of alllowed bounds (less that " + this.results.length);
            }
            return this.results[index];
        }

        public boolean empty() {
            return false;
        }

        public Object firstValue() {
            return this.item(0).getNativeValue();
        }

        public Item first() {
            return this.item(0);
        }

        public Iterator iterator() {
            return new Iterator(){
                int nextIndex = 0;

                public final void remove() {
                    throw new UnsupportedOperationException("ResultSequences are immutable");
                }

                public final Object next() {
                    if (this.nextIndex < ArrayResultSequence.this.results.length) {
                        return ArrayResultSequence.this.results[this.nextIndex++];
                    }
                    throw new IllegalStateException("This iterator is at its end");
                }

                public final boolean hasNext() {
                    return this.nextIndex < ArrayResultSequence.this.results.length;
                }
            };
        }

        public ItemType itemType(int index) {
            if (index < 0 && index >= this.results.length) {
                throw new IndexOutOfBoundsException("Index " + index + " is out of alllowed bounds (less that " + this.results.length);
            }
            return this.results[index].getItemType();
        }

        public ItemType sequenceType() {
            return new SimpleAtomicItemTypeImpl(BuiltinTypeLibrary.XS_ANYTYPE, 3);
        }

        public Object value(int index) {
            return this.item(index).getNativeValue();
        }
    }

    public static final class SingleResultSequence
    implements ResultSequence {
        private final Item value;

        public SingleResultSequence(Item at) {
            this.value = at;
        }

        public int size() {
            return 1;
        }

        public Item item(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Length is one, you looked up number " + index);
            }
            return this.value;
        }

        public Item first() {
            return this.item(0);
        }

        public Object value(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Length is one, you looked up number " + index);
            }
            return this.value.getNativeValue();
        }

        public boolean empty() {
            return false;
        }

        public Object firstValue() {
            return this.value.getNativeValue();
        }

        public Iterator iterator() {
            return new Iterator(){
                boolean seenIt = false;

                public final void remove() {
                    throw new UnsupportedOperationException("ResultSequences are immutable");
                }

                public final Object next() {
                    if (!this.seenIt) {
                        this.seenIt = true;
                        return SingleResultSequence.this.value;
                    }
                    throw new IllegalStateException("This iterator is at its end");
                }

                public final boolean hasNext() {
                    return !this.seenIt;
                }
            };
        }

        public ItemType itemType(int index) {
            return this.item(index).getItemType();
        }

        public ItemType sequenceType() {
            return this.value.getItemType();
        }
    }
}

