/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native.value;

import org.eclipse.wst.jsdt.chromium.JsDeclarativeVariable;
import org.eclipse.wst.jsdt.chromium.JsEvaluateContext;
import org.eclipse.wst.jsdt.chromium.JsFunction;
import org.eclipse.wst.jsdt.chromium.JsObjectProperty;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.JsVariable;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.v8native.InternalContext;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8CommandCallbackBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8CommandProcessor;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.FailedCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.SetVariableValueBody;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.SuccessCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.ValueHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.ScopeMessage;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.SetVariableValueMessage;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.JsArrayImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.JsFunctionImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.JsObjectBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.JsValueBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueLoader;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueLoaderImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueMirror;
import org.eclipse.wst.jsdt.chromium.util.GenericCallback;

public abstract class JsVariableBase
implements JsVariable {
    private volatile JsValueBase value;
    private final Object rawName;

    public JsVariableBase(ValueLoader valueLoader, ValueMirror valueData, Object rawName) {
        this.rawName = rawName;
        this.value = JsVariableBase.createValue(valueLoader, valueData);
    }

    public static JsValueBase createValue(ValueLoader valueLoader, ValueMirror valueData) {
        JsValue.Type type = valueData.getType();
        switch (type) {
            case TYPE_FUNCTION: {
                return new JsFunctionImpl(valueLoader, valueData);
            }
            case TYPE_OBJECT: 
            case TYPE_ERROR: 
            case TYPE_REGEXP: 
            case TYPE_DATE: {
                return new JsObjectBase.Impl(valueLoader, valueData);
            }
            case TYPE_ARRAY: {
                return new JsArrayImpl(valueLoader, valueData);
            }
        }
        return new JsValueBase.Impl(valueData);
    }

    @Override
    public JsValueBase getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.rawName.toString();
    }

    Object getRawNameAsObject() {
        return this.rawName;
    }

    private static JsValueBase castValueArgument(JsValue value) {
        try {
            return (JsValueBase)value;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Incorrect value argument", e);
        }
    }

    public String toString() {
        return "[JsVariable: name=" + this.getName() + ",value=" + this.getValue() + ']';
    }

    public static class Declarative
    extends JsVariableBase
    implements JsDeclarativeVariable {
        private final VariableChanger changer;

        public Declarative(ValueLoader valueLoader, ValueMirror valueData, Object rawName, VariableChanger changer) {
            super(valueLoader, valueData, rawName);
            this.changer = changer;
        }

        @Override
        public JsObjectProperty asObjectProperty() {
            return null;
        }

        @Override
        public JsDeclarativeVariable asDeclarativeVariable() {
            return this;
        }

        @Override
        public boolean isMutable() {
            return this.changer != null;
        }

        @Override
        public RelayOk setValue(JsValue newValue, final JsDeclarativeVariable.SetValueCallback userCallback, SyncCallback syncCallback) throws UnsupportedOperationException {
            JsValueBase jsValueBase = JsVariableBase.castValueArgument(newValue);
            String variableName = this.getName();
            GenericCallback<JsValueBase> hostCallback = new GenericCallback<JsValueBase>(){

                @Override
                public void success(JsValueBase newValue) {
                    Declarative baseThis = Declarative.this;
                    ((JsVariableBase)baseThis).value = newValue;
                    if (userCallback != null) {
                        userCallback.success();
                    }
                }

                @Override
                public void failure(Exception cause) {
                    if (userCallback != null) {
                        userCallback.failure(cause);
                    }
                }
            };
            return this.changer.setValue(variableName, jsValueBase, hostCallback, syncCallback);
        }
    }

    public static class Impl
    extends JsVariableBase {
        public Impl(ValueLoader valueLoader, ValueMirror valueData, Object rawName) {
            super(valueLoader, valueData, rawName);
        }

        @Override
        public JsObjectProperty asObjectProperty() {
            return null;
        }

        @Override
        public JsDeclarativeVariable asDeclarativeVariable() {
            return null;
        }
    }

    static class Property
    extends JsVariableBase
    implements JsObjectProperty {
        public Property(ValueLoader valueLoader, ValueMirror valueData, Object rawName) {
            super(valueLoader, valueData, rawName);
        }

        @Override
        public JsObjectProperty asObjectProperty() {
            return this;
        }

        @Override
        public JsDeclarativeVariable asDeclarativeVariable() {
            return null;
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public JsValue getGetter() {
            return null;
        }

        @Override
        public JsFunction getGetterAsFunction() {
            return null;
        }

        @Override
        public JsValue getSetter() {
            return null;
        }

        @Override
        public boolean isConfigurable() {
            return true;
        }

        @Override
        public boolean isEnumerable() {
            return true;
        }

        @Override
        public RelayOk evaluateGet(JsEvaluateContext.EvaluateCallback callback, SyncCallback syncCallback) {
            throw new RuntimeException();
        }
    }

    public static class VariableChanger {
        private final InternalContext internalContext;
        private final ScopeMessage.Ref scopeRef;

        VariableChanger(InternalContext internalContext, ScopeMessage.Ref scopeRef) {
            this.internalContext = internalContext;
            this.scopeRef = scopeRef;
        }

        RelayOk setValue(String variableName, JsValueBase jsValueBase, final GenericCallback<JsValueBase> callback, SyncCallback syncCallback) {
            SetVariableValueMessage message = new SetVariableValueMessage(this.scopeRef, variableName, jsValueBase.getJsonParam(this.internalContext));
            V8CommandCallbackBase innerCallback = new V8CommandCallbackBase(){

                @Override
                public void success(SuccessCommandResponse successResponse) {
                    SetVariableValueBody body;
                    try {
                        body = successResponse.body().asSetVariableValueBody();
                    }
                    catch (JsonProtocolParseException e) {
                        throw new RuntimeException(e);
                    }
                    ValueHandle newValueHandle = body.newValue();
                    ValueLoaderImpl valueLoader = VariableChanger.this.internalContext.getValueLoader();
                    ValueMirror mirror = valueLoader.addDataToMap(newValueHandle);
                    JsValueBase value = JsVariableBase.createValue(valueLoader, mirror);
                    callback.success(value);
                }

                @Override
                public void failure(String message, FailedCommandResponse.ErrorDetails errorDetails) {
                    callback.failure(new Exception(message));
                }
            };
            try {
                return this.internalContext.sendV8CommandAsync(message, true, (V8CommandProcessor.V8HandlerCallback)innerCallback, syncCallback);
            }
            catch (InternalContext.ContextDismissedCheckedException e) {
                return this.internalContext.getDebugSession().maybeRethrowContextException(e, syncCallback);
            }
        }
    }
}

