/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.propertypages;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.model.DebugTargetImpl;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResource;
import org.eclipse.wst.jsdt.chromium.debug.core.util.AccuratenessProperty;
import org.eclipse.wst.jsdt.chromium.debug.core.util.ScriptTargetMapping;
import org.eclipse.wst.jsdt.chromium.debug.ui.ChromiumJavascriptDecorator;
import org.eclipse.wst.jsdt.chromium.debug.ui.propertypages.AccuratenessControl;
import org.eclipse.wst.jsdt.chromium.debug.ui.propertypages.Messages;

public class ScriptFilePage
extends PropertyPage {
    private Runnable storeValueCallback = null;

    protected Control createContents(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 1;
        main.setLayout((Layout)topLayout);
        main.setLayoutData((Object)new GridData(1808));
        IAdaptable adaptable = this.getElement();
        IFile file = (IFile)adaptable.getAdapter(IFile.class);
        List mappingList = ChromiumDebugPlugin.getScriptTargetMapping((IFile)file);
        Composite mappingControl = mappingList.size() == 1 && this.isVProjectFile(file, (ScriptTargetMapping)mappingList.get(0)) ? this.buildVProjectFileUi((ScriptTargetMapping)mappingList.get(0), main) : this.buildWorkspaceFileUi(mappingList, main, file);
        mappingControl.setLayoutData((Object)new GridData(768));
        return main;
    }

    private boolean isVProjectFile(IFile file, ScriptTargetMapping mapping) {
        boolean hasNature;
        IProject project = file.getProject();
        if (project == null) {
            return false;
        }
        try {
            hasNature = project.hasNature("org.eclipse.wst.jsdt.chromium.debug.core.jsnature");
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        return hasNature;
    }

    private Composite buildWorkspaceFileUi(final List<? extends ScriptTargetMapping> mappingList, Composite parent, final IFile file) {
        int oldAccuratenessValue;
        Composite main = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 1;
        main.setLayout((Layout)topLayout);
        new Label(main, 0).setText(Messages.ScriptFilePage_CURRENTLY_LINKED_TO_LABEL);
        String[] launchLabels = new String[mappingList.size()];
        int i = 0;
        while (i < launchLabels.length) {
            DebugTargetImpl debugTarget = mappingList.get(i).getConnectedTargetData().getDebugTarget();
            launchLabels[i] = debugTarget.getLaunch().getLaunchConfiguration().getName();
            ++i;
        }
        final Combo typesCombo = new Combo(main, 8);
        typesCombo.setLayoutData((Object)new GridData(768));
        typesCombo.setFont(parent.getFont());
        typesCombo.setItems(launchLabels);
        if (launchLabels.length > 0) {
            typesCombo.select(0);
            final ScriptProperties properties = this.buildScriptProperties(main);
            this.fillScriptProperties(properties, mappingList.get(0));
            typesCombo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    int index = typesCombo.getSelectionIndex();
                    ScriptFilePage.this.fillScriptProperties(properties, (ScriptTargetMapping)mappingList.get(index));
                }
            });
        }
        String[] pathSegments = file.getFullPath().segments();
        try {
            oldAccuratenessValue = AccuratenessProperty.read((IFile)file);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        new Label(main, 0);
        Group autoDetectLookupGroup = new Group(main, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        autoDetectLookupGroup.setLayout((Layout)layout);
        autoDetectLookupGroup.setText(Messages.ScriptFilePage_AUTODETECT_PARAMETER);
        autoDetectLookupGroup.setLayoutData((Object)new GridData(768));
        final AccuratenessControl accuratenessControl = new AccuratenessControl((Composite)autoDetectLookupGroup, pathSegments, oldAccuratenessValue);
        this.storeValueCallback = new Runnable(oldAccuratenessValue){
            private int storedValue;
            {
                this.storedValue = n;
            }

            @Override
            public void run() {
                int value = accuratenessControl.getAccuratenessValue();
                if (this.storedValue == value) {
                    return;
                }
                String valueString = AccuratenessProperty.Parser.write((int)value);
                try {
                    file.setPersistentProperty(AccuratenessProperty.KEY, valueString);
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
                this.storedValue = value;
            }
        };
        return main;
    }

    public boolean performOk() {
        if (this.storeValueCallback != null) {
            this.storeValueCallback.run();
        }
        return super.performOk();
    }

    private Composite buildVProjectFileUi(ScriptTargetMapping mapping, Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 1;
        main.setLayout((Layout)topLayout);
        ScriptProperties properties = this.buildScriptProperties(main);
        this.fillScriptProperties(properties, mapping);
        return main;
    }

    private void fillScriptProperties(ScriptProperties properties, ScriptTargetMapping input) {
        String fileName;
        String text;
        Collection vmResources = input.getVmResources();
        if (vmResources.size() == 1) {
            VmResource resource = (VmResource)vmResources.iterator().next();
            text = resource.getId().getVisibleName();
            IFile vprojectFile = resource.getVProjectFile();
            fileName = ChromiumJavascriptDecorator.getDecoratedText(vprojectFile.getName(), vprojectFile);
        } else {
            text = Messages.ScriptFilePage_MULTIPLE_AUTODETECT_MATCH;
            fileName = Messages.ScriptFilePage_MULTIPLE_AUTODETECT_MATCH;
        }
        properties.getLocalFileName().setText(fileName);
        properties.getScriptName().setText(text);
    }

    private ScriptProperties buildScriptProperties(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        composite.setLayout((Layout)topLayout);
        composite.setLayoutData((Object)new GridData(768));
        final Text scriptName = ScriptFilePage.createTextField(composite, Messages.ScriptFilePage_SCRIPT_NAME);
        final Text scriptFile = ScriptFilePage.createTextField(composite, Messages.ScriptFilePage_NAME_IN_VPROJECT);
        return new ScriptProperties(){

            @Override
            public Text getScriptName() {
                return scriptName;
            }

            @Override
            public Text getLocalFileName() {
                return scriptFile;
            }
        };
    }

    static Text createTextField(Composite parent, String title) {
        Label label = new Label(parent, 0);
        label.setText(title);
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        label.setLayoutData((Object)gd);
        Text valueText = new Text(parent, 72);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        valueText.setLayoutData((Object)gd);
        Display display = parent.getDisplay();
        valueText.setBackground(display.getSystemColor(22));
        return valueText;
    }

    private static interface ScriptProperties {
        public Text getScriptName();

        public Text getLocalFileName();
    }
}

