/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.wip;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.wst.jsdt.chromium.Breakpoint;
import org.eclipse.wst.jsdt.chromium.BreakpointTypeExtension;
import org.eclipse.wst.jsdt.chromium.CallbackSemaphore;
import org.eclipse.wst.jsdt.chromium.FunctionScopeExtension;
import org.eclipse.wst.jsdt.chromium.IgnoreCountBreakpointExtension;
import org.eclipse.wst.jsdt.chromium.JavascriptVm;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.RestartFrameExtension;
import org.eclipse.wst.jsdt.chromium.Script;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.TabDebugEventListener;
import org.eclipse.wst.jsdt.chromium.Version;
import org.eclipse.wst.jsdt.chromium.internal.JsonUtil;
import org.eclipse.wst.jsdt.chromium.internal.websocket.WsConnection;
import org.eclipse.wst.jsdt.chromium.internal.wip.PermanentRemoteValueMappingImpl;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipBreakpointImpl;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipBreakpointManager;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipBrowserImpl;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipCommandCallback;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipCommandProcessor;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipContextBuilder;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipEvaluateContextBase;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipFrameManager;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipScriptManager;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipValueBuilder;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.WipCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.WipParams;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.debugger.EnableParams;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.debugger.PauseParams;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.debugger.SetBreakpointsActiveParams;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.debugger.SetPauseOnExceptionsParams;
import org.eclipse.wst.jsdt.chromium.util.GenericCallback;
import org.eclipse.wst.jsdt.chromium.util.MethodIsBlockingException;
import org.eclipse.wst.jsdt.chromium.util.RelaySyncCallback;
import org.eclipse.wst.jsdt.chromium.util.SignalRelay;
import org.eclipse.wst.jsdt.chromium.wip.EvaluateToMappingExtension;
import org.eclipse.wst.jsdt.chromium.wip.PermanentRemoteValueMapping;
import org.eclipse.wst.jsdt.chromium.wip.WipBrowser;
import org.eclipse.wst.jsdt.chromium.wip.WipBrowserTab;
import org.eclipse.wst.jsdt.chromium.wip.WipJavascriptVm;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public class WipTabImpl
implements WipBrowserTab,
WipJavascriptVm {
    private static final Logger LOGGER = Logger.getLogger(WipTabImpl.class.getName());
    private final WsConnection socket;
    private final WipBrowserImpl browserImpl;
    private final TabDebugEventListener tabListener;
    private final WipCommandProcessor commandProcessor;
    private final WipScriptManager scriptManager = new WipScriptManager(this);
    private final WipBreakpointManager breakpointManager = new WipBreakpointManager(this);
    private final WipContextBuilder contextBuilder = new WipContextBuilder(this);
    private final WipFrameManager frameManager = new WipFrameManager(this);
    private final VmState vmState = new VmState();
    private final SignalRelay<Void> closeSignalRelay;
    private volatile String url;

    public WipTabImpl(WsConnection socket, WipBrowserImpl browserImpl, TabDebugEventListener tabListener, String preliminaryUrl) throws IOException {
        this.socket = socket;
        this.browserImpl = browserImpl;
        this.tabListener = tabListener;
        this.url = preliminaryUrl;
        this.closeSignalRelay = SignalRelay.create((SignalRelay.Callback)new SignalRelay.Callback<Void>(){

            public void onSignal(Void signal, Exception cause) {
                WipTabImpl.this.tabListener.closed();
                WipTabImpl.this.tabListener.getDebugEventListener().disconnected();
            }
        });
        try {
            this.closeSignalRelay.bind(socket.getCloser(), null, null);
        }
        catch (SignalRelay.AlreadySignalledException e) {
            throw new IOException("Connection is closed", e);
        }
        this.commandProcessor = new WipCommandProcessor(this, socket);
        WsConnection.Listener socketListener = new WsConnection.Listener(){

            @Override
            public void textMessageRecieved(String text) {
                JSONObject json;
                try {
                    json = JsonUtil.jsonObjectFromJson((String)text);
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
                WipTabImpl.this.commandProcessor.acceptResponse(json);
            }

            @Override
            public void errorMessage(Exception ex) {
                LOGGER.log(Level.SEVERE, "WebSocket protocol error", ex);
            }

            @Override
            public void eofMessage() {
                WipTabImpl.this.commandProcessor.processEos();
            }
        };
        socket.startListening(socketListener);
        this.init();
    }

    private void init() {
        SyncCallback syncCallback = new SyncCallback(){

            public void callbackDone(RuntimeException e) {
                WipTabImpl.this.scriptManager.endPopulateScriptMode();
            }
        };
        this.commandProcessor.send(new EnableParams(), null, syncCallback);
        this.commandProcessor.send(new org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.page.EnableParams(), null, null);
        this.frameManager.readFrames();
    }

    void updateUrl(String url, boolean silent) {
        this.url = url;
        if (silent) {
            return;
        }
        this.scriptManager.pageReloaded();
        this.breakpointManager.clearNonProvisionalBreakpoints();
        this.tabListener.navigated(this.url);
        this.contextBuilder.getEvaluateHack().pageReloaded();
    }

    WipScriptManager getScriptManager() {
        return this.scriptManager;
    }

    WipBreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }

    public boolean detach() {
        this.closeSignalRelay.sendSignal(null, null);
        return true;
    }

    public boolean isAttached() {
        return !this.closeSignalRelay.isSignalled();
    }

    public PermanentRemoteValueMapping createPermanentValueMapping(String id) {
        return new PermanentRemoteValueMappingImpl(this, id);
    }

    public RelayOk enableBreakpoints(Boolean enabled, GenericCallback<Boolean> callback, SyncCallback syncCallback) {
        return this.updateVmVariable(enabled, VmState.BREAKPOINTS_ACTIVE, callback, syncCallback);
    }

    public RelayOk setBreakOnException(JavascriptVm.ExceptionCatchMode catchMode, GenericCallback<JavascriptVm.ExceptionCatchMode> callback, SyncCallback syncCallback) {
        VmState.Variable<JavascriptVm.ExceptionCatchMode> variable = VmState.BREAK_ON_EXCEPTION;
        return this.updateVmVariable(catchMode, variable, callback, syncCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> RelayOk updateVmVariable(T value, VmState.Variable<T> variable, final GenericCallback<T> callback, SyncCallback syncCallback) {
        VmState vmState = this.vmState;
        synchronized (vmState) {
            T newValue;
            if (value == null) {
                newValue = variable.getValue(this.vmState);
            } else {
                variable.setValue(this.vmState, value);
                newValue = value;
            }
            WipParams params = variable.createRequestParams(this.vmState);
            WipCommandCallback.Default wrappedCallback = callback == null ? null : new WipCommandCallback.Default(){

                @Override
                protected void onSuccess(WipCommandResponse.Success success) {
                    callback.success(newValue);
                }

                @Override
                protected void onError(String message) {
                    callback.failure(new Exception(message));
                }
            };
            return this.commandProcessor.send(params, wrappedCallback, syncCallback);
        }
    }

    public Version getVersion() {
        return new Version(Arrays.asList(0, 0), " <Unknown V8 version>");
    }

    public BreakpointTypeExtension getBreakpointTypeExtension() {
        return WipBreakpointImpl.TYPE_EXTENSION;
    }

    public IgnoreCountBreakpointExtension getIgnoreCountBreakpointExtension() {
        return WipBreakpointImpl.getIgnoreCountBreakpointExtensionImpl();
    }

    public EvaluateToMappingExtension getEvaluateWithDestinationMappingExtension() {
        return WipEvaluateContextBase.EVALUATE_TO_MAPPING_EXTENSION;
    }

    public FunctionScopeExtension getFunctionScopeExtension() {
        return WipValueBuilder.FUNCTION_SCOPE_EXTENSION;
    }

    public RestartFrameExtension getRestartFrameExtension() {
        return WipContextBuilder.RESTART_FRAME_EXTENSION;
    }

    public void getScripts(final JavascriptVm.ScriptsCallback callback) throws MethodIsBlockingException {
        CallbackSemaphore callbackSemaphore = new CallbackSemaphore();
        GenericCallback<Collection<Script>> innerCallback = callback == null ? null : new GenericCallback<Collection<Script>>(){

            public void success(Collection<Script> value) {
                callback.success(value);
            }

            public void failure(Exception exception) {
                callback.failure(exception.getMessage());
            }
        };
        RelayOk relayOk = this.scriptManager.getScripts(innerCallback, (SyncCallback)callbackSemaphore);
        callbackSemaphore.acquireDefault(relayOk);
    }

    public RelayOk setBreakpoint(Breakpoint.Target target, int line, int column, boolean enabled, String condition, JavascriptVm.BreakpointCallback callback, SyncCallback syncCallback) {
        return this.breakpointManager.setBreakpoint(target, line, column, enabled, condition, callback, syncCallback);
    }

    public void suspend(final JavascriptVm.SuspendCallback callback) {
        PauseParams params = new PauseParams();
        WipCommandCallback.Default wrappedCallback = callback == null ? null : new WipCommandCallback.Default(){

            @Override
            protected void onSuccess(WipCommandResponse.Success success) {
                callback.success();
            }

            @Override
            protected void onError(String message) {
                callback.failure(new Exception(message));
            }
        };
        this.commandProcessor.send(params, wrappedCallback, null);
    }

    public RelayOk listBreakpoints(JavascriptVm.ListBreakpointsCallback callback, SyncCallback syncCallback) {
        if (callback != null) {
            callback.success(this.breakpointManager.getAllBreakpoints());
        }
        return RelaySyncCallback.finish((SyncCallback)syncCallback);
    }

    public WipBrowser getBrowser() {
        return this.browserImpl;
    }

    public WipJavascriptVm getJavascriptVm() {
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public TabDebugEventListener getDebugListener() {
        return this.tabListener;
    }

    public WsConnection getWsSocket() {
        return this.socket;
    }

    WipContextBuilder getContextBuilder() {
        return this.contextBuilder;
    }

    WipCommandProcessor getCommandProcessor() {
        return this.commandProcessor;
    }

    WipFrameManager getFrameManager() {
        return this.frameManager;
    }

    TabDebugEventListener getTabListener() {
        return this.tabListener;
    }

    private static class VmState {
        private static final boolean DEFAULT_BREAKPOINTS_ACTIVE = true;
        private static final JavascriptVm.ExceptionCatchMode DEFAULT_CATCH_MODE = JavascriptVm.ExceptionCatchMode.NONE;
        boolean breakpointsActive = true;
        JavascriptVm.ExceptionCatchMode breakOnExceptionMode = DEFAULT_CATCH_MODE;
        static final Variable<Boolean> BREAKPOINTS_ACTIVE = new Variable<Boolean>(){

            @Override
            Boolean getValue(VmState vmState) {
                return vmState.breakpointsActive;
            }

            @Override
            void setValue(VmState vmState, Boolean value) {
                vmState.breakpointsActive = value;
            }

            @Override
            WipParams createRequestParams(VmState vmState) {
                return new SetBreakpointsActiveParams(vmState.breakpointsActive);
            }
        };
        static final Variable<JavascriptVm.ExceptionCatchMode> BREAK_ON_EXCEPTION = new Variable<JavascriptVm.ExceptionCatchMode>(){

            @Override
            JavascriptVm.ExceptionCatchMode getValue(VmState vmState) {
                return vmState.breakOnExceptionMode;
            }

            @Override
            void setValue(VmState vmState, JavascriptVm.ExceptionCatchMode value) {
                vmState.breakOnExceptionMode = value;
            }

            @Override
            WipParams createRequestParams(VmState vmState) {
                return vmState.createPauseOnExceptionRequest();
            }
        };
        private static Map<JavascriptVm.ExceptionCatchMode, SetPauseOnExceptionsParams.State> SDK_TO_WIP_CATCH_MODE = new EnumMap<JavascriptVm.ExceptionCatchMode, SetPauseOnExceptionsParams.State>(JavascriptVm.ExceptionCatchMode.class);

        static {
            SDK_TO_WIP_CATCH_MODE.put(JavascriptVm.ExceptionCatchMode.ALL, SetPauseOnExceptionsParams.State.ALL);
            SDK_TO_WIP_CATCH_MODE.put(JavascriptVm.ExceptionCatchMode.UNCAUGHT, SetPauseOnExceptionsParams.State.UNCAUGHT);
            SDK_TO_WIP_CATCH_MODE.put(JavascriptVm.ExceptionCatchMode.NONE, SetPauseOnExceptionsParams.State.NONE);
            assert (SDK_TO_WIP_CATCH_MODE.size() == JavascriptVm.ExceptionCatchMode.values().length);
        }

        private VmState() {
        }

        private SetPauseOnExceptionsParams createPauseOnExceptionRequest() {
            SetPauseOnExceptionsParams.State state = SDK_TO_WIP_CATCH_MODE.get(this.breakOnExceptionMode);
            return new SetPauseOnExceptionsParams(state);
        }

        static abstract class Variable<T> {
            Variable() {
            }

            abstract T getValue(VmState var1);

            abstract void setValue(VmState var1, T var2);

            abstract WipParams createRequestParams(VmState var1);
        }
    }
}

