/*******************************************************************************
 * Copyright (c) 2005, 2013 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0, which accompanies this distribution
 * and is available at http://www.eclipse.org/legal/epl-v10.html.
 * 
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.jpt.common.utility.transformer;

/**
 * Used by various "pluggable" classes to transform objects.
 * Transform an <em>input</em> object of type <code>I</code>
 * to an <em>output</em> object of type <code>O</code>.
 * Allow for the transformer to throw an {@link InterruptedException}.
 * <p>
 * Provisional API: This interface is part of an interim API that is still
 * under development and expected to change significantly before reaching
 * stability. It is available at this early stage to solicit feedback from
 * pioneering adopters on the understanding that any code that uses this API
 * will almost certainly be broken (repeatedly) as the API evolves.
 * 
 * @param <I> input: the type of the object passed to the transformer
 * @param <O> output: the type of the object returned by the transformer
 * 
 * @see Transformer
 * @see org.eclipse.jpt.common.utility.closure.InterruptibleClosure
 * @see org.eclipse.jpt.common.utility.command.InterruptibleCommand
 * @see org.eclipse.jpt.common.utility.factory.InterruptibleFactory
 */
public interface InterruptibleTransformer<I, O> {
	/**
	 * Return the transformed object.
	 * The semantics of "transform" is determined by the
	 * contract between the client and the server.
	 */
	O transform(I input) throws InterruptedException;
}
