/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.collection.Bag;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jaxb.core.JaxbNode;
import org.eclipse.jpt.jaxb.core.context.XmlElement;
import org.eclipse.jpt.jaxb.core.context.XmlElementWrapper;
import org.eclipse.jpt.jaxb.core.context.XmlIDREF;
import org.eclipse.jpt.jaxb.core.context.XmlSchemaType;
import org.eclipse.jpt.jaxb.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.java.JavaXmlElementsMapping;
import org.eclipse.jpt.jaxb.core.internal.AbstractJaxbNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaAdaptableAttributeMapping;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaXmlElement;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaXmlElementWrapper;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaXmlIDREF;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementWrapperAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementsAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlIDREFAnnotation;
import org.eclipse.jpt.jaxb.core.validation.JptJaxbCoreValidationMessages;
import org.eclipse.jpt.jaxb.core.xsd.XsdElementDeclaration;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class GenericJavaXmlElementsMapping
extends AbstractJavaAdaptableAttributeMapping<XmlElementsAnnotation>
implements JavaXmlElementsMapping {
    protected final AbstractJaxbNode.ContextListContainer<XmlElement, XmlElementAnnotation> xmlElementContainer = this.buildXmlElementContainer();
    protected XmlElementWrapper xmlElementWrapper;
    protected XmlIDREF xmlIDREF;
    protected static final Transformer<XmlElement, GenericJavaXmlIDREF.ValidatableReference> XML_ELEMENT_TRANSFORMER = new XmlElementTransformer();

    public GenericJavaXmlElementsMapping(JavaPersistentAttribute parent) {
        super(parent);
        this.initializeXmlElementWrapper();
        this.initializeXmlIDREF();
    }

    @Override
    public String getKey() {
        return "xml-elements";
    }

    @Override
    protected String getAnnotationName() {
        return "javax.xml.bind.annotation.XmlElements";
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.xmlElementContainer.synchronizeWithResourceModel();
        this.syncXmlElementWrapper();
        this.syncXmlIDREF();
    }

    @Override
    public void update() {
        super.update();
        this.xmlElementContainer.update();
        this.updateXmlElementWrapper();
        this.updateXmlIDREF();
    }

    @Override
    public ListIterable<XmlElement> getXmlElements() {
        return this.xmlElementContainer.getContextElements();
    }

    @Override
    public int getXmlElementsSize() {
        return this.xmlElementContainer.getContextElementsSize();
    }

    @Override
    public XmlElement addXmlElement(int index) {
        XmlElementAnnotation annotation = ((XmlElementsAnnotation)this.getAnnotation()).addXmlElement(index);
        return (XmlElement)this.xmlElementContainer.addContextElement(index, annotation);
    }

    @Override
    public void removeXmlElement(int index) {
        ((XmlElementsAnnotation)this.getAnnotation()).removeXmlElement(index);
        this.xmlElementContainer.removeContextElement(index);
    }

    @Override
    public void removeXmlElement(XmlElement xmlElement) {
        this.removeXmlElement(this.xmlElementContainer.indexOfContextElement(xmlElement));
    }

    @Override
    public void moveXmlElement(int targetIndex, int sourceIndex) {
        ((XmlElementsAnnotation)this.getAnnotation()).moveXmlElement(targetIndex, sourceIndex);
        this.xmlElementContainer.moveContextElement(targetIndex, sourceIndex);
    }

    protected XmlElement buildXmlElement(XmlElementAnnotation xmlElementAnnotation) {
        return new GenericJavaXmlElement(this, new XmlElementContext(xmlElementAnnotation));
    }

    protected ListIterable<XmlElementAnnotation> getXmlElementAnnotations() {
        return ((XmlElementsAnnotation)this.getAnnotation()).getXmlElements();
    }

    @Override
    public XmlElementWrapper getXmlElementWrapper() {
        return this.xmlElementWrapper;
    }

    @Override
    public XmlElementWrapper addXmlElementWrapper() {
        if (this.xmlElementWrapper != null) {
            throw new IllegalStateException();
        }
        this.getJavaResourceAttribute().addAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        XmlElementWrapper xmlElementWrapper = this.buildXmlElementWrapper();
        this.setXmlElementWrapper_(xmlElementWrapper);
        return xmlElementWrapper;
    }

    @Override
    public void removeXmlElementWrapper() {
        if (this.xmlElementWrapper == null) {
            throw new IllegalStateException();
        }
        this.getJavaResourceAttribute().removeAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        this.setXmlElementWrapper_(null);
    }

    protected void setXmlElementWrapper_(XmlElementWrapper xmlElementWrapper) {
        XmlElementWrapper oldXmlElementWrapper = this.xmlElementWrapper;
        this.xmlElementWrapper = xmlElementWrapper;
        this.firePropertyChanged("xmlElementWrapper", oldXmlElementWrapper, xmlElementWrapper);
    }

    protected XmlElementWrapper buildXmlElementWrapper() {
        return new GenericJavaXmlElementWrapper(this, new GenericJavaXmlElementWrapper.SimpleContext(this.getXmlElementWrapperAnnotation()));
    }

    protected XmlElementWrapperAnnotation getXmlElementWrapperAnnotation() {
        return (XmlElementWrapperAnnotation)this.getJavaResourceAttribute().getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
    }

    protected void initializeXmlElementWrapper() {
        if (this.getXmlElementWrapperAnnotation() != null) {
            this.xmlElementWrapper = this.buildXmlElementWrapper();
        }
    }

    protected void syncXmlElementWrapper() {
        if (this.getXmlElementWrapperAnnotation() != null) {
            if (this.xmlElementWrapper != null) {
                this.xmlElementWrapper.synchronizeWithResourceModel();
            } else {
                this.setXmlElementWrapper_(this.buildXmlElementWrapper());
            }
        } else {
            this.setXmlElementWrapper_(null);
        }
    }

    protected void updateXmlElementWrapper() {
        if (this.xmlElementWrapper != null) {
            this.xmlElementWrapper.update();
        }
    }

    protected AbstractJaxbNode.ContextListContainer<XmlElement, XmlElementAnnotation> buildXmlElementContainer() {
        XmlElementContainer container = new XmlElementContainer();
        container.initialize();
        return container;
    }

    @Override
    public XmlIDREF getXmlIDREF() {
        return this.xmlIDREF;
    }

    protected void setXmlIDREF_(XmlIDREF xmlIDREF) {
        XmlIDREF oldXmlIDREF = this.xmlIDREF;
        this.xmlIDREF = xmlIDREF;
        this.firePropertyChanged("xmlIDREF", oldXmlIDREF, xmlIDREF);
    }

    @Override
    public XmlIDREF addXmlIDREF() {
        if (this.xmlIDREF != null) {
            throw new IllegalStateException();
        }
        this.getJavaResourceAttribute().addAnnotation("javax.xml.bind.annotation.XmlIDREF");
        XmlIDREF xmlIDREF = this.buildXmlIDREF();
        this.setXmlIDREF_(xmlIDREF);
        return xmlIDREF;
    }

    @Override
    public void removeXmlIDREF() {
        if (this.xmlIDREF == null) {
            throw new IllegalStateException();
        }
        this.getJavaResourceAttribute().removeAnnotation("javax.xml.bind.annotation.XmlIDREF");
        this.setXmlIDREF_(null);
    }

    protected void initializeXmlIDREF() {
        if (this.getXmlIDREFAnnotation() != null) {
            this.xmlIDREF = this.buildXmlIDREF();
        }
    }

    protected void syncXmlIDREF() {
        if (this.getXmlIDREFAnnotation() == null) {
            this.setXmlIDREF_(null);
        } else if (this.xmlIDREF == null) {
            this.setXmlIDREF_(this.buildXmlIDREF());
        } else {
            this.xmlIDREF.synchronizeWithResourceModel();
        }
    }

    protected void updateXmlIDREF() {
        if (this.xmlIDREF != null) {
            this.xmlIDREF.update();
        }
    }

    protected XmlIDREFAnnotation getXmlIDREFAnnotation() {
        return (XmlIDREFAnnotation)this.getJavaResourceAttribute().getAnnotation("javax.xml.bind.annotation.XmlIDREF");
    }

    protected XmlIDREF buildXmlIDREF() {
        return new GenericJavaXmlIDREF(this, this.buildXmlIDREFContext());
    }

    protected XmlIDREFContext buildXmlIDREFContext() {
        return new XmlIDREFContext();
    }

    @Override
    public Iterable<String> getReferencedXmlTypeNames() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.getReferencedXmlTypeNames(), IterableTools.children(this.getXmlElements(), XmlElement.REFERENCED_XML_TYPE_NAMES_TRANSFORMER)});
    }

    @Override
    public boolean isParticleMapping() {
        return true;
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        for (XmlElement xmlElement : this.getXmlElements()) {
            result = xmlElement.getCompletionProposals(pos);
            if (IterableTools.isEmpty(result)) continue;
            return result;
        }
        if (this.xmlElementWrapper != null && !IterableTools.isEmpty(result = this.xmlElementWrapper.getCompletionProposals(pos))) {
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateDuplicateTypesAndQNames(messages, reporter);
        for (XmlElement xmlElement : this.getXmlElements()) {
            xmlElement.validate(messages, reporter);
        }
        if (this.xmlElementWrapper != null) {
            this.xmlElementWrapper.validate(messages, reporter);
        }
        if (this.xmlIDREF != null) {
            this.xmlIDREF.validate(messages, reporter);
        }
    }

    protected void validateDuplicateTypesAndQNames(List<IMessage> messages, IReporter reporter) {
        HashBag xmlElementTypes = new HashBag();
        HashBag xmlElementQNames = new HashBag();
        for (XmlElement xmlElement : this.getXmlElements()) {
            String elementName;
            String typeName = xmlElement.getFullyQualifiedType();
            if (!StringTools.isBlank((String)typeName)) {
                xmlElementTypes.add((Object)typeName);
            }
            if (StringTools.isBlank((String)(elementName = xmlElement.getQName().getName()))) continue;
            xmlElementQNames.add((Object)new QName(xmlElement.getQName().getNamespace(), elementName));
        }
        for (XmlElement xmlElement : this.getXmlElements()) {
            this.validateDuplicateType(xmlElement, (Bag<String>)xmlElementTypes, messages);
            this.validateDuplicateQName(xmlElement, (Bag<QName>)xmlElementQNames, messages);
        }
    }

    protected void validateDuplicateType(XmlElement xmlElement, Bag<String> xmlElementTypes, List<IMessage> messages) {
        String xmlElementType = xmlElement.getFullyQualifiedType();
        if (xmlElementTypes.count((Object)xmlElementType) > 1) {
            messages.add(this.buildValidationMessage((JaxbNode)xmlElement, xmlElement.getTypeTextRange(), JptJaxbCoreValidationMessages.XML_ELEMENTS__DUPLICATE_XML_ELEMENT_TYPE, xmlElementType));
        }
    }

    protected void validateDuplicateQName(XmlElement xmlElement, Bag<QName> xmlElementQNames, List<IMessage> messages) {
        String xmlElementName;
        String xmlElementNamespace = xmlElement.getQName().getNamespace();
        if (xmlElementQNames.count((Object)new QName(xmlElementNamespace, xmlElementName = xmlElement.getQName().getName())) > 1) {
            messages.add(this.buildValidationMessage((JaxbNode)xmlElement, xmlElement.getQName().getNameValidationTextRange(), JptJaxbCoreValidationMessages.XML_ELEMENTS__DUPLICATE_XML_ELEMENT_QNAME, xmlElementName));
        }
    }

    protected class XmlElementContainer
    extends AbstractJaxbNode.ContextListContainer<XmlElement, XmlElementAnnotation> {
        protected XmlElementContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "xmlElements";
        }

        @Override
        protected XmlElement buildContextElement(XmlElementAnnotation resourceElement) {
            return GenericJavaXmlElementsMapping.this.buildXmlElement(resourceElement);
        }

        @Override
        protected ListIterable<XmlElementAnnotation> getResourceElements() {
            return GenericJavaXmlElementsMapping.this.getXmlElementAnnotations();
        }

        @Override
        protected XmlElementAnnotation getResourceElement(XmlElement contextElement) {
            return contextElement.getAnnotation(false);
        }
    }

    protected class XmlElementContext
    implements GenericJavaXmlElement.Context {
        protected XmlElementAnnotation annotation;

        protected XmlElementContext(XmlElementAnnotation annotation) {
            this.annotation = annotation;
        }

        @Override
        public XmlElementAnnotation getAnnotation(boolean createIfNull) {
            return this.annotation;
        }

        @Override
        public JavaAttributeMapping getAttributeMapping() {
            return GenericJavaXmlElementsMapping.this;
        }

        @Override
        public String getDefaultType() {
            return null;
        }

        @Override
        public XmlElementWrapper getElementWrapper() {
            return GenericJavaXmlElementsMapping.this.getXmlElementWrapper();
        }

        @Override
        public boolean hasXmlID() {
            return false;
        }

        @Override
        public boolean hasXmlIDREF() {
            return GenericJavaXmlElementsMapping.this.getXmlIDREF() != null;
        }

        @Override
        public boolean hasXmlList() {
            return false;
        }

        @Override
        public boolean hasXmlSchemaType() {
            return false;
        }

        @Override
        public XmlSchemaType getXmlSchemaType() {
            return null;
        }
    }

    public static class XmlElementTransformer
    extends TransformerAdapter<XmlElement, GenericJavaXmlIDREF.ValidatableReference> {
        public GenericJavaXmlIDREF.ValidatableReference transform(XmlElement xmlElement) {
            return new XmlElementValidatableReference(xmlElement);
        }
    }

    public static class XmlElementValidatableReference
    implements GenericJavaXmlIDREF.ValidatableReference {
        protected final XmlElement xmlElement;

        public XmlElementValidatableReference(XmlElement xmlElement) {
            this.xmlElement = xmlElement;
        }

        @Override
        public String getFullyQualifiedType() {
            return this.xmlElement.getFullyQualifiedType();
        }

        @Override
        public TextRange getTypeValidationTextRange() {
            return this.xmlElement.getTypeTextRange();
        }

        @Override
        public XsdElementDeclaration getXsdFeature() {
            return this.xmlElement.getXsdElement();
        }

        @Override
        public TextRange getXsdFeatureValidationTextRange() {
            return this.xmlElement.getQName().getNameValidationTextRange();
        }
    }

    protected class XmlIDREFContext
    implements GenericJavaXmlIDREF.Context {
        protected XmlIDREFContext() {
        }

        @Override
        public XmlIDREFAnnotation getAnnotation() {
            return GenericJavaXmlElementsMapping.this.getXmlIDREFAnnotation();
        }

        @Override
        public Iterable<GenericJavaXmlIDREF.ValidatableReference> getReferences() {
            return IterableTools.transform(GenericJavaXmlElementsMapping.this.getXmlElements(), XML_ELEMENT_TRANSFORMER);
        }

        @Override
        public boolean isList() {
            return false;
        }
    }
}

