/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jaxb.core.JptJaxbCoreMessages;
import org.eclipse.jpt.jaxb.core.context.AbstractQName;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.JaxbElementFactoryMethod;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbQName;
import org.eclipse.jpt.jaxb.core.context.JaxbTypeMapping;
import org.eclipse.jpt.jaxb.core.context.XmlRegistry;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractQNameAnnotationProxy;
import org.eclipse.jpt.jaxb.core.resource.java.QNameAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementDeclAnnotation;
import org.eclipse.jpt.jaxb.core.validation.JptJaxbCoreValidationMessages;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class GenericJavaElementFactoryMethod
extends AbstractJavaContextNode
implements JaxbElementFactoryMethod {
    protected final JavaResourceMethod resourceMethod;
    protected String scope;
    protected JaxbQName qName;
    protected JaxbQName substitutionHeadQName;
    protected String defaultValue;

    public GenericJavaElementFactoryMethod(XmlRegistry parent, JavaResourceMethod resourceMethod) {
        super(parent);
        this.resourceMethod = resourceMethod;
        this.scope = this.getResourceScope();
        this.qName = this.buildQName();
        this.substitutionHeadQName = this.buildSubstitutionHeadQName();
        this.defaultValue = this.getResourceDefaultValue();
    }

    protected JaxbQName buildQName() {
        return new XmlElementDeclQName(this);
    }

    protected JaxbQName buildSubstitutionHeadQName() {
        return new XmlElementDeclSubstitutionHeadQName(this);
    }

    protected XmlRegistry getRegistry() {
        return (XmlRegistry)this.getParent();
    }

    @Override
    public JavaResourceMethod getResourceMethod() {
        return this.resourceMethod;
    }

    protected XmlElementDeclAnnotation getXmlElementDeclAnnotation() {
        return (XmlElementDeclAnnotation)this.getResourceMethod().getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setScope_(this.getResourceScope());
        this.qName.synchronizeWithResourceModel();
        this.substitutionHeadQName.synchronizeWithResourceModel();
        this.setDefaultValue_(this.getResourceDefaultValue());
    }

    @Override
    public void update() {
        super.update();
        this.qName.update();
        this.substitutionHeadQName.update();
    }

    @Override
    public String getName() {
        return this.resourceMethod.getName();
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    protected void setScope_(String scope) {
        String old = this.scope;
        this.scope = scope;
        this.firePropertyChanged("scope", old, scope);
    }

    @Override
    public void setScope(String scope) {
        this.getXmlElementDeclAnnotation().setScope(scope);
        this.setScope_(scope);
    }

    protected String getResourceScope() {
        return this.getXmlElementDeclAnnotation().getScope();
    }

    @Override
    public String getFullyQualifiedScope() {
        return this.scope == null ? "javax.xml.bind.annotation.XmlElementDecl.GLOBAL" : this.getXmlElementDeclAnnotation().getFullyQualifiedScopeClassName();
    }

    @Override
    public boolean isGlobalScope() {
        return "javax.xml.bind.annotation.XmlElementDecl.GLOBAL".equals(this.getFullyQualifiedScope());
    }

    @Override
    public JaxbQName getQName() {
        return this.qName;
    }

    @Override
    public JaxbQName getSubstitutionHeadQName() {
        return this.substitutionHeadQName;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    protected void setDefaultValue_(String defaultValue) {
        String old = this.defaultValue;
        this.defaultValue = defaultValue;
        this.firePropertyChanged("defaultValue", old, defaultValue);
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.getXmlElementDeclAnnotation().setDefaultValue(defaultValue);
        this.setDefaultValue_(defaultValue);
    }

    protected String getResourceDefaultValue() {
        return this.getXmlElementDeclAnnotation().getDefaultValue();
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        result = this.qName.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        result = this.substitutionHeadQName.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getXmlElementDeclAnnotation().getTextRange();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.qName.validate(messages, reporter);
        this.substitutionHeadQName.validate(messages, reporter);
        JavaResourceMethod resourceMethod = this.getResourceMethod();
        this.validateMethodReturnType(resourceMethod, messages);
        if (resourceMethod.getParametersSize() != 1) {
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJaxbCoreValidationMessages.XML_ELEMENT_DECL__INVALID_METHOD_SIGNATURE_PARAM));
        }
    }

    protected void validateMethodReturnType(JavaResourceMethod resourceMethod, List<IMessage> messages) {
        if (!"javax.xml.bind.JAXBElement".equals(resourceMethod.getTypeBinding().getQualifiedName())) {
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJaxbCoreValidationMessages.XML_ELEMENT_DECL__INVALID_METHOD_SIGNATURE_RETURN_TYPE));
        }
    }

    protected class QNameAnnotationProxy
    extends AbstractQNameAnnotationProxy {
        protected QNameAnnotationProxy() {
        }

        @Override
        protected QNameAnnotation getAnnotation(boolean createIfNull) {
            return GenericJavaElementFactoryMethod.this.getXmlElementDeclAnnotation();
        }
    }

    protected class SubstitutionHeadQNameAnnotationProxy
    implements AbstractQName.ResourceProxy {
        protected SubstitutionHeadQNameAnnotationProxy() {
        }

        protected XmlElementDeclAnnotation getAnnotation() {
            return GenericJavaElementFactoryMethod.this.getXmlElementDeclAnnotation();
        }

        @Override
        public String getNamespace() {
            XmlElementDeclAnnotation annotation = this.getAnnotation();
            return annotation == null ? null : annotation.getSubstitutionHeadNamespace();
        }

        @Override
        public void setNamespace(String newSpecifiedNamespace) {
            this.getAnnotation().setSubstitutionHeadNamespace(newSpecifiedNamespace);
        }

        @Override
        public boolean namespaceTouches(int pos) {
            XmlElementDeclAnnotation annotation = this.getAnnotation();
            return annotation == null ? false : annotation.substitutionHeadNamespaceTouches(pos);
        }

        @Override
        public TextRange getNamespaceValidationTextRange() {
            XmlElementDeclAnnotation annotation = this.getAnnotation();
            return annotation == null ? null : annotation.getSubstitutionHeadNamespaceValidationTextRange();
        }

        @Override
        public String getName() {
            XmlElementDeclAnnotation annotation = this.getAnnotation();
            return annotation == null ? null : annotation.getSubstitutionHeadName();
        }

        @Override
        public void setName(String newSpecifiedName) {
            this.getAnnotation().setSubstitutionHeadName(newSpecifiedName);
        }

        @Override
        public boolean nameTouches(int pos) {
            XmlElementDeclAnnotation annotation = this.getAnnotation();
            return annotation == null ? false : annotation.substitutionHeadNameTouches(pos);
        }

        @Override
        public TextRange getNameValidationTextRange() {
            XmlElementDeclAnnotation annotation = this.getAnnotation();
            return annotation == null ? null : annotation.getSubstitutionHeadNameValidationTextRange();
        }
    }

    protected class XmlElementDeclQName
    extends AbstractQName {
        protected XmlElementDeclQName(JaxbContextNode parent) {
            super(parent, new QNameAnnotationProxy());
        }

        @Override
        protected JaxbPackage getJaxbPackage() {
            return GenericJavaElementFactoryMethod.this.getRegistry().getJaxbClass().getJaxbPackage();
        }

        @Override
        protected String buildDefaultName() {
            return null;
        }

        @Override
        protected String buildDefaultNamespace() {
            JaxbPackage jaxbPackage = this.getJaxbPackage();
            return jaxbPackage == null ? null : jaxbPackage.getNamespace();
        }

        @Override
        public Iterable<String> getNameProposals() {
            XsdSchema xsdSchema;
            if (!GenericJavaElementFactoryMethod.this.isGlobalScope()) {
                XsdTypeDefinition xsdType;
                String fqScope = GenericJavaElementFactoryMethod.this.getFullyQualifiedScope();
                JaxbTypeMapping scopeTypeMapping = GenericJavaElementFactoryMethod.this.getJaxbProject().getContextRoot().getTypeMapping(fqScope);
                if (scopeTypeMapping != null && (xsdType = scopeTypeMapping.getXsdTypeDefinition()) != null) {
                    return xsdType.getElementNameProposals(this.getNamespace(), true);
                }
            }
            if ((xsdSchema = this.getXsdSchema()) != null) {
                return xsdSchema.getElementNameProposals(this.getNamespace());
            }
            return EmptyIterable.instance();
        }

        @Override
        public Iterable<String> getNamespaceProposals() {
            XsdSchema xsdSchema = this.getXsdSchema();
            return xsdSchema == null ? EmptyIterable.instance() : xsdSchema.getNamespaceProposals();
        }

        @Override
        public String getReferencedComponentTypeDescription() {
            return JptJaxbCoreMessages.XML_ELEMENT_DESC;
        }

        @Override
        protected void validateReference(List<IMessage> messages, IReporter reporter) {
            if (!GenericJavaElementFactoryMethod.this.isGlobalScope()) {
                String fqScope = GenericJavaElementFactoryMethod.this.getFullyQualifiedScope();
                JaxbTypeMapping scopeTypeMapping = GenericJavaElementFactoryMethod.this.getJaxbProject().getContextRoot().getTypeMapping(fqScope);
                if (scopeTypeMapping != null) {
                    XsdTypeDefinition xsdType = scopeTypeMapping.getXsdTypeDefinition();
                    if (xsdType == null) {
                        return;
                    }
                    if (xsdType.getElement(this.getNamespace(), this.getName(), true) == null) {
                        messages.add(this.getUnresolveSchemaComponentMessage());
                    }
                }
            } else {
                XsdSchema xsdSchema = this.getXsdSchema();
                if (xsdSchema != null && xsdSchema.getElementDeclaration(this.getNamespace(), this.getName()) == null) {
                    messages.add(this.getUnresolveSchemaComponentMessage());
                }
            }
        }
    }

    protected class XmlElementDeclSubstitutionHeadQName
    extends AbstractQName {
        protected XmlElementDeclSubstitutionHeadQName(JaxbContextNode parent) {
            super(parent, new SubstitutionHeadQNameAnnotationProxy());
        }

        @Override
        protected JaxbPackage getJaxbPackage() {
            return GenericJavaElementFactoryMethod.this.getRegistry().getJaxbClass().getJaxbPackage();
        }

        @Override
        protected String buildDefaultName() {
            return null;
        }

        @Override
        protected String buildDefaultNamespace() {
            JaxbPackage jaxbPackage = this.getJaxbPackage();
            return jaxbPackage == null ? null : jaxbPackage.getNamespace();
        }

        @Override
        public Iterable<String> getNameProposals() {
            XsdTypeDefinition xsdType;
            String fqScope = GenericJavaElementFactoryMethod.this.getFullyQualifiedScope();
            JaxbTypeMapping scopeTypeMapping = GenericJavaElementFactoryMethod.this.getJaxbProject().getContextRoot().getTypeMapping(fqScope);
            if (scopeTypeMapping != null && (xsdType = scopeTypeMapping.getXsdTypeDefinition()) != null) {
                return xsdType.getElementNameProposals(this.getNamespace());
            }
            XsdSchema xsdSchema = this.getXsdSchema();
            if (xsdSchema != null) {
                return xsdSchema.getElementNameProposals(this.getNamespace());
            }
            return EmptyIterable.instance();
        }

        @Override
        public Iterable<String> getNamespaceProposals() {
            XsdSchema xsdSchema = this.getXsdSchema();
            return xsdSchema == null ? EmptyIterable.instance() : xsdSchema.getNamespaceProposals();
        }

        @Override
        public String getReferencedComponentTypeDescription() {
            return JptJaxbCoreMessages.SUBSTITUTION_HEAD_DESC;
        }

        @Override
        protected void validateName(List<IMessage> messages, IReporter reporter) {
            if ("".equals(this.getName())) {
                messages.add(this.buildValidationMessage(this.getNameValidationTextRange(), JptJaxbCoreValidationMessages.QNAME__MISSING_NAME, this.getReferencedComponentTypeDescription()));
            } else if (!StringTools.isBlank((String)this.getName()) && ObjectTools.equals((Object)this.getName(), (Object)GenericJavaElementFactoryMethod.this.getQName().getName())) {
                messages.add(this.buildValidationMessage(this.getNameValidationTextRange(), JptJaxbCoreValidationMessages.XML_ELEMENT_DECL__SUBST_HEAD_NAME_EQUALS_NAME));
            }
        }

        @Override
        protected void validateReference(List<IMessage> messages, IReporter reporter) {
            XsdSchema xsdSchema = this.getXsdSchema();
            if (xsdSchema != null && xsdSchema.getElementDeclaration(this.getNamespace(), this.getName()) == null) {
                messages.add(this.getUnresolveSchemaComponentMessage());
            }
            for (JaxbElementFactoryMethod elementDecl : GenericJavaElementFactoryMethod.this.getRegistry().getElementFactoryMethods()) {
                if (!ObjectTools.equals((Object)this.getName(), (Object)elementDecl.getSubstitutionHeadQName().getName()) || !ObjectTools.equals((Object)this.getNamespace(), (Object)elementDecl.getSubstitutionHeadQName().getNamespace())) continue;
                return;
            }
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJaxbCoreValidationMessages.XML_ELEMENT_DECL__SUBST_HEAD_NO_MATCHING_ELEMENT_DECL, this.getNamespace(), this.getName()));
        }
    }
}

