/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementListIterable;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.NamedColumn;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.SpecifiedRelationship;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.VirtualJoinColumn;
import org.eclipse.jpt.jpa.core.context.VirtualJoinTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedJoinTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.internal.context.AbstractJpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.orm.GenericOrmReferenceTable;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinTable;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class GenericOrmJoinTable
extends GenericOrmReferenceTable<OrmSpecifiedJoinTableRelationshipStrategy, OrmSpecifiedJoinTable.ParentAdapter, XmlJoinTable>
implements OrmSpecifiedJoinTable {
    protected final AbstractJpaContextModel.ContextListContainer<OrmSpecifiedJoinColumn, XmlJoinColumn> specifiedInverseJoinColumnContainer;
    protected final JoinColumn.ParentAdapter inverseJoinColumnParentAdapter = this.buildInverseJoinColumnParentAdapter();
    protected OrmSpecifiedJoinColumn defaultInverseJoinColumn;

    public GenericOrmJoinTable(OrmSpecifiedJoinTable.ParentAdapter parentAdapter) {
        super(parentAdapter);
        this.specifiedInverseJoinColumnContainer = this.buildSpecifiedInverseJoinColumnContainer();
    }

    @Override
    protected JoinColumn.ParentAdapter buildJoinColumnParentAdapter() {
        return new JoinColumnParentAdapter();
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.syncSpecifiedInverseJoinColumns(monitor);
        if (this.defaultInverseJoinColumn != null) {
            this.defaultInverseJoinColumn.synchronizeWithResourceModel(monitor);
        }
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.updateModels((Iterable<? extends JpaContextModel>)this.getSpecifiedInverseJoinColumns(), monitor);
        this.updateDefaultInverseJoinColumn(monitor);
    }

    @Override
    protected XmlJoinTable getXmlTable() {
        return this.getRelationshipStrategy().getXmlJoinTable();
    }

    @Override
    protected XmlJoinTable buildXmlTable() {
        return this.getRelationshipStrategy().buildXmlJoinTable();
    }

    @Override
    protected void removeXmlTable() {
        this.getRelationshipStrategy().removeXmlJoinTable();
    }

    @Override
    public ListIterable<OrmSpecifiedJoinColumn> getInverseJoinColumns() {
        return this.hasSpecifiedInverseJoinColumns() ? this.getSpecifiedInverseJoinColumns() : this.getDefaultInverseJoinColumns();
    }

    @Override
    public int getInverseJoinColumnsSize() {
        return this.hasSpecifiedInverseJoinColumns() ? this.getSpecifiedInverseJoinColumnsSize() : this.getDefaultInverseJoinColumnsSize();
    }

    @Override
    public void convertDefaultInverseJoinColumnToSpecified() {
        MappingTools.convertJoinTableDefaultToSpecifiedInverseJoinColumn(this);
    }

    @Override
    public ListIterable<OrmSpecifiedJoinColumn> getSpecifiedInverseJoinColumns() {
        return this.specifiedInverseJoinColumnContainer;
    }

    @Override
    public int getSpecifiedInverseJoinColumnsSize() {
        return this.specifiedInverseJoinColumnContainer.size();
    }

    @Override
    public boolean hasSpecifiedInverseJoinColumns() {
        return this.getSpecifiedInverseJoinColumnsSize() != 0;
    }

    @Override
    public OrmSpecifiedJoinColumn getSpecifiedInverseJoinColumn(int index) {
        return (OrmSpecifiedJoinColumn)this.specifiedInverseJoinColumnContainer.get(index);
    }

    @Override
    public OrmSpecifiedJoinColumn addSpecifiedInverseJoinColumn() {
        return this.addSpecifiedInverseJoinColumn(this.getSpecifiedInverseJoinColumnsSize());
    }

    @Override
    public OrmSpecifiedJoinColumn addSpecifiedInverseJoinColumn(int index) {
        XmlJoinTable xmlTable = (XmlJoinTable)this.getXmlTableForUpdate();
        XmlJoinColumn xmlJoinColumn = this.buildXmlJoinColumn();
        OrmSpecifiedJoinColumn joinColumn = (OrmSpecifiedJoinColumn)this.specifiedInverseJoinColumnContainer.addContextElement(index, xmlJoinColumn);
        xmlTable.getInverseJoinColumns().add(index, (Object)xmlJoinColumn);
        return joinColumn;
    }

    @Override
    public void removeSpecifiedInverseJoinColumn(SpecifiedJoinColumn joinColumn) {
        this.removeSpecifiedInverseJoinColumn(this.specifiedInverseJoinColumnContainer.indexOf((OrmSpecifiedJoinColumn)joinColumn));
    }

    @Override
    public void removeSpecifiedInverseJoinColumn(int index) {
        this.specifiedInverseJoinColumnContainer.remove(index);
        this.getXmlTable().getInverseJoinColumns().remove(index);
        this.removeXmlTableIfUnset();
    }

    @Override
    public void moveSpecifiedInverseJoinColumn(int targetIndex, int sourceIndex) {
        this.specifiedInverseJoinColumnContainer.move(targetIndex, sourceIndex);
        this.getXmlTable().getInverseJoinColumns().move(targetIndex, sourceIndex);
    }

    @Override
    public void clearSpecifiedInverseJoinColumns() {
        this.specifiedInverseJoinColumnContainer.clear();
        this.getXmlTable().getInverseJoinColumns().clear();
    }

    protected void syncSpecifiedInverseJoinColumns(IProgressMonitor monitor) {
        this.specifiedInverseJoinColumnContainer.synchronizeWithResourceModel(monitor);
    }

    protected ListIterable<XmlJoinColumn> getXmlInverseJoinColumns() {
        XmlJoinTable xmlTable = this.getXmlTable();
        return xmlTable == null ? EmptyListIterable.instance() : IterableTools.cloneLive(xmlTable.getInverseJoinColumns());
    }

    protected AbstractJpaContextModel.ContextListContainer<OrmSpecifiedJoinColumn, XmlJoinColumn> buildSpecifiedInverseJoinColumnContainer() {
        return this.buildSpecifiedContextListContainer("specifiedInverseJoinColumns", new SpecifiedInverseJoinColumnContainerAdapter());
    }

    protected JoinColumn.ParentAdapter buildInverseJoinColumnParentAdapter() {
        return new InverseJoinColumnParentAdapter();
    }

    @Override
    public OrmSpecifiedJoinColumn getDefaultInverseJoinColumn() {
        return this.defaultInverseJoinColumn;
    }

    protected void setDefaultInverseJoinColumn(OrmSpecifiedJoinColumn joinColumn) {
        OrmSpecifiedJoinColumn old = this.defaultInverseJoinColumn;
        this.defaultInverseJoinColumn = joinColumn;
        this.firePropertyChanged("defaultInverseJoinColumn", old, joinColumn);
    }

    protected ListIterable<OrmSpecifiedJoinColumn> getDefaultInverseJoinColumns() {
        return this.defaultInverseJoinColumn != null ? new SingleElementListIterable((Object)this.defaultInverseJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultInverseJoinColumnsSize() {
        return this.defaultInverseJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultInverseJoinColumn(IProgressMonitor monitor) {
        if (this.buildsDefaultInverseJoinColumn()) {
            if (this.defaultInverseJoinColumn == null) {
                this.setDefaultInverseJoinColumn(this.buildInverseJoinColumn(null));
            } else {
                this.defaultInverseJoinColumn.update(monitor);
            }
        } else {
            this.setDefaultInverseJoinColumn(null);
        }
    }

    protected boolean buildsDefaultInverseJoinColumn() {
        return !this.hasSpecifiedInverseJoinColumns();
    }

    protected OrmSpecifiedJoinTableRelationshipStrategy getRelationshipStrategy() {
        return (OrmSpecifiedJoinTableRelationshipStrategy)this.parent;
    }

    @Override
    protected String buildDefaultName() {
        return this.getRelationshipStrategy().getJoinTableDefaultName();
    }

    @Override
    public void initializeFrom(OrmSpecifiedJoinTable oldTable) {
        super.initializeFrom(oldTable);
        for (OrmSpecifiedJoinColumn joinColumn : oldTable.getSpecifiedInverseJoinColumns()) {
            this.addSpecifiedInverseJoinColumn().initializeFrom(joinColumn);
        }
    }

    @Override
    public void initializeFrom(VirtualJoinTable virtualTable) {
        super.initializeFrom(virtualTable);
        for (VirtualJoinColumn joinColumn : virtualTable.getInverseJoinColumns()) {
            this.addSpecifiedInverseJoinColumn().initializeFrom(joinColumn);
        }
    }

    protected OrmSpecifiedJoinColumn buildInverseJoinColumn(XmlJoinColumn xmlJoinColumn) {
        return this.getContextModelFactory().buildOrmJoinColumn(this.inverseJoinColumnParentAdapter, xmlJoinColumn);
    }

    @Override
    public RelationshipMapping getRelationshipMapping() {
        return this.getRelationshipStrategy().getRelationship().getMapping();
    }

    @Override
    public SpecifiedPersistentAttribute getPersistentAttribute() {
        return this.getRelationshipMapping().getPersistentAttribute();
    }

    @Override
    protected void validateJoinColumns(List<IMessage> messages, IReporter reporter) {
        super.validateJoinColumns(messages, reporter);
        this.validateModels((Iterable<? extends JpaContextModel>)this.getInverseJoinColumns(), messages, reporter);
    }

    @Override
    public boolean validatesAgainstDatabase() {
        return this.getRelationshipStrategy().validatesAgainstDatabase();
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        for (OrmSpecifiedJoinColumn column : this.getInverseJoinColumns()) {
            result = column.getCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public abstract class AbstractJoinColumnParentAdapter
    implements JoinColumn.ParentAdapter {
        @Override
        public JpaContextModel getColumnParent() {
            return GenericOrmJoinTable.this;
        }

        @Override
        public String getDefaultColumnName(NamedColumn column) {
            return MappingTools.buildJoinColumnDefaultName((JoinColumn)column, this);
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return ObjectTools.notEquals((Object)this.getDefaultTableName(), (Object)tableName);
        }

        @Override
        public Iterable<String> getCandidateTableNames() {
            return EmptyIterable.instance();
        }

        @Override
        public Table resolveDbTable(String tableName) {
            return ObjectTools.equals((Object)GenericOrmJoinTable.this.getName(), (Object)tableName) ? GenericOrmJoinTable.this.getDbTable() : null;
        }

        @Override
        public String getDefaultTableName() {
            return GenericOrmJoinTable.this.getName();
        }

        @Override
        public TextRange getValidationTextRange() {
            return GenericOrmJoinTable.this.getValidationTextRange();
        }

        protected SpecifiedRelationship getRelationship() {
            return this.getRelationshipStrategy().getRelationship();
        }

        protected OrmSpecifiedJoinTableRelationshipStrategy getRelationshipStrategy() {
            return GenericOrmJoinTable.this.getRelationshipStrategy();
        }
    }

    public class InverseJoinColumnParentAdapter
    extends AbstractJoinColumnParentAdapter {
        @Override
        public Entity getRelationshipTarget() {
            RelationshipMapping relationshipMapping = GenericOrmJoinTable.this.getRelationshipMapping();
            return relationshipMapping == null ? null : relationshipMapping.getResolvedTargetEntity();
        }

        @Override
        public String getAttributeName() {
            RelationshipMapping relationshipMapping = GenericOrmJoinTable.this.getRelationshipMapping();
            return relationshipMapping == null ? null : relationshipMapping.getName();
        }

        @Override
        public Table resolveDbTable(String tableName) {
            Table dbTable = super.resolveDbTable(tableName);
            if (dbTable != null) {
                return dbTable;
            }
            Entity relationshipTarget = this.getRelationshipTarget();
            return relationshipTarget == null ? null : relationshipTarget.resolveDbTable(tableName);
        }

        @Override
        public Table getReferencedColumnDbTable() {
            Entity relationshipTarget = this.getRelationshipTarget();
            return relationshipTarget == null ? null : relationshipTarget.getPrimaryDbTable();
        }

        @Override
        public int getJoinColumnsSize() {
            return GenericOrmJoinTable.this.getInverseJoinColumnsSize();
        }

        @Override
        public JpaValidator buildColumnValidator(NamedColumn column) {
            return this.getRelationshipStrategy().buildJoinTableInverseJoinColumnValidator((JoinColumn)column, this);
        }
    }

    public class JoinColumnParentAdapter
    extends AbstractJoinColumnParentAdapter {
        @Override
        public Entity getRelationshipTarget() {
            return this.getRelationship().getEntity();
        }

        @Override
        public String getAttributeName() {
            return MappingTools.getTargetAttributeName(GenericOrmJoinTable.this.getRelationshipMapping());
        }

        @Override
        public Table resolveDbTable(String tableName) {
            Table dbTable = super.resolveDbTable(tableName);
            return dbTable != null ? dbTable : this.getTypeMapping().resolveDbTable(tableName);
        }

        @Override
        public Table getReferencedColumnDbTable() {
            return this.getTypeMapping().getPrimaryDbTable();
        }

        protected TypeMapping getTypeMapping() {
            return this.getRelationship().getTypeMapping();
        }

        @Override
        public int getJoinColumnsSize() {
            return GenericOrmJoinTable.this.getJoinColumnsSize();
        }

        @Override
        public JpaValidator buildColumnValidator(NamedColumn column) {
            return this.getRelationshipStrategy().buildJoinTableJoinColumnValidator((JoinColumn)column, this);
        }
    }

    public class SpecifiedInverseJoinColumnContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<OrmSpecifiedJoinColumn, XmlJoinColumn> {
        @Override
        public OrmSpecifiedJoinColumn buildContextElement(XmlJoinColumn resourceElement) {
            return GenericOrmJoinTable.this.buildInverseJoinColumn(resourceElement);
        }

        @Override
        public ListIterable<XmlJoinColumn> getResourceElements() {
            return GenericOrmJoinTable.this.getXmlInverseJoinColumns();
        }

        @Override
        public XmlJoinColumn extractResourceElement(OrmSpecifiedJoinColumn contextElement) {
            return contextElement.getXmlColumn();
        }
    }
}

