/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributionController;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributionInfo;
import org.eclipse.jem.internal.proxy.core.IPDEContributeClasspath;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;

class PDEContributeClasspath
implements IPDEContributeClasspath {
    PDEContributeClasspath() {
    }

    @Override
    public void getPDEContributions(IConfigurationContributionController controller, IConfigurationContributionInfo info) throws CoreException {
        if (!info.getPluginIds().isEmpty()) {
            Set pluginIds = info.getPluginIds().keySet();
            IPluginModelBase[] allModels = PluginRegistry.getAllModels();
            ArrayList<IPluginModelBase> fragments = new ArrayList<IPluginModelBase>();
            int i = 0;
            while (i < allModels.length) {
                if (allModels[i].isFragmentModel()) {
                    fragments.add(allModels[i]);
                }
                ++i;
            }
            for (IFragmentModel iFragmentModel : fragments) {
                IFragment fragment = iFragmentModel.getFragment();
                if (!pluginIds.contains(fragment.getPluginId())) continue;
                IResource resource = fragment.getModel().getUnderlyingResource();
                if (resource != null) {
                    IProject fragProject = resource.getProject();
                    if (!fragProject.hasNature("org.eclipse.jdt.core.javanature")) continue;
                    controller.contributeProject(fragProject);
                    continue;
                }
                IPluginLibrary[] libraries = fragment.getLibraries();
                int j = 0;
                while (j < libraries.length) {
                    IPluginLibrary library = libraries[j];
                    String name = library.getName();
                    String expandedName = PDEContributeClasspath.expandLibraryName(name);
                    IPluginModelBase model = library.getPluginModel();
                    URL url = this.getPath(model, expandedName);
                    if (url != null) {
                        controller.contributeClasspath(url, 0);
                    }
                    ++j;
                }
            }
        }
    }

    private URL getPath(IPluginModelBase model, String libraryName) {
        try {
            IResource resource = model.getUnderlyingResource();
            if (resource != null) {
                IResource jarFile = resource.getProject().findMember(libraryName);
                if (jarFile != null) {
                    return jarFile.getFullPath().toFile().toURL();
                }
            } else {
                File file = new File(model.getInstallLocation(), libraryName);
                if (file.exists()) {
                    return file.toURL();
                }
            }
        }
        catch (MalformedURLException e) {
            ProxyPlugin.getPlugin().getLogger().log((Throwable)e, Level.WARNING);
        }
        return null;
    }

    private static String expandLibraryName(String source) {
        if (source == null || source.length() == 0) {
            return "";
        }
        if (source.indexOf("$ws$") != -1) {
            source = source.replaceAll("\\$ws\\$", "ws/" + TargetPlatform.getWS());
        }
        if (source.indexOf("$os$") != -1) {
            source = source.replaceAll("\\$os\\$", "os/" + TargetPlatform.getOS());
        }
        if (source.indexOf("$nl$") != -1) {
            source = source.replaceAll("\\$nl\\$", "nl/" + TargetPlatform.getNL());
        }
        if (source.indexOf("$arch$") != -1) {
            source = source.replaceAll("\\$arch\\$", "arch/" + TargetPlatform.getOSArch());
        }
        return source;
    }
}

