/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.ui.common;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.ui.EnvironmentUIMessages;

public class TimedOperation
implements IUndoableOperation {
    private AbstractOperation operation;
    private int timeout;
    private IProgressMonitor tempMonitor;
    private IAdaptable tempInfo;
    private IStatus returnStatus;
    private boolean operationComplete;
    private String timeOutMessage;
    private boolean headless = false;

    public TimedOperation(AbstractOperation operation, int timeout, String timeOutMessage) {
        this.operation = operation;
        this.timeout = timeout;
        this.timeOutMessage = timeOutMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        Thread executeThread = new Thread(new OperationRunnable());
        this.returnStatus = Status.OK_STATUS;
        this.tempMonitor = monitor;
        this.tempInfo = info;
        this.operationComplete = false;
        executeThread.start();
        AbstractOperation abstractOperation = this.operation;
        synchronized (abstractOperation) {
            while (!this.operationComplete) {
                boolean waitMore;
                try {
                    this.operation.wait(this.timeout);
                }
                catch (InterruptedException exc) {
                    String message = exc.getMessage();
                    Status errorStatus = new Status(4, "id", 0, message == null ? "" : message, (Throwable)exc);
                    executeThread.interrupt();
                    return errorStatus;
                }
                if (this.operationComplete) continue;
                Status errorStatus = new Status(4, "id", 0, EnvironmentUIMessages.MSG_ERROR_OPERATION_TIMED_OUT, null);
                if (!this.headless) {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    waitMore = MessageDialog.openConfirm((Shell)shell, (String)EnvironmentUIMessages.MSG_ERROR_OPERATION_TIMED_OUT, (String)this.timeOutMessage);
                } else {
                    waitMore = false;
                }
                if (waitMore) continue;
                executeThread.interrupt();
                this.operationComplete = true;
                return errorStatus;
            }
        }
        return this.returnStatus;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.operation.redo(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.operation.undo(monitor, info);
    }

    public IUndoContext[] getContexts() {
        return this.operation.getContexts();
    }

    public boolean hasContext(IUndoContext context) {
        return this.operation.hasContext(context);
    }

    public void addContext(IUndoContext context) {
        this.operation.addContext(context);
    }

    public boolean canExecute() {
        return this.operation.canExecute();
    }

    public boolean canRedo() {
        return this.operation.canRedo();
    }

    public boolean canUndo() {
        return this.operation.canUndo();
    }

    public void dispose() {
        this.operation.dispose();
    }

    public String getLabel() {
        return this.operation.getLabel();
    }

    public void removeContext(IUndoContext context) {
        this.operation.removeContext(context);
    }

    public void setLabel(String name) {
        this.operation.setLabel(name);
    }

    public void setHeadless(boolean headless) {
        this.headless = headless;
    }

    private class OperationRunnable
    implements Runnable {
        private OperationRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block14: {
                try {
                    try {
                        TimedOperation.this.returnStatus = TimedOperation.this.operation.execute(TimedOperation.this.tempMonitor, TimedOperation.this.tempInfo);
                    }
                    catch (Throwable exc) {
                        String message = exc.getMessage();
                        TimedOperation.this.returnStatus = (IStatus)new Status(4, "id", 0, message == null ? "" : message, exc);
                        AbstractOperation abstractOperation = TimedOperation.this.operation;
                        synchronized (abstractOperation) {
                            TimedOperation.this.operationComplete = true;
                            TimedOperation.this.operation.notify();
                            break block14;
                        }
                    }
                }
                catch (Throwable throwable) {
                    AbstractOperation abstractOperation = TimedOperation.this.operation;
                    synchronized (abstractOperation) {
                        TimedOperation.this.operationComplete = true;
                        TimedOperation.this.operation.notify();
                    }
                    throw throwable;
                }
                AbstractOperation abstractOperation = TimedOperation.this.operation;
                synchronized (abstractOperation) {
                    TimedOperation.this.operationComplete = true;
                    TimedOperation.this.operation.notify();
                }
            }
        }
    }
}

