/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.widgets;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.ui.internal.widgets.DialogPane;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.node.Node;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class Dialog<T extends Node>
extends TitleAreaDialog {
    protected final ResourceManager resourceManager;
    private final String title;
    private DialogPane<?> pane;
    private ModifiablePropertyValueModel<T> subjectHolder;

    protected Dialog(Shell parentShell, ResourceManager resourceManager) {
        this(parentShell, resourceManager, "");
    }

    protected Dialog(Shell parentShell, ResourceManager resourceManager, String title) {
        super(parentShell);
        if (resourceManager == null || title == null) {
            throw new NullPointerException();
        }
        this.resourceManager = new LocalResourceManager(resourceManager);
        this.title = title;
        this.initialize();
    }

    protected abstract DialogPane<?> buildLayout(Composite var1);

    protected T buildStateObject() {
        return null;
    }

    Node.Validator buildValidator() {
        return Node.NULL_VALIDATOR;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    public void create() {
        super.create();
        this.installSubject();
    }

    protected Control createContents(Composite parent) {
        return this.hasTitleArea() ? super.createContents(parent) : this.createDefaultContent(parent);
    }

    private Composite createDefaultContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Dialog.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        this.dialogArea = this.createDialogArea(composite);
        this.buttonBar = this.createButtonBar(composite);
        return composite;
    }

    protected Composite createDialogArea(Composite parent) {
        if (this.hasTitleArea()) {
            parent = (Composite)super.createDialogArea(parent);
        }
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        container.setLayoutData((Object)gridData);
        this.pane = this.buildLayout(container);
        this.initializeUI();
        return parent;
    }

    protected boolean hasTitleArea() {
        return false;
    }

    protected void initialize() {
        this.subjectHolder = new SimplePropertyValueModel();
    }

    protected void initializeUI() {
    }

    private void installSubject() {
        T subject = this.buildStateObject();
        if (subject != null) {
            subject.setValidator(this.buildValidator());
        }
        this.subjectHolder.setValue(subject);
    }

    protected DialogPane<?> getPane() {
        return this.pane;
    }

    public T getSubject() {
        return (T)((Node)this.subjectHolder.getValue());
    }

    protected final PropertyValueModel<T> getSubjectHolder() {
        return this.subjectHolder;
    }

    public final boolean wasCancelled() {
        return this.getReturnCode() == 1;
    }

    public final boolean wasConfirmed() {
        return this.getReturnCode() == 0;
    }

    public boolean close() {
        this.resourceManager.dispose();
        return super.close();
    }
}

