/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsp.core.internal.pagevar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jst.pagedesigner.jsp.core.internal.pagevar.PageVariableAdatperRegistry;
import org.eclipse.jst.pagedesigner.jsp.core.internal.pagevar.TagVarDescriptor;
import org.eclipse.jst.pagedesigner.jsp.core.internal.pagevar.VariableInfo;
import org.eclipse.jst.pagedesigner.jsp.core.pagevar.IVariableInfo;
import org.eclipse.jst.pagedesigner.jsp.core.pagevar.adapter.IDocumentPageVariableAdapter;
import org.eclipse.jst.pagedesigner.jsp.core.pagevar.adapter.IPageVariableAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;

public class PageVariableAdapter
implements IPageVariableAdapter {
    static final PageVariableAdapter _instance = new PageVariableAdapter();

    public static PageVariableAdapter getInstance() {
        return _instance;
    }

    private PageVariableAdapter() {
    }

    public boolean isAdapterForType(Object type) {
        return IPageVariableAdapter.class.equals(type);
    }

    private IDocumentPageVariableAdapter getDocumentAdapter(INodeNotifier notifier) {
        IDOMDocument document;
        IDOMModel model;
        if (notifier instanceof IDOMNode && (model = ((IDOMNode)notifier).getModel()) != null && (document = model.getDocument()) != null) {
            return (IDocumentPageVariableAdapter)document.getAdapterFor(IDocumentPageVariableAdapter.class);
        }
        return null;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        IDocumentPageVariableAdapter docadapter = this.getDocumentAdapter(notifier);
        switch (eventType) {
            case 4: {
                docadapter.refresh();
                break;
            }
            case 1: 
            case 5: {
                if (!(notifier instanceof Element) || !this.supportVariableInfo((Element)notifier)) break;
                docadapter.refresh();
            }
        }
    }

    @Override
    public boolean supportMultipleVariable(Element element) {
        return false;
    }

    private boolean supportVariableInfo(Element element) {
        return PageVariableAdatperRegistry.getInstance().getTagVarDescriptor(element) != null;
    }

    @Override
    public IVariableInfo getVariableInfo(Element element) {
        String type;
        String name;
        TagVarDescriptor desc = PageVariableAdatperRegistry.getInstance().getTagVarDescriptor(element);
        if (desc == null) {
            return null;
        }
        if (desc.isVarNameIsAttr()) {
            name = element.getAttribute(desc.getVarName());
            if (name == null || name.length() == 0) {
                return null;
            }
        } else {
            name = desc.getVarName();
        }
        if (desc.isVarTypeStringIsAttr()) {
            type = element.getAttribute(desc.getVarTypeString());
            if (type == null || type.length() == 0) {
                return null;
            }
        } else {
            type = desc.getVarTypeString();
        }
        return new VariableInfo(name, desc.getVarTypeMode(), type);
    }

    @Override
    public List getVariableInfos(Element element) {
        IVariableInfo info = this.getVariableInfo(element);
        if (info == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IVariableInfo> ret = new ArrayList<IVariableInfo>(1);
        ret.add(info);
        return ret;
    }
}

