/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import java.util.ArrayList;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTreeContentProvider;

public class ServerTreeContentProvider
extends AbstractTreeContentProvider {
    protected IModule module;
    protected String launchMode;
    protected boolean includeIncompatibleVersions;

    public ServerTreeContentProvider() {
    }

    public ServerTreeContentProvider(IModule module, String launchMode) {
        super(false);
        this.module = module;
        this.launchMode = launchMode;
        this.fillTree();
    }

    public void setIncludeIncompatibleVersions(boolean b) {
        this.includeIncompatibleVersions = b;
        this.fillTree();
    }

    @Override
    protected void fillTree() {
        this.clean();
        ArrayList<AbstractTreeContentProvider.TreeElement> list = new ArrayList<AbstractTreeContentProvider.TreeElement>();
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                if (this.acceptServer(servers[i])) {
                    AbstractTreeContentProvider.TreeElement te = this.getOrCreate(list, servers[i].getHost());
                    te.contents.add(servers[i]);
                    this.elementToParentMap.put(servers[i], te);
                }
                ++i;
            }
        }
        this.elements = list.toArray();
    }

    protected boolean acceptServer(IServer server) {
        if (this.module == null || this.launchMode == null) {
            return true;
        }
        if (!ServerUIPlugin.isCompatibleWithLaunchMode(server, this.launchMode)) {
            return false;
        }
        IModuleType mt = this.module.getModuleType();
        return !(this.includeIncompatibleVersions ? !ServerUtil.isSupportedModule((IModuleType[])server.getServerType().getRuntimeType().getModuleTypes(), (String)mt.getId(), null) : !ServerUtil.isSupportedModule((IModuleType[])server.getServerType().getRuntimeType().getModuleTypes(), (String)mt.getId(), (String)mt.getVersion()));
    }
}

