/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.CombinationIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jaxb.core.resource.java.XmlSchemaTypeAnnotation;

public class SourceXmlSchemaTypeAnnotation
extends SourceAnnotation
implements XmlSchemaTypeAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.xml.bind.annotation.XmlSchemaType");
    public static final DeclarationAnnotationAdapter CONTAINER_DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.xml.bind.annotation.XmlSchemaTypes");
    private final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    private final AnnotationElementAdapter<String> nameAdapter;
    private String name;
    private TextRange nameTextRange;
    private TextRange nameValidationTextRange;
    private final DeclarationAnnotationElementAdapter<String> namespaceDeclarationAdapter;
    private final AnnotationElementAdapter<String> namespaceAdapter;
    private String namespace;
    private TextRange namespaceTextRange;
    private TextRange namespaceValidationTextRange;
    private final DeclarationAnnotationElementAdapter<String> typeDeclarationAdapter;
    private final AnnotationElementAdapter<String> typeAdapter;
    private String type;
    private String fullyQualifiedType;
    private TextRange typeTextRange;

    public static SourceXmlSchemaTypeAnnotation buildSourceXmlSchemaTypeAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement, int index) {
        IndexedDeclarationAnnotationAdapter idaa = SourceXmlSchemaTypeAnnotation.buildXmlSchemaTypeDeclarationAnnotationAdapter(index);
        IndexedAnnotationAdapter iaa = SourceXmlSchemaTypeAnnotation.buildXmlSchemaTypeAnnotationAdapter(annotatedElement, idaa);
        return new SourceXmlSchemaTypeAnnotation(parent, annotatedElement, idaa, iaa);
    }

    private SourceXmlSchemaTypeAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement, IndexedDeclarationAnnotationAdapter daa, IndexedAnnotationAdapter annotationAdapter) {
        super((JavaResourceModel)parent, annotatedElement, (DeclarationAnnotationAdapter)daa, (AnnotationAdapter)annotationAdapter);
        this.nameDeclarationAdapter = this.buildNameAdapter((DeclarationAnnotationAdapter)daa);
        this.nameAdapter = this.buildAnnotationElementAdapter(this.nameDeclarationAdapter);
        this.namespaceDeclarationAdapter = this.buildNamespaceAdapter((DeclarationAnnotationAdapter)daa);
        this.namespaceAdapter = this.buildAnnotationElementAdapter(this.namespaceDeclarationAdapter);
        this.typeDeclarationAdapter = this.buildTypeAdapter((DeclarationAnnotationAdapter)daa);
        this.typeAdapter = this.buildAnnotationElementAdapter(this.typeDeclarationAdapter);
    }

    private DeclarationAnnotationElementAdapter<String> buildNameAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"name");
    }

    private DeclarationAnnotationElementAdapter<String> buildNamespaceAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"namespace");
    }

    private DeclarationAnnotationElementAdapter<String> buildTypeAdapter(DeclarationAnnotationAdapter daa) {
        return SourceXmlSchemaTypeAnnotation.buildAnnotationElementAdapter(daa, "type", (ExpressionConverter<String>)SimpleTypeStringExpressionConverter.instance());
    }

    static DeclarationAnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String> converter) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, converter);
    }

    protected AnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    public String getAnnotationName() {
        return "javax.xml.bind.annotation.XmlSchemaType";
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.name = this.buildName(astAnnotation);
        this.nameTextRange = this.buildNameTextRange(astAnnotation);
        this.nameValidationTextRange = this.buildNameValidationTextRange(astAnnotation);
        this.namespace = this.buildNamespace(astAnnotation);
        this.namespaceTextRange = this.buildNamespaceTextRange(astAnnotation);
        this.namespaceValidationTextRange = this.buildNamespaceValidationTextRange(astAnnotation);
        this.type = this.buildType(astAnnotation);
        this.fullyQualifiedType = this.buildFullyQualifiedType(astAnnotation);
        this.typeTextRange = this.buildTypeTextRange(astAnnotation);
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncName(this.buildName(astAnnotation));
        this.nameTextRange = this.buildNameTextRange(astAnnotation);
        this.nameValidationTextRange = this.buildNameValidationTextRange(astAnnotation);
        this.syncNamespace(this.buildNamespace(astAnnotation));
        this.namespaceTextRange = this.buildNamespaceTextRange(astAnnotation);
        this.namespaceValidationTextRange = this.buildNamespaceValidationTextRange(astAnnotation);
        this.syncType(this.buildType(astAnnotation));
        this.syncFullyQualifiedType(this.buildFullyQualifiedType(astAnnotation));
        this.typeTextRange = this.buildTypeTextRange(astAnnotation);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (ObjectTools.notEquals((Object)this.name, (Object)name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(Annotation astAnnotation) {
        return (String)this.nameAdapter.getValue(astAnnotation);
    }

    private TextRange buildNameTextRange(Annotation astAnnotation) {
        return this.getAnnotationElementTextRange(this.nameDeclarationAdapter, astAnnotation);
    }

    private TextRange buildNameValidationTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astAnnotation);
    }

    @Override
    public TextRange getNameTextRange() {
        return this.nameTextRange;
    }

    @Override
    public TextRange getNameValidationTextRange() {
        return this.nameValidationTextRange;
    }

    @Override
    public boolean nameTouches(int pos) {
        return this.textRangeTouches(this.nameTextRange, pos);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        if (ObjectTools.notEquals((Object)this.namespace, (Object)namespace)) {
            this.namespace = namespace;
            this.namespaceAdapter.setValue((Object)namespace);
        }
    }

    private void syncNamespace(String astNamespace) {
        String old = this.namespace;
        this.namespace = astNamespace;
        this.firePropertyChanged("namespace", old, astNamespace);
    }

    private String buildNamespace(Annotation astAnnotation) {
        return (String)this.namespaceAdapter.getValue(astAnnotation);
    }

    private TextRange buildNamespaceTextRange(Annotation astAnnotation) {
        return this.getAnnotationElementTextRange(this.namespaceDeclarationAdapter, astAnnotation);
    }

    private TextRange buildNamespaceValidationTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.namespaceDeclarationAdapter, astAnnotation);
    }

    @Override
    public TextRange getNamespaceTextRange() {
        return this.namespaceTextRange;
    }

    @Override
    public TextRange getNamespaceValidationTextRange() {
        return this.namespaceValidationTextRange;
    }

    @Override
    public boolean namespaceTouches(int pos) {
        return this.textRangeTouches(this.namespaceTextRange, pos);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        if (ObjectTools.notEquals((Object)this.type, (Object)type)) {
            this.type = type;
            this.typeAdapter.setValue((Object)type);
        }
    }

    private void syncType(String astType) {
        String old = this.type;
        this.type = astType;
        this.firePropertyChanged("type", old, astType);
    }

    private String buildType(Annotation astAnnotation) {
        return (String)this.typeAdapter.getValue(astAnnotation);
    }

    private TextRange buildTypeTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.typeDeclarationAdapter, astAnnotation);
    }

    @Override
    public TextRange getTypeTextRange() {
        return this.typeTextRange;
    }

    @Override
    public String getFullyQualifiedType() {
        return this.fullyQualifiedType;
    }

    private void syncFullyQualifiedType(String name) {
        String old = this.fullyQualifiedType;
        this.fullyQualifiedType = name;
        this.firePropertyChanged("fullyQualifiedType", old, name);
    }

    private String buildFullyQualifiedType(Annotation astAnnotation) {
        return this.type == null ? null : ASTTools.resolveFullyQualifiedName((Expression)this.typeAdapter.getExpression(astAnnotation));
    }

    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    private IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)this.annotationAdapter;
    }

    private static IndexedAnnotationAdapter buildXmlSchemaTypeAnnotationAdapter(AnnotatedElement annotatedElement, IndexedDeclarationAnnotationAdapter idaa) {
        return new ElementIndexedAnnotationAdapter(annotatedElement, idaa);
    }

    private static IndexedDeclarationAnnotationAdapter buildXmlSchemaTypeDeclarationAnnotationAdapter(int index) {
        CombinationIndexedDeclarationAnnotationAdapter idaa = new CombinationIndexedDeclarationAnnotationAdapter(DECLARATION_ANNOTATION_ADAPTER, CONTAINER_DECLARATION_ANNOTATION_ADAPTER, index, "javax.xml.bind.annotation.XmlSchemaType");
        return idaa;
    }
}

