/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.eclipse;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.command.internal.env.eclipse.BaseStatusHandler;
import org.eclipse.wst.common.environment.Choice;
import org.eclipse.wst.common.environment.StatusException;

public class AccumulateStatusHandler
extends BaseStatusHandler {
    ArrayList statusList_ = null;
    ArrayList errorList_ = null;
    ArrayList warningList_ = null;

    public AccumulateStatusHandler() {
        this.resetStatus();
    }

    public AccumulateStatusHandler(IStatus[] status) {
        this.resetStatus();
        int i = 0;
        while (i < status.length) {
            this.statusList_.add(status[i]);
            ++i;
        }
    }

    @Override
    public IStatus getStatus() {
        IStatus worstStatus = Status.OK_STATUS;
        int index = 0;
        while (index < this.statusList_.size()) {
            IStatus status = (IStatus)this.statusList_.get(index);
            if (status.getSeverity() > worstStatus.getSeverity()) {
                worstStatus = status;
            }
            ++index;
        }
        return worstStatus;
    }

    @Override
    public void resetStatus() {
        this.statusList_ = new ArrayList();
        this.errorList_ = null;
        this.warningList_ = null;
    }

    @Override
    public void report(IStatus status) throws StatusException {
        this.statusList_.add(status);
    }

    @Override
    public Choice report(IStatus status, Choice[] choices) {
        Choice result = null;
        if (choices != null && choices.length > 0) {
            result = choices[0];
        }
        this.statusList_.add(status);
        return result;
    }

    @Override
    public void reportError(IStatus status) {
        this.statusList_.add(status);
    }

    @Override
    public void reportInfo(IStatus status) {
        this.statusList_.add(status);
    }

    public IStatus[] getAllReports() {
        if (this.statusList_ == null || this.statusList_.isEmpty()) {
            return new IStatus[]{Status.OK_STATUS};
        }
        return this.statusList_.toArray(new IStatus[0]);
    }

    public IStatus[] getErrorReports() {
        if (this.errorList_ == null) {
            this.sortReports();
        }
        return this.errorList_.toArray(new IStatus[0]);
    }

    public IStatus[] getWarningReports() {
        if (this.warningList_ == null) {
            this.sortReports();
        }
        return this.warningList_.toArray(new IStatus[0]);
    }

    private void sortReports() {
        this.errorList_ = new ArrayList();
        this.warningList_ = new ArrayList();
        int index = 0;
        while (index < this.statusList_.size()) {
            IStatus status = (IStatus)this.statusList_.get(index);
            if (status.getSeverity() == 4) {
                this.errorList_.add(status);
            } else if (status.getSeverity() == 2) {
                this.warningList_.add(status);
            }
            ++index;
        }
    }
}

