/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.jdt.internal.javalite.IJavaProjectLite;
import org.eclipse.jst.common.jdt.internal.javalite.JavaCoreLite;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.classpathdep.IClasspathDependencyConstants;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEModuleHandler;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.ui.IJavaEEDeploymentAssemblySectionBuilder;
import org.eclipse.jst.j2ee.internal.ui.J2EEModuleDeploymentAssemblyVerifierHelper;
import org.eclipse.jst.j2ee.internal.ui.JavaEEComponentDependencyContentProvider;
import org.eclipse.jst.j2ee.internal.ui.JavaEEDeploymentAssemblyAdvancedSectionBuilder;
import org.eclipse.jst.j2ee.internal.ui.Messages;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wst.common.componentcore.internal.IModuleHandler;
import org.eclipse.wst.common.componentcore.internal.impl.TaskModel;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.ComponentDependencyContentProvider;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.TaskWizard;
import org.eclipse.wst.common.componentcore.ui.propertypage.AddModuleDependenciesPropertiesPage;
import org.eclipse.wst.common.componentcore.ui.propertypage.IReferenceWizardConstants;
import org.eclipse.wst.common.componentcore.ui.propertypage.ModuleAssemblyRootPage;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public class J2EEModuleDependenciesPropertyPage
extends AddModuleDependenciesPropertiesPage {
    private IJavaEEDeploymentAssemblySectionBuilder advancedHelper;
    protected List<IClasspathEntry> originalClasspathEntries = new ArrayList<IClasspathEntry>();
    protected List<ClasspathEntryProxy> currentClasspathEntries = new ArrayList<ClasspathEntryProxy>();

    public J2EEModuleDependenciesPropertyPage(IProject project, ModuleAssemblyRootPage page) {
        super(project, page);
        this.advancedHelper = this.getAdvancedSectionBuilder();
    }

    protected void initialize() {
        super.initialize();
        this.resetClasspathEntries();
    }

    protected void createTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gData = new GridData(1808);
        composite.setLayoutData((Object)gData);
        this.fillTableComposite(composite);
        this.addAdvancedComposite(composite);
    }

    private void resetClasspathEntries() {
        this.originalClasspathEntries.clear();
        this.currentClasspathEntries.clear();
        this.originalClasspathEntries.addAll(this.readRawEntries());
        for (IClasspathEntry entry : this.originalClasspathEntries) {
            this.currentClasspathEntries.add(new ClasspathEntryProxy(entry));
        }
    }

    public void performDefaults() {
        this.resetClasspathEntries();
        if (this.advancedHelper != null) {
            this.advancedHelper.loadContents();
        }
        super.performDefaults();
    }

    protected List<IClasspathEntry> readRawEntries() {
        return J2EEModuleDependenciesPropertyPage.readRawEntries(this.rootComponent);
    }

    public static List<IClasspathEntry> readRawEntries(IVirtualComponent component) {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        if (!component.getProject().isAccessible()) {
            return entries;
        }
        IJavaProjectLite javaProjectLite = JavaCoreLite.create((IProject)component.getProject());
        try {
            Map rawComponentClasspathDependencies = ClasspathDependencyUtil.getRawComponentClasspathDependencies((IJavaProjectLite)javaProjectLite, (IClasspathDependencyConstants.DependencyAttributeType)IClasspathDependencyConstants.DependencyAttributeType.CLASSPATH_COMPONENT_DEPENDENCY);
            entries.addAll(rawComponentClasspathDependencies.keySet());
        }
        catch (CoreException e) {
            J2EEUIPlugin.logError(e);
        }
        return entries;
    }

    public boolean postHandleChanges(IProgressMonitor monitor) {
        return true;
    }

    protected void handleRemoved(ArrayList<IVirtualReference> removed) {
        super.handleRemoved(removed);
        J2EEComponentClasspathUpdater.getInstance().queueUpdateEAR(this.rootComponent.getProject());
    }

    protected void remove(Object selectedItem) {
        if (selectedItem instanceof ClasspathEntryProxy) {
            ClasspathEntryProxy entry = (ClasspathEntryProxy)selectedItem;
            this.currentClasspathEntries.remove(entry);
        } else {
            super.remove(selectedItem);
        }
        if (this.advancedHelper != null) {
            this.advancedHelper.directiveRemoved(selectedItem);
        }
    }

    protected String getModuleAssemblyRootPageDescription() {
        if (JavaEEProjectUtilities.isEJBProject((IProject)this.project)) {
            return Messages.J2EEModuleDependenciesPropertyPage_3;
        }
        if (JavaEEProjectUtilities.isApplicationClientProject((IProject)this.project)) {
            return Messages.J2EEModuleDependenciesPropertyPage_4;
        }
        if (JavaEEProjectUtilities.isJCAProject((IProject)this.project)) {
            return Messages.J2EEModuleDependenciesPropertyPage_5;
        }
        return super.getModuleAssemblyRootPageDescription();
    }

    protected IModuleHandler getModuleHandler() {
        if (this.moduleHandler == null) {
            this.moduleHandler = new JavaEEModuleHandler();
        }
        return this.moduleHandler;
    }

    protected void setCustomReferenceWizardProperties(TaskModel model) {
        model.putObject("project.converter.operation.provider", (Object)this.getConverterProvider());
    }

    public IReferenceWizardConstants.ProjectConverterOperationProvider getConverterProvider() {
        return new IReferenceWizardConstants.ProjectConverterOperationProvider(){

            public IDataModelOperation getConversionOperation(IProject project) {
                return J2EEProjectUtilities.createFlexJavaProjectForProjectOperation((IProject)project);
            }
        };
    }

    protected ComponentDependencyContentProvider createProvider() {
        JavaEEComponentDependencyContentProvider provider = new JavaEEComponentDependencyContentProvider(this);
        provider.setClasspathEntries(this.currentClasspathEntries);
        return provider;
    }

    protected boolean canRemove(Object selectedObject) {
        return super.canRemove(selectedObject) && !(selectedObject instanceof JavaEEComponentDependencyContentProvider.ConsumedClasspathEntryProxy);
    }

    protected AddModuleDependenciesPropertiesPage.RuntimePathCellModifier getRuntimePathCellModifier() {
        return new AddModuleDependenciesPropertiesPage.RuntimePathCellModifier(this){

            public boolean canModify(Object element, String property) {
                if (property.equals(DEPLOY_PATH_PROPERTY) && element instanceof ClasspathEntryProxy) {
                    return true;
                }
                return super.canModify(element, property);
            }

            public Object getValue(Object element, String property) {
                if (element instanceof ClasspathEntryProxy) {
                    IClasspathEntry entry = ((ClasspathEntryProxy)element).entry;
                    IPath runtimePath = ClasspathDependencyUtil.getRuntimePath((IClasspathEntry)entry);
                    if (runtimePath.isRoot()) {
                        return runtimePath.toString();
                    }
                    return runtimePath.makeRelative().toString();
                }
                return super.getValue(element, property);
            }

            public void modify(Object element, String property, Object value) {
                AddModuleDependenciesPropertiesPage.ComponentResourceProxy originalResource = null;
                AddModuleDependenciesPropertiesPage.ComponentResourceProxy modifiedResource = null;
                if (property.equals(DEPLOY_PATH_PROPERTY)) {
                    TreeItem item = (TreeItem)element;
                    if (item.getData() instanceof AddModuleDependenciesPropertiesPage.ComponentResourceProxy) {
                        modifiedResource = (AddModuleDependenciesPropertiesPage.ComponentResourceProxy)item.getData();
                        originalResource = new AddModuleDependenciesPropertiesPage.ComponentResourceProxy(modifiedResource.source, modifiedResource.runtimePath);
                    }
                    if (item.getData() instanceof ClasspathEntryProxy) {
                        IClasspathEntry newEntry;
                        TreeItem[] components = J2EEModuleDependenciesPropertyPage.this.availableComponentsViewer.getTree().getItems();
                        int tableIndex = -1;
                        int i = 0;
                        while (i < components.length) {
                            if (components[i] == item) {
                                tableIndex = i;
                                break;
                            }
                            ++i;
                        }
                        ClasspathEntryProxy proxy = (ClasspathEntryProxy)item.getData();
                        IPath runtimePath = new Path(((String)value).trim()).makeRelative();
                        if (runtimePath.isEmpty()) {
                            runtimePath = runtimePath.makeAbsolute();
                        }
                        if (tableIndex >= 0) {
                            components[tableIndex].setText(1, runtimePath.toString());
                        }
                        if (!ClasspathDependencyUtil.isMappedIntoContainer((String)runtimePath.toString())) {
                            runtimePath = runtimePath.makeAbsolute();
                        }
                        proxy.entry = newEntry = ClasspathDependencyUtil.modifyDependencyPath((IClasspathEntry)proxy.entry, (IPath)runtimePath);
                        J2EEModuleDependenciesPropertyPage.this.resourceMappingsChanged = true;
                    }
                }
                super.modify(element, property, value);
                if (originalResource != null && J2EEModuleDependenciesPropertyPage.this.advancedHelper != null) {
                    J2EEModuleDependenciesPropertyPage.this.advancedHelper.componentResourceModified(originalResource, modifiedResource);
                }
            }
        };
    }

    protected boolean shouldSaveClasspathEntires() {
        return true;
    }

    protected boolean saveReferenceChanges() {
        boolean subResult = super.saveReferenceChanges();
        if (!subResult) {
            return subResult;
        }
        if (!this.shouldSaveClasspathEntires()) {
            return true;
        }
        HashMap<IPath, IClasspathEntry> modified = new HashMap<IPath, IClasspathEntry>();
        HashMap<IPath, IClasspathEntry> originalMap = new HashMap<IPath, IClasspathEntry>();
        for (IClasspathEntry originalEntry : this.originalClasspathEntries) {
            originalMap.put(originalEntry.getPath(), originalEntry);
        }
        for (ClasspathEntryProxy proxy : this.currentClasspathEntries) {
            IClasspathEntry currentEntry = proxy.entry;
            IPath path = currentEntry.getPath();
            IClasspathEntry originalEntry = (IClasspathEntry)originalMap.remove(path);
            if (currentEntry.equals(originalEntry)) continue;
            modified.put(path, currentEntry);
        }
        HashMap<IPath, IClasspathEntry> removed = originalMap;
        IJavaProject javaProject = JavaCore.create((IProject)this.rootComponent.getProject());
        try {
            IClasspathEntry[] rawClasspath = javaProject.getRawClasspath();
            ArrayList<IClasspathEntry> newClasspath = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] iClasspathEntryArray = rawClasspath;
            int n = rawClasspath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry newEntry;
                IClasspathEntry entry = iClasspathEntryArray[n2];
                IPath path = entry.getPath();
                if (removed.containsKey(path)) {
                    newEntry = ClasspathDependencyUtil.modifyDependencyPath((IClasspathEntry)entry, null);
                    newClasspath.add(newEntry);
                } else if (modified.containsKey(path)) {
                    newEntry = (IClasspathEntry)modified.get(path);
                    IPath runtimePath = ClasspathDependencyUtil.getRuntimePath((IClasspathEntry)newEntry);
                    if (runtimePath.toString().length() == 0) {
                        newEntry = ClasspathDependencyUtil.modifyDependencyPath((IClasspathEntry)newEntry, (IPath)new Path("/"));
                    }
                    newClasspath.add(newEntry);
                } else {
                    newClasspath.add(entry);
                }
                ++n2;
            }
            javaProject.setRawClasspath(newClasspath.toArray(new IClasspathEntry[newClasspath.size()]), null);
            this.originalClasspathEntries.clear();
            this.currentClasspathEntries.clear();
            this.resetClasspathEntries();
        }
        catch (JavaModelException e) {
            J2EEUIPlugin.logError((CoreException)((Object)e));
            return false;
        }
        return true;
    }

    protected void handleAddDirective(TaskWizard wizard) {
        List classpathEntries = (List)wizard.getTaskModel().getObject("selection");
        if (classpathEntries != null && !classpathEntries.isEmpty()) {
            for (IClasspathEntry cpe : classpathEntries) {
                this.currentClasspathEntries.add(new ClasspathEntryProxy(cpe));
            }
        } else {
            super.handleAddDirective(wizard);
        }
        if (this.advancedHelper != null) {
            this.advancedHelper.directiveAdded(wizard.getTaskModel());
        }
    }

    protected void verify() {
        this.propPage.refreshProblemsView();
    }

    public IStatus validate() {
        ArrayList<AddModuleDependenciesPropertiesPage.ComponentResourceProxy> allMappings = new ArrayList<AddModuleDependenciesPropertiesPage.ComponentResourceProxy>();
        allMappings.addAll(this.resourceMappings);
        allMappings.addAll(this.hiddenMappings);
        IStatus status = J2EEModuleDeploymentAssemblyVerifierHelper.verify(this.rootComponent, this.runtime, this.currentReferences, allMappings, this.resourceMappingsChanged, this.currentClasspathEntries);
        if (this.advancedHelper != null) {
            status = this.advancedHelper.validate(status);
        }
        return status;
    }

    protected void addAdvancedComposite(Composite parent) {
        if (this.advancedHelper != null) {
            this.advancedHelper.buildSection(parent);
            this.advancedHelper.loadContents();
        }
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (this.advancedHelper != null) {
            result &= this.advancedHelper.saveContents();
        }
        return result;
    }

    protected IJavaEEDeploymentAssemblySectionBuilder getAdvancedSectionBuilder() {
        if (this.advancedHelper == null) {
            this.advancedHelper = new JavaEEDeploymentAssemblyAdvancedSectionBuilder(this.rootComponent, this);
        }
        return this.advancedHelper;
    }

    public class ClasspathEntryProxy {
        public IClasspathEntry entry;

        public ClasspathEntryProxy(IClasspathEntry entry) {
            this.entry = entry;
        }
    }
}

